/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.FreshNameGenerator;
import com.google.gwt.dev.js.JsUnusedFunctionRemover;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsDuplicateFunctionRemover {
    private final JsProgram program;
    private FreshNameGenerator freshNameGenerator;

    public static boolean exec(JsProgram program, FreshNameGenerator nameGenerator) {
        return new JsDuplicateFunctionRemover(program, nameGenerator).execImpl();
    }

    public JsDuplicateFunctionRemover(JsProgram program, FreshNameGenerator freshNameGenerator) {
        this.program = program;
        this.freshNameGenerator = freshNameGenerator;
    }

    private boolean execImpl() {
        boolean changed = false;
        for (int i = 0; i < this.program.getFragmentCount(); ++i) {
            JsBlock fragment = this.program.getFragmentBlock(i);
            DuplicateFunctionBodyRecorder dfbr = new DuplicateFunctionBodyRecorder();
            dfbr.accept(fragment);
            HashMap<JsFunction, JsName> newNamesByHoistedFunction = Maps.newHashMap();
            Map<JsFunction, JsFunction> dupMethodMap = dfbr.getDuplicateMethodMap();
            for (JsFunction dupMethod : dupMethodMap.values()) {
                if (newNamesByHoistedFunction.containsKey(dupMethod)) continue;
                JsName newName = this.program.getScope().declareName(this.freshNameGenerator.getFreshName());
                JsFunction newFunc = new JsFunction(dupMethod.getSourceInfo(), this.program.getScope(), newName, dupMethod.isFromJava());
                newFunc.setBody(dupMethod.getBody());
                newFunc.getParameters().addAll(dupMethod.getParameters());
                fragment.getStatements().add(newFunc.makeStmt());
                newNamesByHoistedFunction.put(dupMethod, newName);
            }
            ReplaceDuplicateInvocationNameRefs rdup = new ReplaceDuplicateInvocationNameRefs(dfbr.getDuplicateMap(), dfbr.getBlacklist(), dupMethodMap, newNamesByHoistedFunction);
            rdup.accept(fragment);
            changed = changed || rdup.didChange();
        }
        if (changed) {
            JsUnusedFunctionRemover.exec(this.program);
        }
        return changed;
    }

    private class ReplaceDuplicateInvocationNameRefs
    extends JsModVisitor {
        private final Set<JsName> blacklist;
        private final Map<JsFunction, JsFunction> dupMethodMap;
        private final Map<JsFunction, JsName> hoistMap;
        private final Map<JsName, JsName> duplicateMap;

        public ReplaceDuplicateInvocationNameRefs(Map<JsName, JsName> duplicateMap, Set<JsName> blacklist, Map<JsFunction, JsFunction> dupMethodMap, Map<JsFunction, JsName> hoistMap) {
            this.duplicateMap = duplicateMap;
            this.blacklist = blacklist;
            this.dupMethodMap = dupMethodMap;
            this.hoistMap = hoistMap;
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (this.dupMethodMap.containsKey(x)) {
                ctx.replaceMe(this.hoistMap.get(this.dupMethodMap.get(x)).makeRef(x.getSourceInfo()));
            } else if (this.hoistMap.containsKey(x)) {
                ctx.replaceMe(this.hoistMap.get(x).makeRef(x.getSourceInfo()));
            }
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            JsName orig = this.duplicateMap.get(x.getName());
            if (orig != null && x.getName() != null && x.getName().getEnclosing() == JsDuplicateFunctionRemover.this.program.getScope() && !this.blacklist.contains(x.getName()) && !this.blacklist.contains(orig)) {
                ctx.replaceMe(orig.makeRef(x.getSourceInfo()));
            }
        }
    }

    private class DuplicateFunctionBodyRecorder
    extends JsVisitor {
        private final Set<JsName> dontReplace = Sets.newIdentityHashSet();
        private final Map<JsName, JsName> duplicateOriginalMap = Maps.newIdentityHashMap();
        private final Map<JsFunction, JsFunction> duplicateMethodOriginalMap = Maps.newLinkedHashMap();
        private final Stack<JsNameRef> invocationQualifiers = new Stack();
        private final Map<String, JsName> uniqueBodies = Maps.newHashMap();
        private final Map<String, JsFunction> uniqueMethodBodies = Maps.newHashMap();

        public DuplicateFunctionBodyRecorder() {
            this.invocationQualifiers.push(null);
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            if (x.getQualifier() instanceof JsNameRef) {
                this.invocationQualifiers.pop();
            }
        }

        @Override
        public void endVisit(JsNameOf x, JsContext ctx) {
            this.dontReplace.add(x.getName());
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x != this.invocationQualifiers.peek() && x.getName() != null) {
                this.dontReplace.add(x.getName());
            }
        }

        public Set<JsName> getBlacklist() {
            return this.dontReplace;
        }

        public Map<JsName, JsName> getDuplicateMap() {
            return this.duplicateOriginalMap;
        }

        public Map<JsFunction, JsFunction> getDuplicateMethodMap() {
            return this.duplicateMethodOriginalMap;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            String fnSource = x.toSource();
            String body = fnSource.substring(fnSource.indexOf("("));
            if (x.getName() != null) {
                JsName original = this.uniqueBodies.get(body);
                if (original != null) {
                    this.duplicateOriginalMap.put(x.getName(), original);
                } else {
                    this.uniqueBodies.put(body, x.getName());
                }
            } else if (x.isFromJava()) {
                JsFunction original = this.uniqueMethodBodies.get(body);
                if (original != null) {
                    this.duplicateMethodOriginalMap.put(x, original);
                } else {
                    this.uniqueMethodBodies.put(body, x);
                }
            }
            return true;
        }

        @Override
        public boolean visit(JsInvocation x, JsContext ctx) {
            if (x.getQualifier() instanceof JsNameRef) {
                this.invocationQualifiers.push((JsNameRef)x.getQualifier());
            }
            return true;
        }
    }
}

