/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsSwitch;
import com.google.gwt.dev.js.ast.JsSwitchMember;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class JsDuplicateCaseFolder {
    public static boolean exec(JsProgram program) {
        return new JsDuplicateCaseFolder().execImpl(program.getFragmentBlock(0));
    }

    private boolean execImpl(JsBlock fragment) {
        DuplicateCaseFolder dcf = new DuplicateCaseFolder();
        dcf.accept(fragment);
        return dcf.didChange();
    }

    private class DuplicateCaseFolder
    extends JsModVisitor {
        @Override
        public boolean visit(JsSwitch x, JsContext ctx) {
            boolean modified = false;
            HashMap<String, JsSwitchMember> seen = new HashMap<String, JsSwitchMember>();
            List<JsSwitchMember> cases = x.getCases();
            LinkedList<JsSwitchMember> newCases = new LinkedList<JsSwitchMember>();
            boolean hasPreviousFallthrough = false;
            for (JsSwitchMember member : cases) {
                List<JsStatement> stmts = member.getStmts();
                if (!this.unconditionalControlBreak(stmts)) {
                    hasPreviousFallthrough = true;
                    newCases.add(member);
                    continue;
                }
                String body = this.toSource(stmts);
                JsSwitchMember previousCase = (JsSwitchMember)seen.get(body);
                if (previousCase == null || hasPreviousFallthrough) {
                    newCases.add(member);
                    seen.put(body, member);
                } else {
                    int index = newCases.indexOf(previousCase);
                    member.getStmts().clear();
                    newCases.add(index, member);
                    modified = true;
                }
                hasPreviousFallthrough = false;
            }
            if (modified) {
                this.didChange = true;
                cases.clear();
                cases.addAll(newCases);
            }
            return true;
        }

        private String toSource(List<JsStatement> stmts) {
            StringBuilder sb = new StringBuilder();
            for (JsStatement stmt : stmts) {
                sb.append(stmt.toSource(true));
                sb.append("\n");
            }
            return sb.toString();
        }

        private boolean unconditionalControlBreak(List<JsStatement> stmts) {
            for (JsStatement stmt : stmts) {
                if (!stmt.unconditionalControlBreak()) continue;
                return true;
            }
            return false;
        }
    }
}

