/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVars;
import java.util.ArrayList;
import java.util.List;

public class JsBreakUpLargeVarStatements
extends JsModVisitor {
    private static final String CONFIG_PROP_MAX_VARS = "compiler.max.vars.per.var";
    private final int maxVarsPerStatement;

    public static void exec(JsProgram program, ConfigurationProperties configurationProperties) {
        new JsBreakUpLargeVarStatements(configurationProperties).accept(program);
    }

    private static JsVars last(List<JsVars> list) {
        return list.get(list.size() - 1);
    }

    private JsBreakUpLargeVarStatements(ConfigurationProperties configMap) {
        int maxVars = configMap.getInteger(CONFIG_PROP_MAX_VARS, -1);
        if (maxVars < 1) {
            throw new InternalCompilerException("Could not find property compiler.max.vars.per.var");
        }
        this.maxVarsPerStatement = maxVars;
    }

    @Override
    public void endVisit(JsVars x, JsContext context) {
        if (this.maxVarsPerStatement < 0) {
            return;
        }
        if (x.getNumVars() > this.maxVarsPerStatement) {
            ArrayList<JsVars> smallerVars = new ArrayList<JsVars>();
            smallerVars.add(this.makeNewChildVars(x));
            for (JsVars.JsVar var : x) {
                if (JsBreakUpLargeVarStatements.last(smallerVars).getNumVars() >= this.maxVarsPerStatement) {
                    smallerVars.add(this.makeNewChildVars(x));
                }
                JsBreakUpLargeVarStatements.last(smallerVars).add(var);
            }
            for (JsVars sv : smallerVars) {
                context.insertBefore(sv);
            }
            context.removeMe();
        }
    }

    private JsVars makeNewChildVars(JsVars x) {
        return new JsVars(x.getSourceInfo(), new JsVars.JsVar[0]);
    }
}

