/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.ast.JsCatch;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.Stack;

public abstract class JsAbstractSymbolResolver
extends JsVisitor {
    private final Stack<JsScope> scopeStack = new Stack();

    @Override
    public void endVisit(JsCatch x, JsContext ctx) {
        this.popScope();
    }

    @Override
    public void endVisit(JsFunction x, JsContext ctx) {
        this.popScope();
    }

    @Override
    public void endVisit(JsNameRef x, JsContext ctx) {
        if (x.isResolved()) {
            return;
        }
        if (x.getQualifier() != null) {
            this.resolveQualifiedName(x);
        } else {
            this.resolveUnqualifiedName(x);
        }
    }

    @Override
    public void endVisit(JsProgram x, JsContext ctx) {
        this.popScope();
    }

    @Override
    public boolean visit(JsCatch x, JsContext ctx) {
        this.pushScope(x.getScope());
        return true;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this.pushScope(x.getScope());
        return true;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        this.pushScope(x.getScope());
        return true;
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        if (x.getLabelExpr() instanceof JsNameRef) {
            this.resolveQualifiedName((JsNameRef)x.getLabelExpr());
        }
        this.accept(x.getValueExpr());
        return false;
    }

    protected JsScope getScope() {
        return this.scopeStack.peek();
    }

    protected abstract void resolveQualifiedName(JsNameRef var1);

    protected abstract void resolveUnqualifiedName(JsNameRef var1);

    private void popScope() {
        this.scopeStack.pop();
    }

    private void pushScope(JsScope scope) {
        this.scopeStack.push(scope);
    }
}

