/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsProgramFragment;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.thirdparty.guava.common.collect.Queues;
import java.util.Deque;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class EvalFunctionsAtTopScope
extends JsModVisitor {
    private JsStatement currentStatement;
    private final Set<JsFunction> dontMove = new HashSet<JsFunction>();
    private final Deque<ListIterator<JsStatement>> itrStack = Queues.newArrayDeque();
    private JavaToJavaScriptMap java2jsMap;
    private final Deque<JsBlock> scopeStack = Queues.newArrayDeque();

    public static void exec(JsProgram jsProgram, JavaToJavaScriptMap map) {
        EvalFunctionsAtTopScope fev = new EvalFunctionsAtTopScope(map);
        fev.accept(jsProgram);
    }

    public EvalFunctionsAtTopScope(JavaToJavaScriptMap java2jsMap) {
        this.java2jsMap = java2jsMap;
    }

    @Override
    public void endVisit(JsExprStmt x, JsContext ctx) {
        this.currentStatement = null;
    }

    @Override
    public void endVisit(JsFunction x, JsContext ctx) {
        this.scopeStack.pop();
    }

    @Override
    public void endVisit(JsProgram x, JsContext ctx) {
        this.scopeStack.pop();
    }

    @Override
    public void endVisit(JsProgramFragment x, JsContext ctx) {
        this.scopeStack.pop();
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        if (x == this.scopeStack.peek()) {
            ListIterator<JsStatement> itr = x.getStatements().listIterator();
            this.itrStack.push(itr);
            while (itr.hasNext()) {
                JsStatement stmt = itr.next();
                JsFunction func = JsUtils.isFunctionDeclaration(stmt);
                if (func != null) {
                    this.dontMove.add(func);
                }
                this.accept(stmt);
                if (func == null) continue;
                this.dontMove.remove(func);
            }
            this.itrStack.pop();
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(JsExprStmt x, JsContext ctx) {
        this.currentStatement = x;
        return true;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        if (x.getName() != null && x.getName().getNamespace() == null && !this.dontMove.contains(x) && !this.isMethodDefinition(this.currentStatement)) {
            ListIterator<JsStatement> itr = this.itrStack.peek();
            itr.previous();
            itr.add(x.makeStmt());
            itr.next();
            ctx.replaceMe(x.getName().makeRef(x.getSourceInfo().makeChild()));
        }
        this.scopeStack.push(x.getBody());
        return true;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        this.scopeStack.push(x.getGlobalBlock());
        return true;
    }

    @Override
    public boolean visit(JsProgramFragment x, JsContext ctx) {
        this.scopeStack.push(x.getGlobalBlock());
        return true;
    }

    private boolean isMethodDefinition(JsStatement currentStatement) {
        return this.java2jsMap.methodForStatement(currentStatement) != null;
    }
}

