/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.js.JsInliner;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsCase;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsDefault;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsForIn;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsIf;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DuplicateClinitRemover
extends JsModVisitor {
    private static final String NAME = JsInliner.class.getSimpleName();
    private final Set<JsFunction> called;
    private final JsProgram program;

    public DuplicateClinitRemover(JsProgram program) {
        this.program = program;
        this.called = new HashSet<JsFunction>();
    }

    public DuplicateClinitRemover(JsProgram program, Set<JsFunction> alreadyCalled) {
        this.program = program;
        this.called = new HashSet<JsFunction>(alreadyCalled);
    }

    @Override
    public boolean visit(JsBinaryOperation x, JsContext ctx) {
        if (x.getOperator() == JsBinaryOperator.COMMA) {
            boolean left = this.isDuplicateCall(x.getArg1());
            boolean right = this.isDuplicateCall(x.getArg2());
            if (left && right) {
                if (ctx.canRemove()) {
                    ctx.removeMe();
                    return false;
                }
                ctx.replaceMe(JsNullLiteral.INSTANCE);
                return false;
            }
            if (left) {
                ctx.replaceMe(this.accept(x.getArg2()));
                return false;
            }
            if (right) {
                ctx.replaceMe(this.accept(x.getArg1()));
                return false;
            }
        } else if (x.getOperator().equals(JsBinaryOperator.AND) || x.getOperator().equals(JsBinaryOperator.OR)) {
            x.setArg1(this.accept(x.getArg1()));
            x.setArg2(this.branch(x.getArg2()));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        this.branch((JsNode)((Object)x.getStatements()));
        return false;
    }

    @Override
    public boolean visit(JsCase x, JsContext ctx) {
        x.setCaseExpr(this.accept(x.getCaseExpr()));
        this.branch((JsNode)((Object)x.getStmts()));
        return false;
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        x.setTestExpression(this.accept(x.getTestExpression()));
        x.setThenExpression(this.branch(x.getThenExpression()));
        x.setElseExpression(this.branch(x.getElseExpression()));
        return false;
    }

    @Override
    public boolean visit(JsDefault x, JsContext ctx) {
        this.branch((JsNode)((Object)x.getStmts()));
        return false;
    }

    @Override
    public boolean visit(JsExprStmt x, JsContext ctx) {
        if (this.isDuplicateCall(x.getExpression())) {
            if (ctx.canRemove()) {
                ctx.removeMe();
            } else {
                ctx.replaceMe(new JsEmpty(x.getSourceInfo()));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        if (x.getInitExpr() != null) {
            x.setInitExpr(this.accept(x.getInitExpr()));
        } else if (x.getInitVars() != null) {
            x.setInitVars(this.accept(x.getInitVars()));
        }
        if (x.getCondition() != null) {
            x.setCondition(this.accept(x.getCondition()));
        }
        if (x.getIncrExpr() != null) {
            x.setIncrExpr(this.branch(x.getIncrExpr()));
        }
        x.setBody(this.branch(x.getBody()));
        return false;
    }

    @Override
    public boolean visit(JsForIn x, JsContext ctx) {
        if (x.getIterExpr() != null) {
            x.setIterExpr(this.accept(x.getIterExpr()));
        }
        x.setObjExpr(this.accept(x.getObjExpr()));
        x.setBody(this.branch(x.getBody()));
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        x.setIfExpr(this.accept(x.getIfExpr()));
        x.setThenStmt(this.branch(x.getThenStmt()));
        if (x.getElseStmt() != null) {
            x.setElseStmt(this.branch(x.getElseStmt()));
        }
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        for (JsFunction func = JsUtils.isExecuteOnce(x); func != null; func = func.getSuperClinit()) {
            this.called.add(func);
        }
        return true;
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        x.setCondition(this.accept(x.getCondition()));
        x.setBody(this.branch(x.getBody()));
        return false;
    }

    public static OptimizerStats exec(JsProgram program) {
        SpeedTracerLogger.Event optimizeJsEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE_JS, "duplicateXOremover", NAME);
        OptimizerStats stats = DuplicateClinitRemover.execImpl(program);
        optimizeJsEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private static OptimizerStats execImpl(JsProgram program) {
        OptimizerStats stats = new OptimizerStats(NAME);
        DuplicateClinitRemover r = new DuplicateClinitRemover(program);
        r.accept(program);
        if (r.didChange()) {
            stats.recordModified();
        }
        return stats;
    }

    private <T extends JsNode> void branch(List<T> x) {
        DuplicateClinitRemover dup = new DuplicateClinitRemover(this.program, this.called);
        dup.acceptWithInsertRemove(x);
        this.didChange |= dup.didChange();
    }

    private <T extends JsNode> T branch(T x) {
        DuplicateClinitRemover dup = new DuplicateClinitRemover(this.program, this.called);
        T toReturn = dup.accept(x);
        if (toReturn != x && !dup.didChange()) {
            throw new InternalCompilerException("node replacement should imply didChange()");
        }
        this.didChange |= dup.didChange();
        return toReturn;
    }

    private boolean isDuplicateCall(JsExpression x) {
        if (!(x instanceof JsInvocation)) {
            return false;
        }
        JsFunction func = JsUtils.isExecuteOnce((JsInvocation)x);
        return func != null && this.called.contains(func);
    }
}

