/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Set;

public abstract class CoverageVisitor
extends JsModVisitor {
    private int lastLine = -1;
    private String lastFile = "";
    private Set<String> instrumentedFiles;
    private final Set<JsNode> nodesInRefContext = Sets.newHashSet();

    public CoverageVisitor(Set<String> instrumentedFiles) {
        this.instrumentedFiles = instrumentedFiles;
    }

    @Override
    public void endVisit(JsArrayAccess x, JsContext ctx) {
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsBinaryOperation x, JsContext ctx) {
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsInvocation x, JsContext ctx) {
        this.nodesInRefContext.remove(x.getQualifier());
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsNameRef x, JsContext ctx) {
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsNew x, JsContext ctx) {
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsPostfixOperation x, JsContext ctx) {
        this.visitExpression(x, ctx);
    }

    @Override
    public void endVisit(JsPrefixOperation x, JsContext ctx) {
        this.visitExpression(x, ctx);
        this.nodesInRefContext.remove(x.getArg());
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        if (x.getInitExpr() != null) {
            x.setInitExpr(this.accept(x.getInitExpr()));
        } else if (x.getInitVars() != null) {
            x.setInitVars(this.accept(x.getInitVars()));
        }
        if (x.getCondition() != null) {
            this.resetPosition();
            x.setCondition(this.accept(x.getCondition()));
        }
        if (x.getIncrExpr() != null) {
            this.resetPosition();
            x.setIncrExpr(this.accept(x.getIncrExpr()));
        }
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        this.nodesInRefContext.add(x.getQualifier());
        return true;
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        x.setValueExpr(this.accept(x.getValueExpr()));
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        if (x.getOperator() == JsUnaryOperator.DELETE || x.getOperator() == JsUnaryOperator.TYPEOF) {
            this.nodesInRefContext.add(x.getArg());
        }
        return true;
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        this.resetPosition();
        x.setCondition(this.accept(x.getCondition()));
        this.accept(x.getBody());
        return false;
    }

    protected abstract void endVisit(JsExpression var1, JsContext var2);

    private void resetPosition() {
        this.lastFile = "";
        this.lastLine = -1;
    }

    private void visitExpression(JsExpression x, JsContext ctx) {
        if (ctx.isLvalue()) {
            return;
        }
        if (this.nodesInRefContext.contains(x)) {
            return;
        }
        if (!this.instrumentedFiles.contains(x.getSourceInfo().getFileName())) {
            return;
        }
        if (x.getSourceInfo().getStartLine() == this.lastLine && x.getSourceInfo().getFileName().equals(this.lastFile)) {
            return;
        }
        this.lastLine = x.getSourceInfo().getStartLine();
        this.lastFile = x.getSourceInfo().getFileName();
        this.endVisit(x, ctx);
    }
}

