/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.CoverageVisitor;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;

public class CoverageInstrumentor {
    public static final String GWT_COVERAGE_SYSTEM_PROPERTY = "gwt.coverage";
    private Multimap<String, Integer> instrumentableLines;
    private JsProgram jsProgram;
    private JsName onBeforeUnloadFnName;
    private JsName coverFnName;
    private JsName coverageFieldName;

    public static boolean isCoverageEnabled() {
        return System.getProperty(GWT_COVERAGE_SYSTEM_PROPERTY) != null;
    }

    public static void exec(JProgram jprogram, JsProgram jsProgram, JavaToJavaScriptMap jjsmap, Multimap<String, Integer> instrumentableLines) {
        CoverageInstrumentor.exec(jsProgram, instrumentableLines, JsUtils.getJsNameForMethod(jjsmap, jprogram, "CoverageUtil.onBeforeUnload"), JsUtils.getJsNameForMethod(jjsmap, jprogram, "CoverageUtil.cover"), JsUtils.getJsNameForField(jjsmap, jprogram, "CoverageUtil.coverage"));
    }

    @VisibleForTesting
    static void exec(JsProgram jsProgram, Multimap<String, Integer> instrumentableLines, JsName onBeforeUnloadFnName, JsName coverFnName, JsName coverageFieldName) {
        new CoverageInstrumentor(jsProgram, instrumentableLines, onBeforeUnloadFnName, coverFnName, coverageFieldName).execImpl();
    }

    @VisibleForTesting
    static JsObjectLiteral baselineCoverage(SourceInfo info, Multimap<String, Integer> instrumentableLines) {
        JsObjectLiteral.Builder baselineBuilder = JsObjectLiteral.builder(info);
        for (String filename : instrumentableLines.keySet()) {
            JsObjectLiteral.Builder linesBuilder = JsObjectLiteral.builder(info);
            for (int line : instrumentableLines.get(filename)) {
                linesBuilder.add(new JsNumberLiteral(info, line), (JsExpression)new JsNumberLiteral(info, 0.0));
            }
            baselineBuilder.add(new JsStringLiteral(info, filename), (JsExpression)linesBuilder.build());
        }
        return baselineBuilder.build();
    }

    private CoverageInstrumentor(JsProgram jsProgram, Multimap<String, Integer> instrumentableLines, JsName onBeforeUnloadFnName, JsName coverFnName, JsName coverageFieldName) {
        this.instrumentableLines = instrumentableLines;
        this.jsProgram = jsProgram;
        this.onBeforeUnloadFnName = onBeforeUnloadFnName;
        this.coverFnName = coverFnName;
        this.coverageFieldName = coverageFieldName;
    }

    private void addBeforeUnloadListener(SourceInfo info) {
        JsNameRef onbeforeunload = new JsNameRef(info, "onbeforeunload", new JsNameRef(info, "window"));
        JsNameRef handler = this.onBeforeUnloadFnName.makeRef(info);
        JsBinaryOperation assignment = new JsBinaryOperation(info, JsBinaryOperator.ASG, onbeforeunload, handler);
        this.jsProgram.getGlobalBlock().getStatements().add(assignment.makeStmt());
    }

    private void execImpl() {
        SourceInfo info = this.jsProgram.createSourceInfoSynthetic(this.getClass());
        this.addBeforeUnloadListener(info);
        this.initializeBaselineCoverage(info);
        new JsModVisitor(){

            @Override
            public void endVisit(JsFunction x, JsContext ctx) {
                new Instrumentor().accept(x.getBody());
            }
        }.accept(this.jsProgram);
    }

    private void initializeBaselineCoverage(SourceInfo info) {
        JsNameRef coverageObject = this.coverageFieldName.makeRef(info);
        JsBinaryOperation init = new JsBinaryOperation(info, JsBinaryOperator.ASG, coverageObject, CoverageInstrumentor.baselineCoverage(info, this.instrumentableLines));
        this.jsProgram.getGlobalBlock().getStatements().add(0, init.makeStmt());
    }

    private class Instrumentor
    extends CoverageVisitor {
        public Instrumentor() {
            super(CoverageInstrumentor.this.instrumentableLines.keySet());
        }

        @Override
        public void endVisit(JsExpression x, JsContext ctx) {
            SourceInfo info = x.getSourceInfo();
            if (!CoverageInstrumentor.this.instrumentableLines.containsEntry(info.getFileName(), info.getStartLine())) {
                return;
            }
            JsInvocation update = new JsInvocation(info, (JsExpression)CoverageInstrumentor.this.coverFnName.makeRef(info), new JsStringLiteral(info, info.getFileName()), new JsNumberLiteral(info, info.getStartLine()));
            ctx.replaceMe(new JsBinaryOperation(info, JsBinaryOperator.COMMA, update, x));
        }
    }
}

