/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.js.CoverageVisitor;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class BaselineCoverageGatherer {
    private Multimap<String, Integer> instrumentableLines = HashMultimap.create();
    private Set<String> instrumentedFiles;
    private JProgram jProgram;

    public static Multimap<String, Integer> exec(JProgram jProgram) {
        return new BaselineCoverageGatherer(jProgram, BaselineCoverageGatherer.getCoveredSourceFiles()).execImpl();
    }

    private static Set<String> getCoveredSourceFiles() {
        String filename = System.getProperty("gwt.coverage");
        if (filename.indexOf(44) != -1) {
            return ImmutableSet.copyOf(filename.split(","));
        }
        File instrumentationFile = new File(filename);
        try {
            return Sets.newHashSet(Files.readLines(instrumentationFile, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new InternalCompilerException("Could not open " + filename, e);
        }
    }

    private BaselineCoverageGatherer(JProgram jProgram, Set<String> instrumentedFiles) {
        this.jProgram = jProgram;
        this.instrumentedFiles = instrumentedFiles;
    }

    private void cover(SourceInfo info) {
        if (this.instrumentedFiles.contains(info.getFileName())) {
            this.instrumentableLines.put(info.getFileName(), info.getStartLine());
        }
    }

    private Multimap<String, Integer> execImpl() {
        new JVisitor(){

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                if (x.getTarget().isSynthetic() || x.getTarget().isConstructor() && ((JConstructor)x.getTarget()).isDefaultConstructor()) {
                    return;
                }
                this.endVisit((JExpression)x, ctx);
            }

            @Override
            public void endVisit(JThisRef x, Context ctx) {
                if (x.getSourceInfo().equals(x.getClassType().getSourceInfo())) {
                    return;
                }
                this.endVisit((JExpression)x, ctx);
            }

            @Override
            public void endVisit(JClassLiteral x, Context ctx) {
                if (x.getSourceInfo().equals(x.getRefType().getSourceInfo())) {
                    return;
                }
                this.endVisit((JExpression)x, ctx);
            }

            @Override
            public void endVisit(JExpression x, Context ctx) {
                BaselineCoverageGatherer.this.cover(x.getSourceInfo());
            }

            @Override
            public void endVisit(JsniMethodBody x, Context ctx) {
                new CoverageVisitor(BaselineCoverageGatherer.this.instrumentedFiles){

                    @Override
                    public void endVisit(JsExpression x, JsContext ctx) {
                        BaselineCoverageGatherer.this.cover(x.getSourceInfo());
                    }
                }.accept(x.getFunc());
            }

            @Override
            public boolean visit(JDeclarationStatement x, Context ctx) {
                return !(x.getInitializer() instanceof JValueLiteral) || !(x.getVariableRef().getTarget() instanceof JField);
            }

            @Override
            public boolean visit(JMethodCall x, Context ctx) {
                return false;
            }
        }.accept(this.jProgram);
        return this.instrumentableLines;
    }
}

