/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.unreachable;

import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNopNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgStatementNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgUtil;
import com.google.gwt.dev.jjs.impl.gflow.unreachable.DeleteNodeVisitor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

class DeleteNodeTransformation
implements TransformationFunction.Transformation<CfgTransformer, Cfg> {
    private final Cfg graph;
    private final CfgNode<?> node;

    public DeleteNodeTransformation(Cfg graph, CfgNode<?> node) {
        this.graph = graph;
        this.node = node;
    }

    @Override
    public CfgTransformer getGraphTransformer() {
        return new CfgTransformer(){

            @Override
            public boolean transform(CfgNode<?> node, Cfg cfgGraph) {
                if (node.getParent() == null) {
                    throw new IllegalArgumentException("Null parent in " + node);
                }
                Object jNode = node.getJNode();
                if (node instanceof CfgStatementNode && !(jNode instanceof JBlock)) {
                    CfgNode<?> parentNode = CfgUtil.findParentOfContainingStatement(node);
                    Object parentJNode = parentNode.getJNode();
                    boolean didChange = DeleteNodeVisitor.delete(jNode, parentJNode);
                    Preconditions.checkState(didChange, "Can't delete %s (%s) from under %s (%s)", jNode, node, parentJNode, parentNode);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Cfg getNewSubgraph() {
        CfgNopNode newNode = new CfgNopNode(this.node.getParent(), (JNode)this.node.getJNode());
        return CfgUtil.createSingleNodeReplacementGraph(this.graph, this.node, newNode);
    }

    public String toString() {
        return "DeleteNodeTransformation(node=" + this.node + ")";
    }
}

