/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.liveness;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNopNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgUtil;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgWriteNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public class LivenessTransformation
implements TransformationFunction.Transformation<CfgTransformer, Cfg> {
    private final Cfg graph;
    private final CfgWriteNode writeToKill;

    public LivenessTransformation(Cfg cfg, CfgWriteNode writeToKill) {
        this.graph = cfg;
        this.writeToKill = writeToKill;
    }

    @Override
    public CfgTransformer getGraphTransformer() {
        return new CfgTransformer(){

            @Override
            public boolean transform(CfgNode<?> node, Cfg cfgGraph) {
                JModVisitor visitor = new JModVisitor(){

                    @Override
                    public void endVisit(JBinaryOperation x, Context ctx) {
                        if (!this.shouldKill(x)) {
                            return;
                        }
                        ctx.replaceMe(x.getRhs());
                    }

                    @Override
                    public void endVisit(JDeclarationStatement x, Context ctx) {
                        if (LivenessTransformation.this.writeToKill.getValue() != x.getInitializer() || x != LivenessTransformation.this.writeToKill.getJNode()) {
                            return;
                        }
                        if (x.getInitializer().hasSideEffects()) {
                            ctx.insertBefore(x.getInitializer().makeStatement());
                        }
                        x.initializer = null;
                        this.madeChanges();
                    }

                    @Override
                    public boolean visit(JExpressionStatement x, Context ctx) {
                        JBinaryOperation binop;
                        JExpression expr = x.getExpr();
                        if (expr instanceof JBinaryOperation && this.shouldKill(binop = (JBinaryOperation)expr) && !binop.getRhs().hasSideEffects()) {
                            ctx.removeMe();
                            return false;
                        }
                        return true;
                    }

                    private boolean shouldKill(JBinaryOperation x) {
                        return LivenessTransformation.this.writeToKill.getJNode() == x;
                    }
                };
                CfgNode<?> parentNode = CfgUtil.findParentOfContainingStatement(node);
                Preconditions.checkNotNull(parentNode, "Can't find parent of stmt of %s", node);
                Object parentJNode = parentNode.getJNode();
                visitor.accept((JNode)parentJNode);
                Preconditions.checkState(visitor.didChange(), "Can't remove write in %s", node.getJNode());
                return visitor.didChange();
            }
        };
    }

    @Override
    public Cfg getNewSubgraph() {
        CfgNopNode newNode = new CfgNopNode(this.writeToKill.getParent(), (JNode)this.writeToKill.getJNode());
        return CfgUtil.createSingleNodeReplacementGraph(this.graph, this.writeToKill, newNode);
    }
}

