/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.liveness;

import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.dev.util.collect.IdentityHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class LivenessAssumption
implements Assumption<LivenessAssumption> {
    private final Set<JVariable> liveVariables = new IdentityHashSet<JVariable>();

    public LivenessAssumption() {
    }

    public LivenessAssumption(LivenessAssumption assumptions) {
        if (assumptions != null) {
            this.liveVariables.addAll(assumptions.liveVariables);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LivenessAssumption other = (LivenessAssumption)obj;
        return this.liveVariables.equals(other.liveVariables);
    }

    public int hashCode() {
        return this.liveVariables.hashCode();
    }

    public boolean isLive(JVariable variable) {
        return this.liveVariables.contains(variable);
    }

    @Override
    public LivenessAssumption join(LivenessAssumption value) {
        if (value == null || value.liveVariables.isEmpty()) {
            return this;
        }
        if (this.liveVariables.isEmpty()) {
            return value;
        }
        LivenessAssumption result = new LivenessAssumption(this);
        result.liveVariables.addAll(value.liveVariables);
        return result;
    }

    public String toDebugString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        ArrayList<JVariable> vars = new ArrayList<JVariable>(this.liveVariables);
        Collections.sort(vars, new Comparator<JVariable>(){

            @Override
            public int compare(JVariable o1, JVariable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (JVariable variable : vars) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(variable.getName());
        }
        result.append("}");
        return result.toString();
    }

    public String toString() {
        return this.toDebugString();
    }

    private void kill(JVariable variable) {
        this.liveVariables.remove(variable);
    }

    private void use(JVariable variable) {
        this.liveVariables.add(variable);
    }

    public static class Updater {
        private LivenessAssumption assumption;
        private boolean copied = false;

        public Updater(LivenessAssumption assumption) {
            this.assumption = assumption;
        }

        public void kill(JVariable target) {
            if (this.assumption == null || !this.assumption.isLive(target)) {
                return;
            }
            this.copyIfNeeded();
            this.assumption.kill(target);
        }

        public LivenessAssumption unwrap() {
            if (this.assumption != null && this.assumption.liveVariables.isEmpty()) {
                return null;
            }
            return this.assumption;
        }

        public void use(JVariable target) {
            this.copyIfNeeded();
            this.assumption.use(target);
        }

        private void copyIfNeeded() {
            if (!this.copied) {
                this.assumption = new LivenessAssumption(this.assumption);
                this.copied = true;
            }
        }
    }
}

