/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.copy;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.IntegratedFlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgUtil;
import com.google.gwt.dev.jjs.impl.gflow.copy.CopyAssumption;
import com.google.gwt.dev.jjs.impl.gflow.copy.CopyFlowFunction;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public class CopyIntegratedFlowFunction
implements IntegratedFlowFunction<CfgNode<?>, CfgEdge, CfgTransformer, Cfg, CopyAssumption> {
    private static final CopyFlowFunction FLOW_FUNCTION = new CopyFlowFunction();

    @Override
    public TransformationFunction.Transformation<CfgTransformer, Cfg> interpretOrReplace(CfgNode<?> node, Cfg graph, AssumptionMap<CfgEdge, CopyAssumption> assumptionMap) {
        CopyAssumption in = AssumptionUtil.join(graph.getInEdges(node), assumptionMap);
        if (in != null && node instanceof CfgReadNode) {
            JVariable original;
            JVariable v = ((CfgReadNode)node).getTarget();
            Preconditions.checkState(v != (original = in.getOriginal(v)), "Variable is a copy of itself: %s", (Object)v);
            if (original != null) {
                return new CopyTransformation(node, original, graph);
            }
        }
        FLOW_FUNCTION.interpret(node, graph, assumptionMap);
        return null;
    }

    private final class CopyTransformation
    implements TransformationFunction.Transformation<CfgTransformer, Cfg> {
        private final CfgNode<?> node;
        private final JVariable original;
        private final Cfg graph;

        private CopyTransformation(CfgNode<?> node, JVariable original, Cfg graph) {
            this.node = node;
            this.original = original;
            this.graph = graph;
        }

        @Override
        public CfgTransformer getGraphTransformer() {
            return new CfgTransformer(){

                @Override
                public boolean transform(final CfgNode<?> node, Cfg cfgGraph) {
                    JModVisitor visitor = new JModVisitor(){

                        @Override
                        public void endVisit(JNode x, Context ctx) {
                            if (x == node.getJNode()) {
                                ctx.replaceMe(CopyTransformation.this.original.makeRef(x.getSourceInfo()));
                            }
                        }
                    };
                    CfgNode<?> parentNode = node.getParent();
                    Object parentJNode = parentNode.getJNode();
                    visitor.accept((JNode)parentJNode);
                    Preconditions.checkState(visitor.didChange());
                    return true;
                }
            };
        }

        @Override
        public Cfg getNewSubgraph() {
            CfgReadNode newNode = new CfgReadNode(this.node.getParent(), this.original.makeRef(((JNode)this.node.getJNode()).getSourceInfo()));
            return CfgUtil.createSingleNodeReplacementGraph(this.graph, this.node, newNode);
        }

        public String toString() {
            return "CopyTransformation(" + this.node + "," + this.original + ")";
        }
    }
}

