/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.copy;

import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.FlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadWriteNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgVisitor;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgWriteNode;
import com.google.gwt.dev.jjs.impl.gflow.copy.CopyAssumption;

public class CopyFlowFunction
implements FlowFunction<CfgNode<?>, CfgEdge, Cfg, CopyAssumption> {
    @Override
    public void interpret(CfgNode<?> node, Cfg g, AssumptionMap<CfgEdge, CopyAssumption> assumptionMap) {
        CopyAssumption in = AssumptionUtil.join(g.getInEdges(node), assumptionMap);
        final CopyAssumption.Updater result = new CopyAssumption.Updater(in);
        node.accept(new CfgVisitor(){

            @Override
            public void visitReadWriteNode(CfgReadWriteNode node) {
                JVariable targetVariable = node.getTargetVariable();
                if (this.isSupportedVar(targetVariable)) {
                    result.kill(targetVariable);
                }
            }

            @Override
            public void visitWriteNode(CfgWriteNode node) {
                JVariable targetVariable = node.getTargetVariable();
                if (!this.isSupportedVar(targetVariable)) {
                    return;
                }
                if (!(node.getValue() instanceof JVariableRef)) {
                    result.kill(targetVariable);
                    return;
                }
                JVariable original = ((JVariableRef)node.getValue()).getTarget();
                if ((original = result.getMostOriginal(original)) != targetVariable) {
                    result.kill(targetVariable);
                    if (this.isSupportedVar(original) && original.getType() == targetVariable.getType()) {
                        result.addCopy(original, targetVariable);
                    }
                }
            }

            private boolean isSupportedVar(JVariable targetVariable) {
                return targetVariable instanceof JParameter || targetVariable instanceof JLocal;
            }
        });
        AssumptionUtil.setAssumptions(g.getOutEdges(node), result.unwrap(), assumptionMap);
    }
}

