/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.copy;

import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

public class CopyAssumption
implements Assumption<CopyAssumption> {
    public static final CopyAssumption TOP = new CopyAssumption();
    private final Map<JVariable, JVariable> copyToOriginal;

    public CopyAssumption() {
        this.copyToOriginal = new IdentityHashMap<JVariable, JVariable>();
    }

    public CopyAssumption(CopyAssumption result) {
        this.copyToOriginal = result != null ? new IdentityHashMap<JVariable, JVariable>(result.copyToOriginal) : new IdentityHashMap<JVariable, JVariable>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyAssumption other = (CopyAssumption)obj;
        return other.copyToOriginal.equals(this.copyToOriginal);
    }

    public JVariable getOriginal(JVariable v) {
        return this.copyToOriginal.get(v);
    }

    public int hashCode() {
        return this.copyToOriginal.hashCode();
    }

    @Override
    public CopyAssumption join(CopyAssumption value) {
        if (value == null) {
            return this;
        }
        if (this == TOP || value == TOP) {
            return TOP;
        }
        if (value.copyToOriginal.isEmpty() || this.copyToOriginal.isEmpty()) {
            return null;
        }
        CopyAssumption result = new CopyAssumption();
        for (JVariable v : this.copyToOriginal.keySet()) {
            JVariable original = this.copyToOriginal.get(v);
            if (original == value.copyToOriginal.get(v)) {
                result.copyToOriginal.put(v, original);
                continue;
            }
            result.copyToOriginal.put(v, null);
        }
        return result;
    }

    public String toString() {
        if (this == TOP) {
            return "T";
        }
        StringBuilder result = new StringBuilder();
        result.append("{");
        ArrayList<JVariable> variables = new ArrayList<JVariable>(this.copyToOriginal.keySet());
        HasName.Util.sortByName(variables);
        for (JVariable variable : variables) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(variable.getName());
            result.append(" = ");
            if (this.copyToOriginal.get(variable) == null) {
                result.append("T");
                continue;
            }
            result.append(this.copyToOriginal.get(variable).getName());
        }
        result.append("}");
        return result.toString();
    }

    private void addCopy(JVariable original, JVariable copy) {
        Preconditions.checkArgument(this != TOP);
        this.copyToOriginal.put(copy, original);
    }

    private void kill(JVariable variable) {
        this.copyToOriginal.put(variable, null);
        for (JVariable jVariable : Lists.create(this.copyToOriginal.keySet())) {
            JVariable original = this.copyToOriginal.get(jVariable);
            if (original != variable) continue;
            this.copyToOriginal.put(jVariable, null);
        }
    }

    public static class Updater {
        private CopyAssumption assumption;
        private boolean copied = false;

        public Updater(CopyAssumption assumption) {
            this.assumption = assumption;
        }

        public void addCopy(JVariable original, JVariable targetVariable) {
            Preconditions.checkArgument(original != targetVariable, "Variable is a copy of itself: %s", (Object)original);
            this.copyIfNeeded();
            this.assumption.addCopy(original, targetVariable);
        }

        public JVariable getMostOriginal(JVariable variable) {
            for (int i = 0; i < 10000; ++i) {
                JVariable original = this.getOriginal(variable);
                if (original == null) {
                    return variable;
                }
                variable = original;
            }
            throw new IllegalStateException("Possible cycle detected for: variable");
        }

        public JVariable getOriginal(JVariable variable) {
            if (this.assumption == null || this.assumption == TOP) {
                return null;
            }
            return this.assumption.getOriginal(variable);
        }

        public void kill(JVariable targetVariable) {
            if (this.assumption == TOP) {
                return;
            }
            this.copyIfNeeded();
            this.assumption.kill(targetVariable);
        }

        public CopyAssumption unwrap() {
            if (this.assumption == TOP) {
                return this.assumption;
            }
            if (this.assumption != null && this.assumption.copyToOriginal.isEmpty()) {
                return null;
            }
            return this.assumption;
        }

        private void copyIfNeeded() {
            if (!this.copied) {
                this.assumption = new CopyAssumption(this.assumption);
                this.copied = true;
            }
        }
    }
}

