/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNopNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgUtil;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAssumption;
import com.google.gwt.dev.jjs.impl.gflow.constants.FoldConstantTransformer;

final class FoldConstantsTransformation
implements TransformationFunction.Transformation<CfgTransformer, Cfg> {
    private final ConstantsAssumption assumption;
    private final Cfg graph;
    private final CfgReadNode node;

    FoldConstantsTransformation(ConstantsAssumption assumptions, CfgReadNode node, Cfg graph) {
        this.assumption = assumptions;
        this.node = node;
        this.graph = graph;
    }

    @Override
    public CfgTransformer getGraphTransformer() {
        return new FoldConstantTransformer(this.assumption, this.node);
    }

    @Override
    public Cfg getNewSubgraph() {
        CfgNopNode newNode = new CfgNopNode(this.node.getParent(), (JNode)this.node.getJNode());
        return CfgUtil.createSingleNodeReplacementGraph(this.graph, this.node, newNode);
    }

    public String toString() {
        return "FoldConstantsTransformation(node=" + this.node + ", assumptions=" + this.assumption + ")";
    }
}

