/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAssumption;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

final class FoldConstantTransformer
implements CfgTransformer {
    private final ConstantsAssumption assumption;
    private CloneExpressionVisitor cloner;
    private final CfgReadNode nodeToFold;

    public FoldConstantTransformer(ConstantsAssumption assumptions, CfgReadNode nodeToFold) {
        this.assumption = assumptions;
        this.nodeToFold = nodeToFold;
        this.cloner = new CloneExpressionVisitor();
    }

    @Override
    public boolean transform(CfgNode<?> node, Cfg cfgGraph) {
        Preconditions.checkArgument(this.nodeToFold == node);
        JModVisitor visitor = new JModVisitor(){

            @Override
            public boolean visit(JVariableRef x, Context ctx) {
                JNode newNode = FoldConstantTransformer.this.transform(x);
                if (newNode != null) {
                    ctx.replaceMe(newNode);
                    return false;
                }
                return true;
            }
        };
        CfgNode<?> parentNode = this.nodeToFold.getParent();
        Object jnode = parentNode.getJNode();
        Preconditions.checkNotNull(jnode);
        visitor.accept((JNode)jnode);
        Preconditions.checkState(visitor.didChange());
        return true;
    }

    private JNode transform(JVariableRef ref) {
        if (this.nodeToFold.getJNode() != ref) {
            return null;
        }
        JVariable var = ref.getTarget();
        JValueLiteral literal = this.assumption.get(var);
        Preconditions.checkNotNull(literal);
        return this.cloner.cloneExpression(literal);
    }
}

