/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgConditionalNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgVisitor;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantConditionTransformation;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAssumption;
import com.google.gwt.dev.jjs.impl.gflow.constants.ExpressionEvaluator;
import com.google.gwt.dev.jjs.impl.gflow.constants.FoldConstantsTransformation;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public class ConstantsTransformationFunction
implements TransformationFunction<CfgNode<?>, CfgEdge, CfgTransformer, Cfg, ConstantsAssumption> {
    @Override
    public TransformationFunction.Transformation<CfgTransformer, Cfg> transform(CfgNode<?> node, Cfg graph, AssumptionMap<CfgEdge, ConstantsAssumption> assumptionMap) {
        ConstantsAssumption assumption = AssumptionUtil.join(graph.getInEdges(node), assumptionMap);
        if (assumption == null) {
            return null;
        }
        MyTransformationVisitor visitor = new MyTransformationVisitor(graph, assumption);
        node.accept(visitor);
        return visitor.result;
    }

    private final class MyTransformationVisitor
    extends CfgVisitor {
        private final ConstantsAssumption assumption;
        private final Cfg graph;
        private TransformationFunction.Transformation<CfgTransformer, Cfg> result = null;

        private MyTransformationVisitor(Cfg graph, ConstantsAssumption assumption) {
            this.graph = graph;
            this.assumption = assumption;
        }

        @Override
        public void visitConditionalNode(CfgConditionalNode<?> node) {
            JExpression condition = node.getCondition();
            if (condition instanceof JValueLiteral) {
                return;
            }
            Preconditions.checkNotNull(condition, "Null condition in %s: %s", node, node.getJNode());
            if (condition.hasSideEffects()) {
                return;
            }
            JValueLiteral evaluatedCondition = ExpressionEvaluator.evaluate(condition, this.assumption);
            if (evaluatedCondition == null || !(evaluatedCondition instanceof JBooleanLiteral)) {
                super.visitConditionalNode(node);
                return;
            }
            boolean b = ((JBooleanLiteral)evaluatedCondition).getValue();
            this.result = new ConstantConditionTransformation(this.graph, b, node);
        }

        @Override
        public void visitReadNode(CfgReadNode node) {
            if (this.assumption.hasAssumption(node.getTarget())) {
                this.result = new FoldConstantsTransformation(this.assumption, node, this.graph);
            }
        }
    }
}

