/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.FlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgConditionalNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadWriteNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgVisitor;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgWriteNode;
import com.google.gwt.dev.jjs.impl.gflow.constants.AssumptionDeducer;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAssumption;
import com.google.gwt.dev.jjs.impl.gflow.constants.ExpressionEvaluator;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;

public class ConstantsFlowFunction
implements FlowFunction<CfgNode<?>, CfgEdge, Cfg, ConstantsAssumption> {
    @Override
    public void interpret(CfgNode<?> node, final Cfg graph, AssumptionMap<CfgEdge, ConstantsAssumption> assumptionMap) {
        ConstantsAssumption in = AssumptionUtil.join(graph.getInEdges(node), assumptionMap);
        int outSize = graph.getOutEdges(node).size();
        final ArrayList result = new ArrayList(outSize);
        final ConstantsAssumption.Updater assumption = new ConstantsAssumption.Updater(in);
        node.accept(new CfgVisitor(){

            @Override
            public void visitConditionalNode(CfgConditionalNode<?> x) {
                JExpression condition = x.getCondition();
                ConstantsAssumption.Updater thenAssumptions = assumption.copy();
                ConstantsAssumption.Updater elseAssumptions = assumption.copy();
                Preconditions.checkNotNull(condition, "Null condition in %s", x);
                AssumptionDeducer.deduceAssumption(condition, JBooleanLiteral.TRUE, thenAssumptions);
                AssumptionDeducer.deduceAssumption(condition, JBooleanLiteral.FALSE, elseAssumptions);
                for (CfgEdge e : graph.getOutEdges((CfgNode<?>)x)) {
                    if ("THEN".equals(e.getRole())) {
                        result.add(thenAssumptions.unwrap());
                        continue;
                    }
                    if ("ELSE".equals(e.getRole())) {
                        result.add(elseAssumptions.unwrap());
                        continue;
                    }
                    result.add(assumption.unwrap());
                }
            }

            @Override
            public void visitNode(CfgNode<?> node) {
                for (int i = 0; i < graph.getOutEdges(node).size(); ++i) {
                    result.add(assumption.unwrap());
                }
            }

            @Override
            public void visitReadWriteNode(CfgReadWriteNode node) {
                this.processWrite(assumption, node.getTargetVariable(), node.getValue());
                super.visitReadWriteNode(node);
            }

            @Override
            public void visitWriteNode(CfgWriteNode node) {
                this.processWrite(assumption, node.getTargetVariable(), node.getValue());
                super.visitWriteNode(node);
            }

            private void processWrite(ConstantsAssumption.Updater assumption2, JVariable var, JExpression expression) {
                if (var == null) {
                    return;
                }
                if (var instanceof JParameter || var instanceof JLocal) {
                    if (expression != null) {
                        JValueLiteral valueLiteral = ExpressionEvaluator.evaluate(expression, assumption2.unwrap());
                        if (valueLiteral != null && (valueLiteral.getType() == var.getType() || valueLiteral instanceof JNullLiteral)) {
                            assumption2.set(var, valueLiteral);
                        } else {
                            assumption2.set(var, null);
                        }
                    } else {
                        assumption2.set(var, null);
                    }
                }
            }
        });
        AssumptionUtil.setAssumptions(graph.getOutEdges(node), result, assumptionMap);
    }
}

