/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConstantsAssumption
implements Assumption<ConstantsAssumption> {
    public static ConstantsAssumption TOP = new ConstantsAssumption();
    private final Map<JVariable, LiteralWrapper> values;

    private static boolean equal(JValueLiteral literal1, JValueLiteral literal2) {
        if (literal1 == null || literal2 == null) {
            return literal1 == literal2;
        }
        if (literal1 == literal2) {
            return true;
        }
        if (literal1.getClass() != literal2.getClass()) {
            return false;
        }
        if (literal1 instanceof JFloatLiteral) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(((JFloatLiteral)literal1).getValue());
            return bits1 == (bits2 = Double.doubleToRawLongBits(((JFloatLiteral)literal2).getValue()));
        }
        if (literal1 instanceof JDoubleLiteral) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(((JDoubleLiteral)literal1).getValue());
            return bits1 == (bits2 = Double.doubleToRawLongBits(((JDoubleLiteral)literal2).getValue()));
        }
        Object valueObj1 = literal1.getValueObj();
        Object valueObj2 = literal2.getValueObj();
        if (valueObj1 == null || valueObj2 == null) {
            return valueObj1 == valueObj2;
        }
        return valueObj1.equals(valueObj2);
    }

    private static JValueLiteral join(JValueLiteral value1, JValueLiteral value2) {
        if (!ConstantsAssumption.equal(value1, value2)) {
            return null;
        }
        return value1;
    }

    private static JValueLiteral join(LiteralWrapper wrapper1, LiteralWrapper wrapper2) {
        if (wrapper1 == null || wrapper2 == null) {
            return null;
        }
        return ConstantsAssumption.join(wrapper1.literal, wrapper2.literal);
    }

    public ConstantsAssumption() {
        this.values = new HashMap<JVariable, LiteralWrapper>();
    }

    public ConstantsAssumption(ConstantsAssumption a) {
        this.values = a != null ? new HashMap<JVariable, LiteralWrapper>(a.values) : new HashMap<JVariable, LiteralWrapper>();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ConstantsAssumption other = (ConstantsAssumption)obj;
        return this.values.equals(other.values);
    }

    public JValueLiteral get(JVariable variable) {
        LiteralWrapper wrapper = this.values.get(variable);
        return wrapper != null ? wrapper.literal : null;
    }

    public boolean hasAssumption(JVariable variable) {
        return this.get(variable) != null;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public ConstantsAssumption join(ConstantsAssumption other) {
        if (other == null) {
            return this;
        }
        if (other == TOP || this == TOP || this.isEmpty() || other.isEmpty()) {
            return TOP;
        }
        ConstantsAssumption result = new ConstantsAssumption();
        for (JVariable var : other.values.keySet()) {
            JValueLiteral value;
            if (!this.values.containsKey(var) || (value = ConstantsAssumption.join(this.values.get(var), other.values.get(var))) == null) continue;
            result.values.put(var, new LiteralWrapper(value));
        }
        if (result.isEmpty()) {
            return TOP;
        }
        return result;
    }

    public String toDebugString() {
        if (this == TOP || this.isEmpty()) {
            return "T";
        }
        StringBuilder result = new StringBuilder();
        result.append("{");
        ArrayList<JVariable> variables = new ArrayList<JVariable>(this.values.keySet());
        HasName.Util.sortByName(variables);
        for (JVariable variable : variables) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(variable.getName());
            result.append(" = ");
            if (this.values.get(variable) == null) {
                result.append("T");
                continue;
            }
            result.append(this.values.get(variable));
        }
        result.append("}");
        return result.toString();
    }

    public String toString() {
        return this.toDebugString();
    }

    void set(JVariable variable, JValueLiteral literal) {
        if (literal != null) {
            this.values.put(variable, new LiteralWrapper(literal));
        } else {
            this.values.remove(variable);
        }
    }

    private static class LiteralWrapper {
        private final JValueLiteral literal;

        LiteralWrapper(JValueLiteral literal) {
            Preconditions.checkNotNull(literal);
            this.literal = literal;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            LiteralWrapper other = (LiteralWrapper)obj;
            return ConstantsAssumption.equal(this.literal, other.literal);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.literal.toString();
        }
    }

    public static class Updater {
        private ConstantsAssumption assumption;
        private boolean copied = false;

        public Updater(ConstantsAssumption assumption) {
            this.assumption = assumption;
        }

        public Updater copy() {
            return new Updater(this.assumption);
        }

        public boolean hasAssumption(JVariable target) {
            if (this.assumption == null) {
                return false;
            }
            return this.assumption.hasAssumption(target);
        }

        public void set(JVariable target, JValueLiteral literal) {
            this.copyIfNeeded();
            this.assumption.set(target, literal);
        }

        public ConstantsAssumption unwrap() {
            if (this.assumption != null && this.assumption.isEmpty()) {
                return TOP;
            }
            return this.assumption;
        }

        private void copyIfNeeded() {
            if (!this.copied) {
                this.assumption = new ConstantsAssumption(this.assumption);
                this.copied = true;
            }
        }
    }
}

