/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgCaseNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgConditionalNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNopNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

final class ConstantConditionTransformation
implements TransformationFunction.Transformation<CfgTransformer, Cfg> {
    private final boolean conditionValue;
    private final CfgConditionalNode<?> node;
    private final Cfg graph;

    ConstantConditionTransformation(Cfg graph, boolean conditionValue, CfgConditionalNode<?> node) {
        this.graph = graph;
        this.conditionValue = conditionValue;
        this.node = node;
    }

    @Override
    public CfgTransformer getGraphTransformer() {
        return new CfgTransformer(){

            @Override
            public boolean transform(CfgNode<?> cfgNode, Cfg cfgGraph) {
                Preconditions.checkArgument(cfgNode == ConstantConditionTransformation.this.node);
                if (cfgNode instanceof CfgCaseNode) {
                    return false;
                }
                final JExpression oldCondition = ConstantConditionTransformation.this.node.getCondition();
                final JBooleanLiteral newCondition = JBooleanLiteral.get(ConstantConditionTransformation.this.conditionValue);
                JModVisitor visitor = new JModVisitor(){

                    @Override
                    public boolean visit(JExpression x, Context ctx) {
                        if (x == oldCondition) {
                            ctx.replaceMe(newCondition);
                            return false;
                        }
                        return true;
                    }
                };
                Object startNode = ConstantConditionTransformation.this.node.getJNode();
                visitor.accept((JNode)startNode);
                Preconditions.checkState(visitor.didChange(), "Couldn't replace %s with %s in %s", (Object)oldCondition, (Object)newCondition, startNode);
                return visitor.didChange();
            }
        };
    }

    @Override
    public Cfg getNewSubgraph() {
        Cfg newSubgraph = new Cfg();
        CfgNopNode newNode = new CfgNopNode(this.node.getParent(), (JNode)this.node.getJNode());
        newSubgraph.addNode(newNode);
        for (int i = 0; i < this.graph.getInEdges((CfgNode<?>)this.node).size(); ++i) {
            CfgEdge edge = new CfgEdge();
            newSubgraph.addIn(newNode, edge);
            newSubgraph.addGraphInEdge(edge);
        }
        for (CfgEdge e : this.graph.getOutEdges((CfgNode<?>)this.node)) {
            CfgEdge edge = new CfgEdge(e.getRole());
            newSubgraph.addGraphOutEdge(edge);
            if (e.getRole() != null && (e.getRole().equals("ELSE") && this.conditionValue || e.getRole().equals("THEN") && !this.conditionValue)) continue;
            newSubgraph.addOut(newNode, edge);
        }
        return newSubgraph;
    }

    public String toString() {
        return "ConstantConditionTransformation(node=" + this.node + ", conditionValue=" + this.conditionValue + ")";
    }
}

