/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.constants;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAssumption;

final class AssumptionDeducer
extends JVisitor {
    private final ConstantsAssumption.Updater assumption;
    private JValueLiteral currentValue;

    static void deduceAssumption(JExpression expression, JValueLiteral value, ConstantsAssumption.Updater assumption) {
        new AssumptionDeducer(value, assumption).accept(expression);
    }

    AssumptionDeducer(JValueLiteral value, ConstantsAssumption.Updater assumption) {
        this.assumption = assumption;
        this.currentValue = value;
    }

    @Override
    public boolean visit(JBinaryOperation x, Context ctx) {
        switch (x.getOp()) {
            case EQ: {
                if (!this.isTrue(this.currentValue)) break;
                if (x.getRhs() instanceof JValueLiteral && this.isSubstitutableIfEquals(x.getRhs())) {
                    this.currentValue = (JValueLiteral)x.getRhs();
                    this.accept(x.getLhs());
                    return false;
                }
                if (!(x.getLhs() instanceof JValueLiteral) || !this.isSubstitutableIfEquals(x.getLhs())) break;
                this.currentValue = (JValueLiteral)x.getLhs();
                this.accept(x.getRhs());
                return false;
            }
            case NEQ: {
                if (!this.isFalse(this.currentValue)) break;
                if (x.getRhs() instanceof JValueLiteral && this.isSubstitutableIfEquals(x.getRhs())) {
                    this.currentValue = (JValueLiteral)x.getRhs();
                    this.accept(x.getLhs());
                    return false;
                }
                if (!(x.getLhs() instanceof JValueLiteral) || !this.isSubstitutableIfEquals(x.getLhs())) break;
                this.currentValue = (JValueLiteral)x.getLhs();
                this.accept(x.getRhs());
                return false;
            }
            case AND: {
                if (!this.isTrue(this.currentValue)) break;
                this.accept(x.getLhs());
                this.currentValue = JBooleanLiteral.get(true);
                this.accept(x.getRhs());
                return false;
            }
            case OR: {
                if (!this.isFalse(this.currentValue)) break;
                this.accept(x.getLhs());
                this.currentValue = JBooleanLiteral.FALSE;
                this.accept(x.getRhs());
                return false;
            }
        }
        this.currentValue = null;
        return true;
    }

    @Override
    public boolean visit(JExpression x, Context ctx) {
        return false;
    }

    @Override
    public boolean visit(JLocalRef x, Context ctx) {
        if (this.assumption.hasAssumption(x.getTarget())) {
            return false;
        }
        this.assumption.set(x.getTarget(), this.currentValue);
        return false;
    }

    @Override
    public boolean visit(JMultiExpression x, Context ctx) {
        this.accept(x.getExpression(x.getNumberOfExpressions() - 1));
        return false;
    }

    @Override
    public boolean visit(JParameterRef x, Context ctx) {
        if (this.assumption.hasAssumption(x.getTarget())) {
            return false;
        }
        this.assumption.set(x.getTarget(), this.currentValue);
        return false;
    }

    private boolean isFalse(JValueLiteral value) {
        return value instanceof JBooleanLiteral && !((JBooleanLiteral)value).getValue();
    }

    private boolean isSubstitutableIfEquals(JExpression e) {
        if (!(e instanceof JValueLiteral)) {
            return false;
        }
        if (e instanceof JFloatLiteral && ((JFloatLiteral)e).getValue() == 0.0) {
            return false;
        }
        return !(e instanceof JDoubleLiteral) || ((JDoubleLiteral)e).getValue() != 0.0;
    }

    private boolean isTrue(JValueLiteral value) {
        return value instanceof JBooleanLiteral && ((JBooleanLiteral)value).getValue();
    }
}

