/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.cfg;

import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgSimpleNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgVisitor;

public class CfgWriteNode
extends CfgSimpleNode<JNode> {
    private final JExpression target;
    private final JExpression value;

    public CfgWriteNode(CfgNode<?> parent, JNode node, JExpression target, JExpression value) {
        super(parent, node);
        this.target = target;
        this.value = value;
    }

    @Override
    public void accept(CfgVisitor visitor) {
        visitor.visitWriteNode(this);
    }

    public JExpression getTarget() {
        return this.target;
    }

    public JVariable getTargetVariable() {
        return this.target instanceof JVariableRef ? ((JVariableRef)this.target).getTarget() : null;
    }

    public JExpression getValue() {
        return this.value;
    }

    @Override
    public String toDebugString() {
        String targets = this.target.toString();
        if (this.getTargetVariable() != null) {
            targets = this.getTargetVariable().getName();
        }
        return "WRITE(" + targets + ", " + this.value + ")";
    }

    @Override
    protected CfgNode<?> cloneImpl() {
        return new CfgWriteNode(this.getParent(), (JNode)this.getJNode(), this.target, this.value);
    }
}

