/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.cfg;

import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;

public class CfgUtil {
    public static void addGraphEdges(Cfg originalGraph, CfgNode<?> originalNode, CfgNode<?> newStartNode, CfgNode<?> newEndNode, Cfg newSubgraph) {
        for (int i = 0; i < originalGraph.getInEdges(originalNode).size(); ++i) {
            CfgEdge edge = new CfgEdge();
            newSubgraph.addIn(newStartNode, edge);
            newSubgraph.addGraphInEdge(edge);
        }
        for (CfgEdge e : originalGraph.getOutEdges(originalNode)) {
            CfgEdge edge = new CfgEdge(e.getRole());
            newSubgraph.addOut(newEndNode, edge);
            newSubgraph.addGraphOutEdge(edge);
        }
    }

    public static Cfg createSingleNodeReplacementGraph(Cfg originalGraph, CfgNode<?> originalNode, CfgNode<?> newNode) {
        Cfg newSubgraph = new Cfg();
        newSubgraph.addNode(newNode);
        CfgUtil.addGraphEdges(originalGraph, originalNode, newNode, newNode, newSubgraph);
        return newSubgraph;
    }

    public static CfgNode<?> findContainingStatement(CfgNode<?> node) {
        while (!(node.getJNode() instanceof JStatement)) {
            node = node.getParent();
        }
        return node;
    }

    public static CfgNode<?> findParentOfContainingStatement(CfgNode<?> node) {
        CfgNode<?> stmtNode;
        CfgNode<?> result = stmtNode = CfgUtil.findContainingStatement(node);
        while (stmtNode.getJNode() == result.getJNode()) {
            if ((result = result.getParent()) != null) continue;
            return null;
        }
        return result;
    }

    private CfgUtil() {
    }
}

