/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.cfg;

import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CfgPrinter {
    private final Cfg graph;

    public CfgPrinter(Cfg graph) {
        this.graph = graph;
    }

    public String print() {
        int i;
        StringBuilder result = new StringBuilder();
        ArrayList<CfgNode<?>> nodes = this.graph.getNodes();
        HashSet<CfgNode> targetNodes = new HashSet<CfgNode>();
        for (int i2 = 1; i2 < nodes.size(); ++i2) {
            CfgNode node = (CfgNode)nodes.get(i2);
            List<CfgEdge> inEdges = this.graph.getInEdges(node);
            for (CfgEdge inEdge : inEdges) {
                if (inEdge.getStart() == null || inEdge.getStart() == nodes.get(i2 - 1)) continue;
                targetNodes.add(node);
            }
        }
        HashMap<CfgNode, String> labels = new HashMap<CfgNode, String>();
        int j = 1;
        for (i = 0; i < nodes.size(); ++i) {
            if (!targetNodes.contains(nodes.get(i))) continue;
            labels.put((CfgNode)nodes.get(i), String.valueOf(j));
            ++j;
        }
        for (i = 0; i < nodes.size(); ++i) {
            CfgNode node = (CfgNode)nodes.get(i);
            if (i != 0) {
                result.append("\n");
            }
            if (labels.containsKey(node)) {
                result.append((String)labels.get(node));
                result.append(": ");
            }
            result.append(node.toDebugString());
            List<CfgEdge> out = this.graph.getOutEdges(node);
            if (out.isEmpty()) continue;
            result.append(" -> [");
            for (int j2 = 0; j2 < out.size(); ++j2) {
                CfgEdge edge;
                if (j2 > 0) {
                    result.append(", ");
                }
                if ((edge = out.get(j2)).getRole() != null) {
                    result.append(edge.getRole());
                    result.append("=");
                }
                if (i + 1 < nodes.size() && edge.getEnd() != nodes.get(i + 1)) {
                    result.append((String)labels.get(edge.getEnd()));
                } else {
                    result.append("*");
                }
                this.appendEdgeInfo(result, edge);
            }
            result.append("]");
        }
        return result.toString();
    }

    protected void appendEdgeInfo(StringBuilder result, CfgEdge edge) {
    }
}

