/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.cfg;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBreakStatement;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JContinueStatement;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JLabeledStatement;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.ast.JUnaryOperation;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.JWhileStatement;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgBinaryConditionalOperationNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgBlockNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgBreakNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgCaseNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgConditionalExpressionNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgContinueNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgDoNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEndNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgForNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgIfNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgMethodCallNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgOptionalThrowNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReadWriteNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgReturnNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgSimpleNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgStatementNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgSwitchGotoNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgThrowNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTryNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgVisitor;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgWhileNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgWriteNode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CfgBuilder {
    public static Cfg build(JProgram program, JBlock codeblock) {
        return new BuilderVisitor(program).build(codeblock);
    }

    private static class UnsupportedNodeException
    extends RuntimeException {
        public UnsupportedNodeException(String message) {
            super(message);
        }
    }

    private static class CfgCastOperationNode
    extends CfgSimpleNode<JNode> {
        public CfgCastOperationNode(CfgNode<?> parent, JNode jNode) {
            super(parent, jNode);
        }

        @Override
        public void accept(CfgVisitor visitor) {
            visitor.visitSimpleNode(this);
        }

        @Override
        protected CfgNode<?> cloneImpl() {
            return new CfgCastOperationNode(this.getParent(), (JNode)this.getJNode());
        }
    }

    private static class BuilderVisitor
    extends JVisitor {
        private final EnumMap<Exit.Reason, ArrayList<Exit>> currentExitsByReason = new EnumMap(Exit.Reason.class);
        private final CfgEndNode endNode = new CfgEndNode();
        private final Cfg graph = new Cfg();
        private final Map<JStatement, String> labels = new HashMap<JStatement, String>();
        private final List<CfgNode<?>> nodes = new ArrayList();
        private CfgNode<?> parent = null;
        private final JProgram program;
        private JSwitchStatement switchStatement;
        private final JTypeOracle typeOracle;

        public BuilderVisitor(JProgram program) {
            this.program = program;
            this.typeOracle = program.typeOracle;
            for (Exit.Reason reason : Exit.Reason.values()) {
                this.currentExitsByReason.put(reason, new ArrayList());
            }
        }

        public Cfg build(JBlock codeBlock) {
            CfgEdge methodIn = new CfgEdge();
            this.graph.addGraphInEdge(methodIn);
            this.accept(codeBlock);
            this.graph.addIn(this.nodes.get(0), methodIn);
            this.addNode(this.endNode);
            block4: for (Exit.Reason reason : Exit.Reason.values()) {
                switch (reason) {
                    case CONTINUE: 
                    case BREAK: 
                    case CASE_ELSE: 
                    case CASE_THEN: {
                        if (this.currentExitsByReason.get((Object)reason).isEmpty()) continue block4;
                        throw new IllegalArgumentException("Unhandled exit: " + (Object)((Object)reason));
                    }
                    case NORMAL: 
                    case RETURN: 
                    case THROW: {
                        for (Exit exit : this.currentExitsByReason.get((Object)reason)) {
                            this.addEdge(exit, this.endNode);
                        }
                        continue block4;
                    }
                }
            }
            return this.graph;
        }

        @Override
        public boolean visit(JBinaryOperation x, Context ctx) {
            if (x.isAssignment()) {
                this.accept(x.getRhs());
                this.acceptExpressionSubreads(x.getLhs());
                if (x.getOp() == JBinaryOperator.ASG) {
                    this.addNode(new CfgWriteNode(this.parent, x, x.getLhs(), x.getRhs()));
                } else {
                    this.addNode(new CfgReadWriteNode(this.parent, x, x.getLhs(), null));
                }
                return false;
            }
            if (x.getOp() == JBinaryOperator.AND || x.getOp() == JBinaryOperator.OR) {
                this.accept(x.getLhs());
                CfgBinaryConditionalOperationNode node = this.pushNode(new CfgBinaryConditionalOperationNode(this.parent, x));
                if (x.getOp() == JBinaryOperator.AND) {
                    this.addNormalExit(node, "THEN");
                    this.accept(x.getRhs());
                    List<Exit> thenExits = this.removeNormalExits();
                    this.addNormalExit(node, "ELSE");
                    this.addExits(thenExits);
                } else {
                    this.addNormalExit(node, "ELSE");
                    this.accept(x.getRhs());
                    List<Exit> elseExits = this.removeNormalExits();
                    this.addNormalExit(node, "THEN");
                    this.addExits(elseExits);
                }
                this.popNode();
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JBlock x, Context ctx) {
            this.pushNode(new CfgBlockNode(this.parent, x));
            this.accept(x.getStatements());
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JBreakStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JBreakStatement>(this.parent, x));
            String label = null;
            if (x.getLabel() != null) {
                label = x.getLabel().getName();
            }
            CfgBreakNode node = this.addNode(new CfgBreakNode(this.parent, x));
            this.addExit(Exit.createBreak(node, label));
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JCaseStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JCaseStatement>(this.parent, x));
            if (!x.isDefault()) {
                JBinaryOperation condition = x.convertToCompareExpression(this.switchStatement.getExpr());
                CfgCaseNode node = this.addNode(new CfgCaseNode(this.parent, x, condition));
                this.addExit(Exit.createCaseThen(node));
                this.addExit(Exit.createCaseElse(node));
            }
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JCastOperation x, Context ctx) {
            this.accept(x.getExpr());
            CfgOptionalThrowNode node = this.addNode(new CfgOptionalThrowNode(this.parent, x));
            this.addNormalExit(node, "NOTHROW");
            JDeclaredType runtimeExceptionType = this.program.getFromTypeMap("java.lang.RuntimeException");
            if (runtimeExceptionType != null) {
                this.addExit(Exit.createThrow(node, runtimeExceptionType, "RE"));
            }
            this.addNode(new CfgCastOperationNode(this.parent, x));
            return false;
        }

        @Override
        public boolean visit(JConditional x, Context ctx) {
            this.accept(x.getIfTest());
            CfgConditionalExpressionNode node = this.pushNode(new CfgConditionalExpressionNode(this.parent, x));
            this.addNormalExit(node, "THEN");
            this.accept(x.getThenExpr());
            List<Exit> thenExits = this.removeNormalExits();
            this.addNormalExit(node, "ELSE");
            this.accept(x.getElseExpr());
            this.addExits(thenExits);
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JContinueStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JContinueStatement>(this.parent, x));
            String label = null;
            if (x.getLabel() != null) {
                label = x.getLabel().getName();
            }
            CfgContinueNode node = this.addNode(new CfgContinueNode(this.parent, x));
            this.addExit(Exit.createContinue(node, label));
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JDebuggerStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JDebuggerStatement>(this.parent, x));
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JDeclarationStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JDeclarationStatement>(this.parent, x));
            if (x.getInitializer() != null) {
                this.accept(x.getInitializer());
                this.addNode(new CfgWriteNode(this.parent, x, x.getVariableRef(), x.getInitializer()));
            }
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JDoStatement x, Context ctx) {
            List<Exit> unlabeledExits = this.removeUnlabeledExits();
            this.pushNode(new CfgStatementNode<JDoStatement>(this.parent, x));
            int pos = this.nodes.size();
            if (x.getBody() != null) {
                this.accept(x.getBody());
            }
            if (x.getTestExpr() != null) {
                this.accept(x.getTestExpr());
            }
            CfgDoNode node = this.addNode(new CfgDoNode(this.parent, x));
            this.addEdge(node, this.nodes.get(pos), new CfgEdge("THEN"));
            String label = this.labels.get(x);
            this.addContinueEdges(this.nodes.get(pos), label);
            this.addBreakExits(label);
            this.addNormalExit(node, "ELSE");
            this.popNode();
            this.addExits(unlabeledExits);
            return false;
        }

        @Override
        public boolean visit(JExpressionStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JExpressionStatement>(this.parent, x));
            this.accept(x.getExpr());
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JForStatement x, Context ctx) {
            List<Exit> unlabeledExits = this.removeUnlabeledExits();
            this.pushNode(new CfgStatementNode<JForStatement>(this.parent, x));
            this.accept(x.getInitializers());
            CfgForNode cond = null;
            int testPos = this.nodes.size();
            if (x.getCondition() != null) {
                this.accept(x.getCondition());
                cond = this.addNode(new CfgForNode(this.parent, x));
                this.addNormalExit(cond, "THEN");
            }
            if (x.getBody() != null) {
                this.accept(x.getBody());
            }
            int incrementsPos = this.nodes.size();
            if (x.getIncrements() != null) {
                this.accept(x.getIncrements());
            }
            List<Exit> thenExits = this.removeNormalExits();
            for (Exit e : thenExits) {
                this.addEdge(e, this.nodes.get(testPos));
            }
            String label = this.labels.get(x);
            int continuePos = incrementsPos != this.nodes.size() ? incrementsPos : testPos;
            this.addContinueEdges(this.nodes.get(continuePos), label);
            this.addBreakExits(label);
            if (cond != null) {
                this.addNormalExit(cond, "ELSE");
            }
            this.popNode();
            this.addExits(unlabeledExits);
            return false;
        }

        @Override
        public boolean visit(JIfStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JIfStatement>(this.parent, x));
            this.accept(x.getIfExpr());
            CfgIfNode node = this.addNode(new CfgIfNode(this.parent, x));
            this.addNormalExit(node, "THEN");
            if (x.getThenStmt() != null) {
                this.accept(x.getThenStmt());
            }
            List<Exit> thenExits = this.removeNormalExits();
            this.addNormalExit(node, "ELSE");
            if (x.getElseStmt() != null) {
                this.accept(x.getElseStmt());
            }
            this.addExits(thenExits);
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JLabeledStatement x, Context ctx) {
            String label = x.getLabel().getName();
            this.labels.put(x.getBody(), label);
            this.accept(x.getBody());
            this.addBreakExits(label);
            return false;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            JDeclaredType errorExceptionType;
            if (x.getInstance() != null) {
                this.accept(x.getInstance());
            }
            this.accept(x.getArgs());
            CfgOptionalThrowNode node = this.addNode(new CfgOptionalThrowNode(this.parent, x));
            this.addNormalExit(node, "NOTHROW");
            for (JClassType exceptionType : x.getTarget().getThrownExceptions()) {
                this.addExit(Exit.createThrow(node, exceptionType, null));
            }
            JDeclaredType runtimeExceptionType = this.program.getFromTypeMap("java.lang.RuntimeException");
            if (runtimeExceptionType != null) {
                this.addExit(Exit.createThrow(node, runtimeExceptionType, "RE"));
            }
            if ((errorExceptionType = this.program.getFromTypeMap("java.lang.Error")) != null) {
                this.addExit(Exit.createThrow(node, errorExceptionType, "E"));
            }
            this.addNode(new CfgMethodCallNode(this.parent, x));
            return false;
        }

        @Override
        public boolean visit(JReturnStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JReturnStatement>(this.parent, x));
            if (x.getExpr() != null) {
                this.accept(x.getExpr());
            }
            CfgReturnNode node = this.addNode(new CfgReturnNode(this.parent, x));
            this.addExit(Exit.createReturn(node));
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JStatement x, Context ctx) {
            throw new UnsupportedNodeException(x.getClass().toString());
        }

        @Override
        public boolean visit(JSwitchExpression x, Context ctx) {
            return false;
        }

        @Override
        public boolean visit(JSwitchStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JSwitchStatement>(this.parent, x));
            this.accept(x.getExpr());
            JSwitchStatement oldSwitchStatement = this.switchStatement;
            List<Exit> oldCaseElseExits = this.removeExits(Exit.Reason.CASE_ELSE);
            List<Exit> oldCaseThenExits = this.removeExits(Exit.Reason.CASE_THEN);
            List<Exit> oldBreakExits = this.removeUnlabeledBreaks();
            this.switchStatement = x;
            CfgSwitchGotoNode gotoNode = this.addNode(new CfgSwitchGotoNode(this.parent, x));
            Exit gotoExit = Exit.createNormal(gotoNode, null);
            int defaultPos = -1;
            ArrayList<Exit> breakExits = new ArrayList<Exit>();
            ArrayList<Exit> fallThroughExits = new ArrayList<Exit>();
            List<JStatement> statements = x.getBody().getStatements();
            for (JStatement jStatement : statements) {
                if (jStatement instanceof JCaseStatement) {
                    if (!((JCaseStatement)jStatement).isDefault()) {
                        fallThroughExits.addAll(this.removeExits(Exit.Reason.NORMAL));
                        if (gotoExit != null) {
                            this.addExit(gotoExit);
                            gotoExit = null;
                        }
                        List<Exit> elseExits = this.removeExits(Exit.Reason.CASE_ELSE);
                        for (Exit e : elseExits) {
                            this.addNormalExit(e.getNode(), e.role);
                        }
                    } else {
                        defaultPos = this.nodes.size();
                    }
                } else {
                    List<Exit> thenExits = this.removeExits(Exit.Reason.CASE_THEN);
                    for (Exit e : thenExits) {
                        this.addNormalExit(e.getNode(), e.role);
                    }
                    if (!fallThroughExits.isEmpty()) {
                        for (Exit e : fallThroughExits) {
                            this.addExit(e);
                        }
                        fallThroughExits.clear();
                    }
                }
                this.accept(jStatement);
                breakExits.addAll(this.removeUnlabeledBreaks());
            }
            if (gotoExit != null) {
                if (defaultPos >= 0) {
                    this.addEdge(gotoExit, this.nodes.get(defaultPos));
                } else {
                    this.addExit(gotoExit);
                }
                gotoExit = null;
            }
            List<Exit> thenExits = this.removeExits(Exit.Reason.CASE_THEN);
            for (Exit e : thenExits) {
                this.addNormalExit(e.getNode(), e.role);
            }
            List<Exit> list = this.removeExits(Exit.Reason.CASE_ELSE);
            if (defaultPos >= 0) {
                for (Exit e : list) {
                    this.addEdge(e, this.nodes.get(defaultPos));
                }
            } else {
                for (Exit e : list) {
                    this.addExit(Exit.createNormal(e.getNode(), e.role));
                }
            }
            for (Exit e : breakExits) {
                this.addNormalExit(e.getNode(), e.role);
            }
            this.switchStatement = oldSwitchStatement;
            this.addExits(oldCaseElseExits);
            this.addExits(oldCaseThenExits);
            this.addExits(oldBreakExits);
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JThrowStatement x, Context ctx) {
            this.pushNode(new CfgStatementNode<JThrowStatement>(this.parent, x));
            this.accept(x.getExpr());
            CfgThrowNode node = this.addNode(new CfgThrowNode(this.parent, x));
            this.addExit(Exit.createThrow(node, x.getExpr().getType(), null));
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JTryStatement x, Context ctx) {
            this.pushNode(new CfgTryNode(this.parent, x));
            this.accept(x.getTryBlock());
            List<Exit> tryBlockExits = this.removeCurrentExits();
            ArrayList<Integer> catchBlockPos = new ArrayList<Integer>();
            ArrayList<List<Exit>> catchExits = new ArrayList<List<Exit>>();
            for (JTryStatement.CatchClause clause : x.getCatchClauses()) {
                Iterator b = clause.getBlock();
                catchBlockPos.add(this.nodes.size());
                this.accept((JStatement)((Object)b));
                catchExits.add(this.removeCurrentExits());
            }
            int finallyPos = this.nodes.size();
            if (x.getFinallyBlock() != null) {
                this.accept(x.getFinallyBlock());
            }
            List<Exit> finallyExits = this.removeCurrentExits();
            if (x.getFinallyBlock() == null) {
                this.addExits(this.removeNormalExits(tryBlockExits));
                block1: for (Exit exit : tryBlockExits) {
                    if (exit.isThrow()) {
                        for (int i = 0; i < x.getCatchClauses().size(); ++i) {
                            JClassType catchType = (JClassType)x.getCatchClauses().get(i).getArg().getType();
                            JType exceptionType = exit.getExceptionType();
                            boolean canCatch = false;
                            boolean fullCatch = false;
                            if (this.typeOracle.castSucceedsTrivially(exceptionType, (JType)catchType)) {
                                canCatch = true;
                                fullCatch = x.getCatchClauses().get(i).getTypes().size() == 1 && x.getCatchClauses().get(i).getTypes().get(0) == catchType;
                            } else if (this.typeOracle.castSucceedsTrivially((JType)catchType, exceptionType)) {
                                canCatch = true;
                                fullCatch = false;
                            }
                            if (!canCatch) continue;
                            this.addEdge(exit, this.nodes.get((Integer)catchBlockPos.get(i)));
                            if (fullCatch) continue block1;
                        }
                        this.addExit(exit);
                        continue;
                    }
                    this.addExit(exit);
                }
                for (List list : catchExits) {
                    this.addExits(list);
                }
            } else {
                CfgNode<?> finallyNode = this.nodes.get(finallyPos);
                for (Exit exit : this.removeNormalExits(tryBlockExits)) {
                    this.addEdge(exit, finallyNode);
                }
                this.addExits(finallyExits);
                block5: for (Exit exit : tryBlockExits) {
                    if (exit.isThrow()) {
                        for (int i = 0; i < x.getCatchClauses().size(); ++i) {
                            JClassType catchType = (JClassType)x.getCatchClauses().get(i).getArg().getType();
                            JType exceptionType = exit.getExceptionType();
                            boolean canCatch = false;
                            boolean fullCatch = false;
                            if (this.typeOracle.castSucceedsTrivially(exceptionType, (JType)catchType)) {
                                canCatch = true;
                                fullCatch = x.getCatchClauses().get(i).getTypes().size() == 1 && x.getCatchClauses().get(i).getTypes().get(0) == catchType;
                            } else if (this.typeOracle.castSucceedsTrivially((JType)catchType, exceptionType)) {
                                canCatch = true;
                                fullCatch = false;
                            }
                            if (!canCatch) continue;
                            this.addEdge(exit, this.nodes.get((Integer)catchBlockPos.get(i)));
                            if (fullCatch) continue block5;
                        }
                        this.addEdge(exit, finallyNode);
                        for (Exit finallyExit : finallyExits) {
                            if (!finallyExit.isNormal()) continue;
                            this.addExit(new Exit(exit.reason, finallyExit.node, exit.exceptionType, exit.label, exit.role));
                        }
                        continue;
                    }
                    this.addEdge(exit, finallyNode);
                    for (Exit finallyExit : finallyExits) {
                        if (!finallyExit.isNormal()) continue;
                        this.addExit(new Exit(exit.reason, finallyExit.node, exit.exceptionType, exit.label, exit.role));
                    }
                }
                for (List list : catchExits) {
                    for (Exit e : list) {
                        this.addEdge(e, finallyNode);
                        if (e.isNormal()) continue;
                        for (Exit finallyExit : finallyExits) {
                            if (!finallyExit.isNormal()) continue;
                            this.addExit(new Exit(e.reason, finallyExit.node, e.exceptionType, e.label, e.role));
                        }
                    }
                }
            }
            this.popNode();
            return false;
        }

        @Override
        public boolean visit(JUnaryOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.acceptExpressionSubreads(x.getArg());
                this.addNode(new CfgReadWriteNode(this.parent, x, x.getArg(), null));
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JVariableRef x, Context ctx) {
            this.addNode(new CfgReadNode(this.parent, x));
            return true;
        }

        @Override
        public boolean visit(JWhileStatement x, Context ctx) {
            List<Exit> unlabeledExits = this.removeUnlabeledExits();
            this.pushNode(new CfgStatementNode<JWhileStatement>(this.parent, x));
            int pos = this.nodes.size();
            this.accept(x.getTestExpr());
            CfgWhileNode node = this.addNode(new CfgWhileNode(this.parent, x));
            this.addNormalExit(node, "THEN");
            if (x.getBody() != null) {
                this.accept(x.getBody());
            }
            List<Exit> thenExits = this.removeNormalExits();
            for (Exit e : thenExits) {
                this.addEdge(e, this.nodes.get(pos));
            }
            String label = this.labels.get(x);
            this.addContinueEdges(this.nodes.get(pos), label);
            this.addBreakExits(label);
            this.addNormalExit(node, "ELSE");
            this.popNode();
            this.addExits(unlabeledExits);
            return false;
        }

        private void acceptExpressionSubreads(JExpression expression) {
            if (expression instanceof JFieldRef) {
                JExpression instance = ((JFieldRef)expression).getInstance();
                if (instance != null) {
                    this.accept(instance);
                }
            } else if (expression instanceof JArrayRef) {
                JArrayRef arrayRef = (JArrayRef)expression;
                this.accept(arrayRef.getInstance());
                this.accept(arrayRef.getIndexExpr());
            } else if (!(expression instanceof JVariableRef)) {
                throw new IllegalArgumentException("Unexpected lhs: " + expression);
            }
        }

        private void addBreakExits(String label) {
            List<Exit> exits = this.removeLoopExits(Exit.Reason.BREAK, label);
            for (Exit e : exits) {
                this.addNormalExit(e.getNode());
            }
        }

        private void addContinueEdges(CfgNode<?> node, String label) {
            List<Exit> continueExits = this.removeLoopExits(Exit.Reason.CONTINUE, label);
            for (Exit e : continueExits) {
                this.addEdge(e, node);
            }
        }

        private CfgEdge addEdge(CfgNode<?> from, CfgNode<?> to, CfgEdge edge) {
            this.graph.addOut(from, edge);
            this.graph.addIn(to, edge);
            return edge;
        }

        private CfgEdge addEdge(Exit e, CfgNode<?> to) {
            CfgEdge edge = new CfgEdge(e.role);
            return this.addEdge(e.node, to, edge);
        }

        private void addExit(Exit exit) {
            this.currentExitsByReason.get((Object)exit.reason).add(exit);
        }

        private void addExits(List<Exit> exits) {
            for (Exit exit : exits) {
                this.currentExitsByReason.get((Object)exit.reason).add(exit);
            }
        }

        private <N extends CfgNode<?>> N addNode(N node) {
            this.nodes.add(node);
            this.graph.addNode(node);
            ArrayList normalExits = this.currentExitsByReason.put(Exit.Reason.NORMAL, new ArrayList());
            for (Exit exit : normalExits) {
                this.addEdge(exit, node);
            }
            if (node instanceof CfgSimpleNode) {
                this.addNormalExit(node);
            }
            return node;
        }

        private void addNormalExit(CfgNode<?> node) {
            this.addNormalExit(node, null);
        }

        private void addNormalExit(CfgNode<?> node, String role) {
            this.addExit(Exit.createNormal(node, role));
        }

        private void popNode() {
            this.parent = this.parent.getParent();
        }

        private <N extends CfgNode<?>> N pushNode(N node) {
            this.addNode(node);
            this.parent = node;
            return node;
        }

        private List<Exit> removeCurrentExits() {
            ArrayList<Exit> result = new ArrayList<Exit>();
            for (Exit.Reason reason : Exit.Reason.values()) {
                result.addAll(this.currentExitsByReason.put(reason, new ArrayList()));
            }
            return result;
        }

        private List<Exit> removeExits(Exit.Reason reason) {
            return this.currentExitsByReason.put(reason, new ArrayList());
        }

        private List<Exit> removeExits(List<Exit> exits, Exit.Reason reason) {
            ArrayList<Exit> result = new ArrayList<Exit>();
            Iterator<Exit> i = exits.iterator();
            while (i.hasNext()) {
                Exit exit = i.next();
                if (exit.reason != reason) continue;
                i.remove();
                result.add(exit);
            }
            return result;
        }

        private List<Exit> removeLoopExits(Exit.Reason reason, String label) {
            ArrayList<Exit> removedExits = new ArrayList<Exit>();
            ArrayList<Exit> remainingExits = new ArrayList<Exit>();
            for (Exit exit : this.currentExitsByReason.get((Object)reason)) {
                if (exit.getLabel() == null || exit.getLabel().equals(label)) {
                    removedExits.add(exit);
                    continue;
                }
                remainingExits.add(exit);
            }
            this.currentExitsByReason.put(reason, remainingExits);
            return removedExits;
        }

        private List<Exit> removeNormalExits() {
            return this.currentExitsByReason.put(Exit.Reason.NORMAL, new ArrayList());
        }

        private List<Exit> removeNormalExits(List<Exit> exits) {
            return this.removeExits(exits, Exit.Reason.NORMAL);
        }

        private List<Exit> removeUnlabeledBreaks() {
            List<Exit> breakExits = this.removeExits(Exit.Reason.BREAK);
            ArrayList<Exit> labeledBreaks = new ArrayList<Exit>();
            Iterator<Exit> i = breakExits.iterator();
            while (i.hasNext()) {
                Exit exit = i.next();
                if (exit.getLabel() == null) continue;
                i.remove();
                labeledBreaks.add(exit);
            }
            this.addExits(labeledBreaks);
            return breakExits;
        }

        private List<Exit> removeUnlabeledExits() {
            Exit.Reason[] reasons;
            ArrayList<Exit> unlabeledExits = new ArrayList<Exit>();
            for (Exit.Reason reason : reasons = new Exit.Reason[]{Exit.Reason.BREAK, Exit.Reason.CONTINUE}) {
                Iterator<Exit> i = this.currentExitsByReason.get((Object)reason).iterator();
                while (i.hasNext()) {
                    Exit exit = i.next();
                    if (exit.getLabel() != null) continue;
                    i.remove();
                    unlabeledExits.add(exit);
                }
            }
            return unlabeledExits;
        }

        private static class Exit {
            private final JType exceptionType;
            private final String label;
            private final CfgNode<?> node;
            private final Reason reason;
            private final String role;

            private static Exit createBreak(CfgNode<?> node, String label) {
                return new Exit(Reason.BREAK, node, null, label, null);
            }

            private static Exit createCaseElse(CfgNode<?> node) {
                return new Exit(Reason.CASE_ELSE, node, null, null, "ELSE");
            }

            private static Exit createCaseThen(CfgNode<?> node) {
                return new Exit(Reason.CASE_THEN, node, null, null, "THEN");
            }

            private static Exit createContinue(CfgNode<?> node, String label) {
                return new Exit(Reason.CONTINUE, node, null, label, null);
            }

            private static Exit createNormal(CfgNode<?> node, String role) {
                return new Exit(Reason.NORMAL, node, null, null, role);
            }

            private static Exit createReturn(CfgNode<?> node) {
                return new Exit(Reason.RETURN, node, null, null, null);
            }

            private static Exit createThrow(CfgNode<?> node, JType exceptionType, String role) {
                return new Exit(Reason.THROW, node, exceptionType, null, role);
            }

            private Exit(Reason reason, CfgNode<?> source, JType exceptionType, String label, String role) {
                if (source == null) {
                    throw new IllegalArgumentException();
                }
                this.reason = reason;
                this.node = source;
                this.exceptionType = exceptionType;
                this.label = label;
                this.role = role;
            }

            public JType getExceptionType() {
                if (!this.isThrow()) {
                    throw new IllegalArgumentException();
                }
                return this.exceptionType;
            }

            public String getLabel() {
                if (!this.isContinue() && !this.isBreak()) {
                    throw new IllegalArgumentException();
                }
                return this.label;
            }

            public CfgNode<?> getNode() {
                return this.node;
            }

            public boolean isBreak() {
                return this.reason == Reason.BREAK;
            }

            public boolean isContinue() {
                return this.reason == Reason.CONTINUE;
            }

            public boolean isNormal() {
                return this.reason == Reason.NORMAL;
            }

            public boolean isThrow() {
                return this.reason == Reason.THROW;
            }

            public String toString() {
                return this.reason.toString();
            }

            private static enum Reason {
                BREAK,
                CASE_ELSE,
                CASE_THEN,
                CONTINUE,
                NORMAL,
                RETURN,
                THROW;

            }
        }
    }
}

