/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow.cfg;

import com.google.gwt.dev.jjs.impl.gflow.Graph;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgEdge;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgNode;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgPrinter;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgTransformer;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class Cfg
implements Graph<CfgNode<?>, CfgEdge, CfgTransformer> {
    private final ArrayList<CfgEdge> graphInEdges = new ArrayList();
    private final ArrayList<CfgEdge> graphOutEdges = new ArrayList();
    private final ArrayList<CfgNode<?>> nodes = new ArrayList();

    public void addGraphInEdge(CfgEdge edge) {
        this.graphInEdges.add(edge);
    }

    public void addGraphOutEdge(CfgEdge edge) {
        this.graphOutEdges.add(edge);
    }

    public void addIn(CfgNode<?> node, CfgEdge edge) {
        Preconditions.checkNotNull(edge, "Null edge: %s", (Object)edge);
        Preconditions.checkArgument(edge.end == null, "Edge is already bound: %s", (Object)edge);
        node.in = Lists.add(node.in, edge);
        edge.end = node;
    }

    public <N extends CfgNode<?>> N addNode(N node) {
        this.nodes.add(node);
        return node;
    }

    public void addOut(CfgNode<?> node, CfgEdge edge) {
        if (edge.start != null) {
            throw new IllegalArgumentException();
        }
        node.out = Lists.add(node.out, edge);
        edge.start = node;
    }

    @Override
    public Object getEdgeData(CfgEdge edge) {
        return edge.data;
    }

    @Override
    public CfgNode<?> getEnd(CfgEdge e) {
        return e.getEnd();
    }

    @Override
    public ArrayList<CfgEdge> getGraphInEdges() {
        return this.graphInEdges;
    }

    @Override
    public ArrayList<CfgEdge> getGraphOutEdges() {
        return this.graphOutEdges;
    }

    @Override
    public List<CfgEdge> getInEdges(CfgNode<?> cfgNode) {
        return cfgNode.in;
    }

    @Override
    public ArrayList<CfgNode<?>> getNodes() {
        return this.nodes;
    }

    @Override
    public List<CfgEdge> getOutEdges(CfgNode<?> cfgNode) {
        return cfgNode.out;
    }

    @Override
    public CfgNode<?> getStart(CfgEdge e) {
        return e.getStart();
    }

    @Override
    public String print() {
        return new CfgPrinter(this).print();
    }

    @Override
    public void setEdgeData(CfgEdge edge, Object data) {
        edge.data = data;
    }

    public String toString() {
        return this.print();
    }

    @Override
    public boolean transform(CfgNode<?> node, CfgTransformer actualizer) {
        if (actualizer == null) {
            throw new IllegalArgumentException();
        }
        return actualizer.transform(node, this);
    }
}

