/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.DeadCodeElimination;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.gflow.AnalysisSolver;
import com.google.gwt.dev.jjs.impl.gflow.CombinedIntegratedAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.cfg.Cfg;
import com.google.gwt.dev.jjs.impl.gflow.cfg.CfgBuilder;
import com.google.gwt.dev.jjs.impl.gflow.constants.ConstantsAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.copy.CopyAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.liveness.LivenessAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.unreachable.UnreachableAnalysis;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public class DataflowOptimizer {
    public static String NAME = DataflowOptimizer.class.getSimpleName();
    private final JProgram program;

    public static OptimizerStats exec(JProgram jprogram, JNode node) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new DataflowOptimizer(jprogram).execImpl(node);
        optimizeEvent.end(new String[0]);
        return stats;
    }

    public static OptimizerStats exec(JProgram jprogram) {
        return DataflowOptimizer.exec(jprogram, jprogram);
    }

    public DataflowOptimizer(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(JNode node) {
        DataflowOptimizerVisitor visitor = new DataflowOptimizerVisitor();
        visitor.accept(node);
        return new OptimizerStats(NAME).recordModified(visitor.getNumMods());
    }

    private class DataflowOptimizerVisitor
    extends JModVisitor {
        private DataflowOptimizerVisitor() {
        }

        @Override
        public boolean visit(JMethodBody methodBody, Context ctx) {
            Cfg cfg = CfgBuilder.build(DataflowOptimizer.this.program, methodBody.getBlock());
            JMethod method = methodBody.getMethod();
            JDeclaredType enclosingType = method.getEnclosingType();
            String methodName = enclosingType.getName() + "." + method.getName();
            Preconditions.checkNotNull(cfg, "Can't build flow for %s", (Object)methodName);
            try {
                CombinedIntegratedAnalysis fwdAnalysis = CombinedIntegratedAnalysis.createAnalysis();
                fwdAnalysis.addAnalysis(new UnreachableAnalysis());
                fwdAnalysis.addAnalysis(new ConstantsAnalysis());
                fwdAnalysis.addAnalysis(new CopyAnalysis());
                boolean madeChanges = false;
                madeChanges = AnalysisSolver.solveIntegrated(cfg, fwdAnalysis, true) || madeChanges;
                cfg = CfgBuilder.build(DataflowOptimizer.this.program, methodBody.getBlock());
                Preconditions.checkNotNull(cfg);
                CombinedIntegratedAnalysis bkwAnalysis = CombinedIntegratedAnalysis.createAnalysis();
                bkwAnalysis.addAnalysis(new LivenessAnalysis());
                boolean bl = madeChanges = AnalysisSolver.solveIntegrated(cfg, bkwAnalysis, false) || madeChanges;
                if (madeChanges) {
                    this.madeChanges();
                    DeadCodeElimination.exec(DataflowOptimizer.this.program, methodBody.getMethod());
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Error optimizing: " + methodName, t);
            }
            return true;
        }
    }
}

