/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow;

import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.Graph;
import com.google.gwt.dev.jjs.impl.gflow.IntegratedAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.IntegratedFlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class CombinedIntegratedAnalysis<N, E, T, G extends Graph<N, E, T>>
implements IntegratedAnalysis<N, E, T, G, CombinedAssumption> {
    List<IntegratedAnalysis<N, E, T, G, ?>> analyses = new ArrayList();
    List<IntegratedFlowFunction<N, E, T, G, ?>> functions = new ArrayList();

    public static <N, E, T, G extends Graph<N, E, T>> CombinedIntegratedAnalysis<N, E, T, G> createAnalysis() {
        return new CombinedIntegratedAnalysis<N, E, T, G>();
    }

    public void addAnalysis(IntegratedAnalysis<N, E, T, G, ?> analysis) {
        this.analyses.add(analysis);
        this.functions.add(analysis.getIntegratedFlowFunction());
    }

    @Override
    public IntegratedFlowFunction<N, E, T, G, CombinedAssumption> getIntegratedFlowFunction() {
        return new CombinedIntegratedFlowFunction();
    }

    @Override
    public void setInitialGraphAssumptions(G graph, final AssumptionMap<E, CombinedAssumption> assumptionMap) {
        int i = 0;
        while (i < this.functions.size()) {
            final int slice = i++;
            IntegratedAnalysis<N, E, T, G, ?> analysis = this.analyses.get(slice);
            analysis.setInitialGraphAssumptions(graph, new AssumptionMap(){

                public Assumption getAssumption(Object edge) {
                    throw new UnsupportedOperationException();
                }

                public void setAssumption(Object edge, Assumption assumption) {
                    CombinedAssumption combinedAssumption = (CombinedAssumption)assumptionMap.getAssumption(edge);
                    if (combinedAssumption == null) {
                        combinedAssumption = new CombinedAssumption(CombinedIntegratedAnalysis.this.functions.size());
                        combinedAssumption.set(slice, assumption);
                        assumptionMap.setAssumption(edge, combinedAssumption);
                    } else {
                        combinedAssumption.set(slice, assumption);
                    }
                }
            });
        }
    }

    private final class CombinedIntegratedFlowFunction
    implements IntegratedFlowFunction<N, E, T, G, CombinedAssumption> {
        private CombinedIntegratedFlowFunction() {
        }

        @Override
        public TransformationFunction.Transformation interpretOrReplace(N node, G graph, final AssumptionMap<E, CombinedAssumption> assumptionMap) {
            final IdentityHashMap newAssumptions = new IdentityHashMap();
            final int size = CombinedIntegratedAnalysis.this.functions.size();
            for (int i = 0; i < size; ++i) {
                final int slice = i;
                IntegratedFlowFunction function = CombinedIntegratedAnalysis.this.functions.get(i);
                TransformationFunction.Transformation transformation = function.interpretOrReplace(node, graph, new AssumptionMap((Graph)graph, node){
                    final /* synthetic */ Graph val$graph;
                    final /* synthetic */ Object val$node;
                    {
                        this.val$graph = graph;
                        this.val$node = object;
                    }

                    public Assumption getAssumption(Object edge) {
                        CombinedAssumption combinedAssumption = (CombinedAssumption)assumptionMap.getAssumption(edge);
                        if (combinedAssumption == null) {
                            return null;
                        }
                        return combinedAssumption.get(slice);
                    }

                    public void setAssumption(Object edge, Assumption assumption) {
                        CombinedAssumption.CopyOnWrite newAssumption = (CombinedAssumption.CopyOnWrite)newAssumptions.get(edge);
                        if (newAssumption == null) {
                            newAssumption = new CombinedAssumption.CopyOnWrite((CombinedAssumption)assumptionMap.getAssumption(edge), size);
                            newAssumptions.put(edge, newAssumption);
                        }
                        newAssumption.set(slice, assumption);
                    }

                    public String toString() {
                        return AssumptionUtil.toString(this.val$graph.getInEdges(this.val$node), this.val$graph.getOutEdges(this.val$node), this);
                    }
                });
                if (transformation == null) continue;
                return transformation;
            }
            for (Object e : newAssumptions.keySet()) {
                CombinedAssumption.CopyOnWrite newAssumption = (CombinedAssumption.CopyOnWrite)newAssumptions.get(e);
                if (!newAssumption.isCopied()) continue;
                assumptionMap.setAssumption(e, newAssumption.unwrap());
            }
            return null;
        }
    }

    public static class CombinedAssumption
    implements Assumption<CombinedAssumption> {
        private final List<Assumption<?>> assumptions;

        public CombinedAssumption(CombinedAssumption assumption) {
            this.assumptions = new ArrayList(assumption.assumptions);
        }

        public CombinedAssumption(int size) {
            this.assumptions = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.assumptions.add(null);
            }
        }

        public CombinedAssumption(List<Assumption<?>> assumptions) {
            this.assumptions = assumptions;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            CombinedAssumption other = (CombinedAssumption)obj;
            if (other.assumptions.size() != this.assumptions.size()) {
                return false;
            }
            for (int i = 0; i < this.assumptions.size(); ++i) {
                Assumption<?> a1 = this.assumptions.get(i);
                Assumption<?> a2 = other.assumptions.get(i);
                if (a1 == null) {
                    if (a1 == a2) continue;
                    return false;
                }
                if (a2 == null) {
                    return false;
                }
                if (a1.equals(a2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.assumptions == null ? 0 : this.assumptions.hashCode());
            return result;
        }

        @Override
        public CombinedAssumption join(CombinedAssumption value) {
            if (value == null) {
                return this;
            }
            Preconditions.checkArgument(value.assumptions.size() == this.assumptions.size());
            ArrayList newAssumptions = new ArrayList();
            for (int i = 0; i < this.assumptions.size(); ++i) {
                Assumption<?> a1 = this.assumptions.get(i);
                Assumption<?> a2 = value.assumptions.get(i);
                newAssumptions.add(AssumptionUtil.join(a1, a2));
            }
            return new CombinedAssumption(newAssumptions);
        }

        public String toString() {
            return this.assumptions.toString();
        }

        private Assumption<?> get(int n) {
            return this.assumptions.get(n);
        }

        private void set(int slice, Assumption<?> assumption) {
            this.assumptions.set(slice, assumption);
        }

        private static class CopyOnWrite {
            private final int size;
            private CombinedAssumption assumption;
            private boolean copied = false;

            private CopyOnWrite(CombinedAssumption assumption, int size) {
                this.assumption = assumption;
                this.size = size;
            }

            public boolean isCopied() {
                return this.copied;
            }

            public void set(int slice, Assumption<?> assumption) {
                this.copyIfNeeded();
                this.assumption.set(slice, assumption);
            }

            public CombinedAssumption unwrap() {
                return this.assumption;
            }

            private void copyIfNeeded() {
                if (!this.copied) {
                    this.copied = true;
                    this.assumption = this.assumption == null ? new CombinedAssumption(this.size) : new CombinedAssumption(this.assumption);
                }
            }
        }
    }
}

