/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow;

import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.List;

public class AssumptionUtil {
    public static <A extends Assumption<A>> boolean equals(A a1, A a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        return a1 == a2 || a1.equals(a2);
    }

    public static <A extends Assumption<A>> A join(A a1, A a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        return a1 != a2 ? a1.join(a2) : a1;
    }

    public static <E, A extends Assumption<A>> A join(List<E> edges, AssumptionMap<E, A> assumptionMap) {
        Object result = null;
        for (E edge : edges) {
            result = AssumptionUtil.join(result, assumptionMap.getAssumption(edge));
        }
        return result;
    }

    public static <E, A extends Assumption<A>> void setAssumptions(List<E> edges, List<A> assumptions, AssumptionMap<E, A> assumptionMap) {
        Preconditions.checkArgument(assumptions.size() == edges.size());
        for (int i = 0; i < edges.size(); ++i) {
            assumptionMap.setAssumption(edges.get(i), (Assumption)assumptions.get(i));
        }
    }

    public static <E, A extends Assumption<A>> void setAssumptions(List<E> edges, A assumption, AssumptionMap<E, A> assumptionMap) {
        for (E edge : edges) {
            assumptionMap.setAssumption(edge, assumption);
        }
    }

    public static <E, A extends Assumption<A>> String toString(List<E> inEdges, List<E> outEdges, AssumptionMap<E, A> assumptionMap) {
        StringBuilder result = new StringBuilder();
        for (E e : inEdges) {
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append(e);
            result.append("=");
            result.append(assumptionMap.getAssumption(e));
        }
        for (E e : outEdges) {
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append(e);
            result.append("=");
            result.append(assumptionMap.getAssumption(e));
        }
        return result.toString();
    }
}

