/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.gflow;

import com.google.gwt.dev.jjs.impl.gflow.Analysis;
import com.google.gwt.dev.jjs.impl.gflow.Assumption;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionMap;
import com.google.gwt.dev.jjs.impl.gflow.AssumptionUtil;
import com.google.gwt.dev.jjs.impl.gflow.FlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.Graph;
import com.google.gwt.dev.jjs.impl.gflow.IntegratedAnalysis;
import com.google.gwt.dev.jjs.impl.gflow.IntegratedFlowFunction;
import com.google.gwt.dev.jjs.impl.gflow.TransformationFunction;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class AnalysisSolver<N, E, T, G extends Graph<N, E, T>, A extends Assumption<A>> {
    public static boolean debug = false;
    private final boolean forward;

    public static <N, E, T, G extends Graph<N, E, T>, A extends Assumption<A>> Map<E, A> solve(G g, Analysis<N, E, G, A> analysis, boolean forward) {
        return super.solve(g, analysis);
    }

    public static <N, E, T, G extends Graph<N, E, T>, A extends Assumption<A>> boolean solveIntegrated(G g, IntegratedAnalysis<N, E, T, G, A> analysis, boolean forward) {
        return super.solveIntegrated(g, analysis);
    }

    private AnalysisSolver(boolean forward) {
        this.forward = forward;
    }

    private boolean actualize(G graph, final IntegratedAnalysis<N, E, T, G, A> analysis) {
        TransformationFunction function = new TransformationFunction<N, E, T, G, A>(){

            @Override
            public TransformationFunction.Transformation<T, G> transform(N node, G graph, AssumptionMap<E, A> assumptionMap) {
                boolean[] didAssumptionChange = new boolean[1];
                TransformationFunction.Transformation transformation = analysis.getIntegratedFlowFunction().interpretOrReplace(node, graph, new AssumptionMap<E, A>((Graph)graph, node, didAssumptionChange){
                    final /* synthetic */ Graph val$graph;
                    final /* synthetic */ Object val$node;
                    final /* synthetic */ boolean[] val$didAssumptionChange;
                    {
                        this.val$graph = graph;
                        this.val$node = object;
                        this.val$didAssumptionChange = blArray;
                    }

                    @Override
                    public A getAssumption(E edge) {
                        Preconditions.checkArgument(this.val$graph.getStart(edge) == this.val$node || this.val$graph.getEnd(edge) == this.val$node);
                        return AnalysisSolver.this.getEdgeAssumption(this.val$graph, edge);
                    }

                    @Override
                    public void setAssumption(E edge, A assumption) {
                        Preconditions.checkArgument(this.val$graph.getStart(edge) == this.val$node || this.val$graph.getEnd(edge) == this.val$node);
                        this.val$didAssumptionChange[0] = true;
                    }
                });
                Preconditions.checkArgument(transformation == null || !didAssumptionChange[0]);
                return transformation;
            }
        };
        return this.applyTransformation(graph, function);
    }

    private boolean applyTransformation(G graph, TransformationFunction<N, E, T, G, A> transformationFunction) {
        boolean didChange = false;
        for (Object node : graph.getNodes()) {
            TransformationFunction.Transformation<T, G> transformation = transformationFunction.transform(node, graph, new AssumptionMap<E, A>((Graph)graph, node){
                final /* synthetic */ Graph val$graph;
                final /* synthetic */ Object val$node;
                {
                    this.val$graph = graph;
                    this.val$node = object;
                }

                @Override
                public A getAssumption(E edge) {
                    Preconditions.checkArgument(this.val$graph.getStart(edge) == this.val$node || this.val$graph.getEnd(edge) == this.val$node);
                    return AnalysisSolver.this.getEdgeAssumption(this.val$graph, edge);
                }

                @Override
                public void setAssumption(E edge, A assumption) {
                    throw new IllegalStateException("Transformations should not change assumptions");
                }
            });
            if (transformation == null) continue;
            T actualizer = transformation.getGraphTransformer();
            Preconditions.checkNotNull(actualizer, "Null actualizer from: %s", transformationFunction);
            didChange = graph.transform(node, actualizer) || didChange;
        }
        return didChange;
    }

    private LinkedHashSet<N> buildInitialWorklist(G g) {
        ArrayList nodes = new ArrayList(g.getNodes());
        LinkedHashSet worklist = new LinkedHashSet(nodes.size());
        if (!this.forward) {
            Collections.reverse(nodes);
        }
        worklist.addAll(nodes);
        return worklist;
    }

    private A getEdgeAssumption(G graph, E edge) {
        return (A)((Assumption)graph.getEdgeData(edge));
    }

    private void initGraphAssumptions(Analysis<N, E, G, A> analysis, G graph) {
        analysis.setInitialGraphAssumptions(graph, new AssumptionMap<E, A>((Graph)graph){
            final /* synthetic */ Graph val$graph;
            {
                this.val$graph = graph;
            }

            @Override
            public A getAssumption(E edge) {
                return AnalysisSolver.this.getEdgeAssumption(this.val$graph, edge);
            }

            @Override
            public void setAssumption(E edge, A assumption) {
                AnalysisSolver.this.setEdgeAssumption(this.val$graph, edge, assumption);
            }
        });
    }

    private void iterate(G graph, final IntegratedAnalysis<N, E, T, G, A> integratedAnalysis) {
        if (debug) {
            System.err.println("-----------------------------------------");
            System.err.println("Iterate started on:");
            System.err.println(graph);
            System.err.println("-----------------------------------------");
        }
        final IntegratedFlowFunctionAdapter adapter = new IntegratedFlowFunctionAdapter(integratedAnalysis);
        Analysis analysis = new Analysis<N, E, G, A>(){

            @Override
            public FlowFunction<N, E, G, A> getFlowFunction() {
                return adapter;
            }

            @Override
            public void setInitialGraphAssumptions(G graph, AssumptionMap<E, A> assumptionMap) {
                integratedAnalysis.setInitialGraphAssumptions(graph, assumptionMap);
            }
        };
        this.solveImpl(graph, analysis);
    }

    private void resetEdgeData(G graph) {
        for (Object node : graph.getNodes()) {
            for (Object e : graph.getInEdges(node)) {
                graph.setEdgeData(e, null);
            }
            for (Object e : graph.getOutEdges(node)) {
                graph.setEdgeData(e, null);
            }
        }
        for (Object e : graph.getGraphOutEdges()) {
            graph.setEdgeData((Object)e, null);
        }
        for (Object e : graph.getGraphInEdges()) {
            graph.setEdgeData((Object)e, null);
        }
    }

    private void setEdgeAssumption(G graph, E edge, A assumption) {
        graph.setEdgeData(edge, assumption);
    }

    private Map<E, A> solve(G g, Analysis<N, E, G, A> analysis) {
        this.solveImpl(g, analysis);
        HashMap<Object, A> result = new HashMap<Object, A>();
        for (Object n : g.getNodes()) {
            for (Object e : g.getInEdges(n)) {
                result.put(e, this.getEdgeAssumption(g, e));
            }
            for (Object e : g.getOutEdges(n)) {
                result.put(e, this.getEdgeAssumption(g, e));
            }
        }
        for (Object e : g.getGraphInEdges()) {
            result.put(e, this.getEdgeAssumption(g, e));
        }
        for (Object e : g.getGraphOutEdges()) {
            result.put(e, this.getEdgeAssumption(g, e));
        }
        return result;
    }

    private void solveImpl(G graph, Analysis<N, E, G, A> analysis) {
        FlowFunction flowFunction = analysis.getFlowFunction();
        LinkedHashSet<N> worklist = this.buildInitialWorklist(graph);
        this.resetEdgeData(graph);
        this.initGraphAssumptions(analysis, graph);
        while (!worklist.isEmpty()) {
            Iterator iterator = worklist.iterator();
            Object node = iterator.next();
            iterator.remove();
            flowFunction.interpret(node, graph, new AssumptionMap<E, A>((Graph)graph, node, worklist){
                final /* synthetic */ Graph val$graph;
                final /* synthetic */ Object val$node;
                final /* synthetic */ LinkedHashSet val$worklist;
                {
                    this.val$graph = graph;
                    this.val$node = object;
                    this.val$worklist = linkedHashSet;
                }

                @Override
                public A getAssumption(E edge) {
                    Preconditions.checkArgument(this.val$graph.getStart(edge) == this.val$node || this.val$graph.getEnd(edge) == this.val$node);
                    return AnalysisSolver.this.getEdgeAssumption(this.val$graph, edge);
                }

                @Override
                public void setAssumption(E edge, A assumption) {
                    Object start = this.val$graph.getStart(edge);
                    Object end = this.val$graph.getEnd(edge);
                    Preconditions.checkArgument(start == this.val$node || end == this.val$node);
                    if (!AssumptionUtil.equals(AnalysisSolver.this.getEdgeAssumption(this.val$graph, edge), assumption)) {
                        AnalysisSolver.this.setEdgeAssumption(this.val$graph, edge, assumption);
                        if (start == this.val$node) {
                            if (end != null) {
                                this.val$worklist.add(end);
                            }
                        } else if (end == this.val$node) {
                            if (start != null) {
                                this.val$worklist.add(start);
                            }
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                }
            });
        }
    }

    private boolean solveIntegrated(G g, IntegratedAnalysis<N, E, T, G, A> analysis) {
        this.iterate(g, analysis);
        return this.actualize(g, analysis);
    }

    private final class IntegratedFlowFunctionAdapter
    implements FlowFunction<N, E, G, A> {
        private IntegratedFlowFunction<N, E, T, G, A> flowFunction;

        private IntegratedFlowFunctionAdapter(IntegratedAnalysis<N, E, T, G, A> analysis) {
            this.flowFunction = analysis.getIntegratedFlowFunction();
        }

        @Override
        public void interpret(N node, G graph, final AssumptionMap<E, A> assumptionMap) {
            int i;
            final boolean[] mapWasModified = new boolean[1];
            TransformationFunction.Transformation transformation = this.flowFunction.interpretOrReplace(node, graph, new AssumptionMap<E, A>(){

                @Override
                public A getAssumption(E edge) {
                    return assumptionMap.getAssumption(edge);
                }

                @Override
                public void setAssumption(E edge, A assumption) {
                    mapWasModified[0] = true;
                    assumptionMap.setAssumption(edge, assumption);
                }
            });
            if (transformation == null) {
                return;
            }
            Preconditions.checkArgument(!mapWasModified[0]);
            Object newSubgraph = transformation.getNewSubgraph();
            if (debug) {
                System.err.println("Applying transformation: " + transformation);
                System.err.println("Replacing");
                System.err.println(node);
                System.err.println("With graph:");
                System.err.println(newSubgraph);
            }
            final List inEdges = graph.getInEdges(node);
            List outEdges = graph.getOutEdges(node);
            Preconditions.checkArgument(newSubgraph.getGraphInEdges().size() == inEdges.size());
            Preconditions.checkArgument(newSubgraph.getGraphOutEdges().size() == outEdges.size());
            AnalysisSolver.this.iterate(newSubgraph, new IntegratedAnalysis<N, E, T, G, A>((Graph)newSubgraph, assumptionMap, outEdges){
                final /* synthetic */ Graph val$newSubgraph;
                final /* synthetic */ AssumptionMap val$assumptionMap;
                final /* synthetic */ List val$outEdges;
                {
                    this.val$newSubgraph = graph;
                    this.val$assumptionMap = assumptionMap;
                    this.val$outEdges = list2;
                }

                @Override
                public IntegratedFlowFunction<N, E, T, G, A> getIntegratedFlowFunction() {
                    return IntegratedFlowFunctionAdapter.this.flowFunction;
                }

                @Override
                public void setInitialGraphAssumptions(G graph, AssumptionMap<E, A> newAssumptionMap) {
                    int i;
                    for (i = 0; i < inEdges.size(); ++i) {
                        newAssumptionMap.setAssumption(this.val$newSubgraph.getGraphInEdges().get(i), this.val$assumptionMap.getAssumption(inEdges.get(i)));
                    }
                    for (i = 0; i < this.val$outEdges.size(); ++i) {
                        newAssumptionMap.setAssumption(this.val$newSubgraph.getGraphOutEdges().get(i), this.val$assumptionMap.getAssumption(this.val$outEdges.get(i)));
                    }
                }
            });
            for (i = 0; i < inEdges.size(); ++i) {
                assumptionMap.setAssumption(inEdges.get(i), AnalysisSolver.this.getEdgeAssumption(newSubgraph, newSubgraph.getGraphInEdges().get(i)));
            }
            for (i = 0; i < outEdges.size(); ++i) {
                assumptionMap.setAssumption(outEdges.get(i), AnalysisSolver.this.getEdgeAssumption(newSubgraph, newSubgraph.getGraphOutEdges().get(i)));
            }
        }
    }
}

