/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNumericEntry;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplaceRunAsyncs {
    private boolean errorsFound = false;
    private final TreeLogger logger;
    private final JProgram program;
    private final List<JRunAsync> runAsyncs = new ArrayList<JRunAsync>();

    public static void exec(TreeLogger logger, JProgram program) throws UnableToCompleteException {
        SpeedTracerLogger.Event codeSplitterEvent = SpeedTracerLogger.start(CompilerEventType.CODE_SPLITTER, "phase", "ReplaceRunAsyncs");
        TreeLogger branch = logger.branch(TreeLogger.TRACE, "Replacing GWT.runAsync with island loader calls");
        new ReplaceRunAsyncs(branch, program).execImpl();
        codeSplitterEvent.end(new String[0]);
    }

    static JMethodCall getBrowserLoaderConstructor(JProgram program) {
        JField field = program.getIndexedField("AsyncFragmentLoader.BROWSER_LOADER");
        JMethodCall initializerCall = (JMethodCall)field.getDeclarationStatement().getInitializer();
        assert (initializerCall.getArgs().size() == 2);
        return initializerCall;
    }

    static String getImplicitName(JMethod method) {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(method.getJsniSignature(true, false));
        String name = sb.toString();
        return name;
    }

    private static String nameFromClassLiteral(JClassLiteral classLiteral) {
        return classLiteral.getRefType().getName();
    }

    private ReplaceRunAsyncs(TreeLogger logger, JProgram program) {
        this.logger = logger;
        this.program = program;
    }

    private TreeLogger error(SourceInfo info, String message) {
        this.errorsFound = true;
        TreeLogger fileLogger = this.logger.branch(TreeLogger.ERROR, "Errors in '" + info.getFileName() + "'");
        String linePrefix = "";
        if (info.getStartLine() > 0) {
            linePrefix = "Line " + info.getStartLine() + ": ";
        }
        fileLogger.log(TreeLogger.ERROR, linePrefix + message);
        return fileLogger;
    }

    private void execImpl() throws UnableToCompleteException {
        AsyncCreateVisitor visitor = new AsyncCreateVisitor();
        visitor.accept(this.program);
        this.setNumEntriesInAsyncFragmentLoader(this.runAsyncs.size() + 1);
        this.program.setRunAsyncs(this.runAsyncs);
        new ReplaceRunAsyncResources().accept(this.program);
        if (this.errorsFound) {
            throw new UnableToCompleteException();
        }
    }

    private void setNumEntriesInAsyncFragmentLoader(int entryCount) {
        JMethodCall constructorCall = ReplaceRunAsyncs.getBrowserLoaderConstructor(this.program);
        assert (constructorCall.getArgs().get(0).getType() == JPrimitiveType.INT);
        constructorCall.setArg(0, new JNumericEntry(constructorCall.getSourceInfo(), "RunAsyncFragmentCount", entryCount));
    }

    private class ReplaceRunAsyncResources
    extends JModVisitor {
        private final Map<String, List<JRunAsync>> replacementsByName = new HashMap<String, List<JRunAsync>>();
        private final JMethod runAsyncCode;

        public ReplaceRunAsyncResources() {
            this.runAsyncCode = ReplaceRunAsyncs.this.program.getIndexedMethod("RunAsyncCode.runAsyncCode");
            for (JRunAsync replacement : ReplaceRunAsyncs.this.runAsyncs) {
                String name = replacement.getName();
                if (name == null) continue;
                List<JRunAsync> list = this.replacementsByName.get(name);
                if (list == null) {
                    list = new ArrayList<JRunAsync>();
                    this.replacementsByName.put(name, list);
                }
                list.add(replacement);
            }
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (x.getTarget() == this.runAsyncCode) {
                JExpression arg0 = x.getArgs().get(0);
                if (!(arg0 instanceof JClassLiteral)) {
                    ReplaceRunAsyncs.this.error(arg0.getSourceInfo(), "Only a class literal may be passed to runAsyncCode");
                    return;
                }
                JClassLiteral lit = (JClassLiteral)arg0;
                String name = ReplaceRunAsyncs.nameFromClassLiteral(lit);
                List<JRunAsync> matches = this.replacementsByName.get(name);
                SourceInfo info = x.getSourceInfo();
                if (matches == null || matches.size() == 0) {
                    ReplaceRunAsyncs.this.error(info, "No runAsync call is named " + name);
                    return;
                }
                if (matches.size() > 1) {
                    TreeLogger branch = ReplaceRunAsyncs.this.error(info, "Multiple runAsync calls are named " + name);
                    ArrayList<String> errors = new ArrayList<String>();
                    for (JRunAsync match : matches) {
                        errors.add("One call is at '" + match.getSourceInfo().getFileName() + ':' + match.getSourceInfo().getStartLine() + "'");
                    }
                    Collections.sort(errors);
                    for (String error : errors) {
                        branch.log(TreeLogger.ERROR, error);
                    }
                    return;
                }
                int splitPoint = matches.get(0).getRunAsyncId();
                JMethodCall newCall = new JMethodCall(info, null, ReplaceRunAsyncs.this.program.getIndexedMethod("RunAsyncCode.forSplitPointNumber"), new JExpression[0]);
                newCall.addArg(new JNumericEntry(info, "RunAsyncFragmentIndex", splitPoint));
                ctx.replaceMe(newCall);
            }
        }
    }

    private class AsyncCreateVisitor
    extends JModVisitor {
        private JMethod currentMethod;
        private final JMethod runAsyncOnsuccess;

        private AsyncCreateVisitor() {
            this.runAsyncOnsuccess = ReplaceRunAsyncs.this.program.getIndexedMethod("RunAsyncCallback.onSuccess");
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (method == this.runAsyncOnsuccess && this.currentMethod != null && this.currentMethod.getEnclosingType() == ReplaceRunAsyncs.this.program.getIndexedType("AsyncFragmentLoader")) {
                x.setVolatile();
                return;
            }
            boolean explicitClassLiteral = false;
            if (this.isRunAsyncMethod(method)) {
                JExpression asyncCallback;
                String name;
                switch (x.getArgs().size()) {
                    case 1: {
                        name = ReplaceRunAsyncs.getImplicitName(this.currentMethod);
                        asyncCallback = x.getArgs().get(0);
                        break;
                    }
                    case 2: {
                        JExpression arg0 = x.getArgs().get(0);
                        if (!(arg0 instanceof JClassLiteral)) {
                            ReplaceRunAsyncs.this.error(arg0.getSourceInfo(), "Only class literals may be used to name a call to GWT.runAsync()");
                            return;
                        }
                        name = ReplaceRunAsyncs.nameFromClassLiteral((JClassLiteral)arg0);
                        explicitClassLiteral = true;
                        asyncCallback = x.getArgs().get(1);
                        break;
                    }
                    default: {
                        throw new InternalCompilerException("runAsync call found with neither 1 nor 2 arguments: " + x);
                    }
                }
                int splitPoint = ReplaceRunAsyncs.this.runAsyncs.size() + 1;
                SourceInfo info = x.getSourceInfo();
                JMethod runAsyncMethod = ReplaceRunAsyncs.this.program.getIndexedMethod("AsyncFragmentLoader.runAsync");
                assert (runAsyncMethod != null);
                JMethodCall runAsyncCall = new JMethodCall(info, null, runAsyncMethod, new JExpression[0]);
                runAsyncCall.addArg(new JNumericEntry(info, "RunAsyncFragmentIndex", splitPoint));
                runAsyncCall.addArg(asyncCallback);
                JReferenceType callbackType = (JReferenceType)asyncCallback.getType().getUnderlyingType();
                JMethod callbackMethod = callbackType instanceof JClassType ? ((ReplaceRunAsyncs)ReplaceRunAsyncs.this).program.typeOracle.getInstanceMethodBySignature((JClassType)callbackType, "onSuccess()V") : ReplaceRunAsyncs.this.program.getIndexedMethod("RunAsyncCallback.onSuccess");
                if (callbackMethod == null || callbackMethod.isAbstract() && callbackMethod.isSynthetic()) {
                    ReplaceRunAsyncs.this.error(x.getSourceInfo(), "Only a RunAsyncCallback with a defined onSuccess() can be passed to runAsync().");
                    return;
                }
                JMethodCall onSuccessCall = new JMethodCall(info, asyncCallback, callbackMethod, new JExpression[0]);
                JRunAsync runAsyncNode = new JRunAsync(info, splitPoint, name, explicitClassLiteral, runAsyncCall, onSuccessCall);
                ReplaceRunAsyncs.this.runAsyncs.add(runAsyncNode);
                ctx.replaceMe(runAsyncNode);
            }
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            return true;
        }

        private boolean isRunAsyncMethod(JMethod method) {
            return method.getEnclosingType() == ReplaceRunAsyncs.this.program.getIndexedType("GWT") && method.getName().equals("runAsync");
        }
    }
}

