/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.codesplitter.Fragment;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentPartitionStrategy;
import com.google.gwt.dev.jjs.impl.codesplitter.LiveAtomsByRunAsyncSets;
import java.util.ArrayList;
import java.util.Collection;

class MergeBySimilarityFragmentPartitionStrategy
implements FragmentPartitionStrategy {
    private final int minSize;
    private final int targetNumberOfFragments;

    public MergeBySimilarityFragmentPartitionStrategy(int targetNumberOfFragments, int minSize) {
        this.targetNumberOfFragments = targetNumberOfFragments;
        this.minSize = minSize;
    }

    @Override
    public Collection<Fragment> partitionIntoFragments(TreeLogger logger, ControlFlowAnalyzer initialSequenceCfa, Collection<Collection<JRunAsync>> groupedNonInitialRunAsyncs) {
        Collection<Collection<JRunAsync>> fragmentRunAsyncLists = this.mergeRunAsyncs(logger, initialSequenceCfa, groupedNonInitialRunAsyncs);
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (Collection<JRunAsync> fragmentRunAsyncs : fragmentRunAsyncLists) {
            Fragment fragment = new Fragment(Fragment.Type.EXCLUSIVE, new Fragment[0]);
            fragment.addRunAsyncs(fragmentRunAsyncs);
            fragments.add(fragment);
        }
        return fragments;
    }

    private Collection<Collection<JRunAsync>> mergeRunAsyncs(TreeLogger logger, ControlFlowAnalyzer initialSequenceCfa, Collection<Collection<JRunAsync>> groupedRunAsyncs) {
        LiveAtomsByRunAsyncSets liveAtomsByRunAsyncSets = new LiveAtomsByRunAsyncSets(logger);
        liveAtomsByRunAsyncSets.recordLiveSubsetsAndEstimateTheirSizes(initialSequenceCfa, groupedRunAsyncs);
        int mergeCount = liveAtomsByRunAsyncSets.getRunAsyncCount() - this.targetNumberOfFragments;
        Collection<Collection<JRunAsync>> fragmentRunAsyncLists = liveAtomsByRunAsyncSets.mergeSimilarPairs(mergeCount);
        if (this.minSize > 0) {
            liveAtomsByRunAsyncSets.mergeSmallFragments(fragmentRunAsyncLists, this.minSize);
        }
        return fragmentRunAsyncLists;
    }
}

