/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitters;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

class LiveAtomsByRunAsyncSets {
    private static final int AVERAGE_METHOD_SIZE = 40;
    private static final int AVERAGE_NAME_SIZE = 2;
    private static final int FUNCTION_DEFINITION_CONSTANT_SIZE = "function".length() + "()".length();
    private final Map<JRunAsync, Integer> idForRunAsync = Maps.newHashMap();
    private Map<JField, BitSet> liveSubsetForField = Maps.newLinkedHashMap();
    private Map<JMethod, BitSet> liveSubsetForMethod = Maps.newLinkedHashMap();
    private Map<String, BitSet> liveSubsetForString = Maps.newLinkedHashMap();
    private Map<JDeclaredType, BitSet> liveSubsetForType = Maps.newLinkedHashMap();
    private int nextRunAsyncId = 0;
    private final Multiset<BitSet> payloadSizeBySubset = LinkedHashMultiset.create();
    private final Map<Integer, JRunAsync> runAsyncForId = Maps.newHashMap();
    private final TreeLogger logger;
    private Collection<Collection<JRunAsync>> groupedRunAsyncs;

    LiveAtomsByRunAsyncSets(TreeLogger logger) {
        this.logger = logger;
    }

    private static BitSet computeComplement(BitSet bitSet, int count) {
        BitSet notMergedSubset = (BitSet)bitSet.clone();
        notMergedSubset.flip(0, count);
        return notMergedSubset;
    }

    private static BitSet computeIntersection(BitSet thisSet, BitSet thatSet) {
        BitSet intersectionBitSet = (BitSet)thisSet.clone();
        intersectionBitSet.and(thatSet);
        return intersectionBitSet;
    }

    private static int getSizeEstimate(JDeclaredType type) {
        int defineClassSize = 52;
        int methodsSize = 5 * type.getMethods().size();
        return defineClassSize + methodsSize;
    }

    private static int getSizeEstimate(JField field) {
        return 2;
    }

    private static int getSizeEstimate(JMethod method) {
        int methodSize = FUNCTION_DEFINITION_CONSTANT_SIZE + 43 * method.getParams().size();
        return methodSize;
    }

    private static int getSizeEstimate(Object obj) {
        if (obj instanceof JField) {
            return LiveAtomsByRunAsyncSets.getSizeEstimate((JField)obj);
        }
        if (obj instanceof JMethod) {
            return LiveAtomsByRunAsyncSets.getSizeEstimate((JMethod)obj);
        }
        if (obj instanceof String) {
            return LiveAtomsByRunAsyncSets.getSizeEstimate((String)obj);
        }
        if (obj instanceof JDeclaredType) {
            return LiveAtomsByRunAsyncSets.getSizeEstimate((JDeclaredType)obj);
        }
        throw new UnsupportedOperationException("estimateSize unsupported for type " + obj.getClass().getName());
    }

    private static int getSizeEstimate(String string) {
        return string.length();
    }

    private static boolean isSubset(BitSet smallerSet, BitSet biggerSet) {
        return LiveAtomsByRunAsyncSets.computeIntersection(smallerSet, biggerSet).equals(smallerSet);
    }

    public int getRunAsyncCount() {
        return this.idForRunAsync.size();
    }

    public Collection<Collection<JRunAsync>> mergeSimilarPairs(int pairCount) {
        ArrayList<Collection<JRunAsync>> fragmentRunAsyncLists = Lists.newArrayList();
        BitSet mergedSubset = new BitSet();
        PriorityQueue<SubsetWithSize> subsetsDescending = this.computeSubsetsDescending();
        for (Collection<JRunAsync> runAsyncGroup : this.groupedRunAsyncs) {
            if (runAsyncGroup.size() <= 1) continue;
            fragmentRunAsyncLists.add(runAsyncGroup);
            mergedSubset.or(this.asBitSet(runAsyncGroup));
        }
        while (fragmentRunAsyncLists.size() < pairCount && !subsetsDescending.isEmpty()) {
            BitSet largestSubset = subsetsDescending.poll().subset;
            if (largestSubset.intersects(mergedSubset)) continue;
            this.logger.log(TreeLogger.Type.DEBUG, "Merging " + largestSubset);
            fragmentRunAsyncLists.add(this.asRunAsyncList(largestSubset));
            mergedSubset.or(largestSubset);
        }
        BitSet notMergedSubset = LiveAtomsByRunAsyncSets.computeComplement(mergedSubset, this.getRunAsyncCount());
        fragmentRunAsyncLists.addAll(CodeSplitters.getListOfLists(this.asRunAsyncList(notMergedSubset)));
        return fragmentRunAsyncLists;
    }

    public Collection<Collection<JRunAsync>> mergeSmallFragments(Collection<Collection<JRunAsync>> fragmentRunAsyncLists, int minSize) {
        ArrayList<JRunAsync> smallFragmentRunAsyncs = Lists.newArrayList();
        Iterator<Collection<JRunAsync>> fragmentIterator = fragmentRunAsyncLists.iterator();
        while (fragmentIterator.hasNext()) {
            Collection<JRunAsync> fragmentRunAsyncs = fragmentIterator.next();
            if (!this.isFragmentTooSmall(fragmentRunAsyncs, minSize)) continue;
            smallFragmentRunAsyncs.addAll(fragmentRunAsyncs);
            fragmentIterator.remove();
        }
        if (!smallFragmentRunAsyncs.isEmpty() && !this.isFragmentTooSmall(smallFragmentRunAsyncs, minSize)) {
            fragmentRunAsyncLists.add(smallFragmentRunAsyncs);
            this.logger.log(TreeLogger.Type.DEBUG, "Merging small fragments " + smallFragmentRunAsyncs + " together ");
        } else if (!smallFragmentRunAsyncs.isEmpty()) {
            this.logger.log(TreeLogger.Type.DEBUG, "Merging small fragments " + smallFragmentRunAsyncs + " into leftovers ");
        }
        return fragmentRunAsyncLists;
    }

    public void recordLiveSubsetsAndEstimateTheirSizes(ControlFlowAnalyzer initialSequenceCfa, Collection<Collection<JRunAsync>> groupedRunAsyncs) {
        this.groupedRunAsyncs = groupedRunAsyncs;
        for (Collection<JRunAsync> runAsyncGroup : groupedRunAsyncs) {
            for (JRunAsync runAsync : runAsyncGroup) {
                ControlFlowAnalyzer withRunAsyncCfa = new ControlFlowAnalyzer(initialSequenceCfa);
                withRunAsyncCfa.traverseFromRunAsync(runAsync);
                this.recordLiveSubset(withRunAsyncCfa, runAsync);
            }
        }
        this.accumulatePayloadSizes();
    }

    private <T> void accumulatePayloadSizes(Map<T, BitSet> liveSubsetsByAtom) {
        for (Map.Entry<T, BitSet> entry : liveSubsetsByAtom.entrySet()) {
            BitSet liveSubset = entry.getValue();
            T atom = entry.getKey();
            if (liveSubset.cardinality() > 2) continue;
            this.payloadSizeBySubset.add(liveSubset, LiveAtomsByRunAsyncSets.getSizeEstimate(atom));
        }
    }

    private void addRunAsync(JRunAsync runAsync) {
        int runAsyncId = this.nextRunAsyncId++;
        this.idForRunAsync.put(runAsync, runAsyncId);
        this.runAsyncForId.put(runAsyncId, runAsync);
    }

    private BitSet asBitSet(Collection<JRunAsync> runAsyncs) {
        BitSet result = new BitSet();
        for (JRunAsync runAsync : runAsyncs) {
            result.set(this.getIdForRunAsync(runAsync));
        }
        return result;
    }

    private List<JRunAsync> asRunAsyncList(BitSet subset) {
        int runAsyncId = -1;
        ArrayList<JRunAsync> runAsyncs = Lists.newArrayList();
        while ((runAsyncId = subset.nextSetBit(runAsyncId + 1)) != -1) {
            runAsyncs.add(this.runAsyncForId.get(runAsyncId));
        }
        return runAsyncs;
    }

    private PriorityQueue<SubsetWithSize> computeSubsetsDescending() {
        PriorityQueue<SubsetWithSize> subsetsDescending = new PriorityQueue<SubsetWithSize>();
        for (BitSet subset : this.payloadSizeBySubset.elementSet()) {
            if (subset.cardinality() != 2) continue;
            subsetsDescending.add(new SubsetWithSize(subset, this.payloadSizeBySubset.count(subset)));
        }
        return subsetsDescending;
    }

    private void accumulatePayloadSizes() {
        this.accumulatePayloadSizes(this.liveSubsetForField);
        this.accumulatePayloadSizes(this.liveSubsetForMethod);
        this.accumulatePayloadSizes(this.liveSubsetForString);
        this.accumulatePayloadSizes(this.liveSubsetForType);
    }

    private int getIdForRunAsync(JRunAsync runAsync) {
        return this.idForRunAsync.get(runAsync);
    }

    private boolean isFragmentTooSmall(Collection<JRunAsync> fragmentRunAsyncs, int minSize) {
        BitSet fragmentSubset = this.asBitSet(fragmentRunAsyncs);
        int size = 0;
        for (BitSet subset : this.payloadSizeBySubset.elementSet()) {
            if (!LiveAtomsByRunAsyncSets.isSubset(subset, fragmentSubset) || (size += this.payloadSizeBySubset.count(subset)) < minSize) continue;
            return false;
        }
        return true;
    }

    private ControlFlowAnalyzer recordLiveSubset(ControlFlowAnalyzer cfa, JRunAsync runAsync) {
        this.addRunAsync(runAsync);
        for (JNode jNode : cfa.getLiveFieldsAndMethods()) {
            if (jNode instanceof JField) {
                this.setLive(this.liveSubsetForField, (JField)jNode, runAsync);
            }
            if (!(jNode instanceof JMethod)) continue;
            this.setLive(this.liveSubsetForMethod, (JMethod)jNode, runAsync);
        }
        for (JField jField : cfa.getFieldsWritten()) {
            this.setLive(this.liveSubsetForField, jField, runAsync);
        }
        for (String string : cfa.getLiveStrings()) {
            this.setLive(this.liveSubsetForString, string, runAsync);
        }
        for (JReferenceType jReferenceType : cfa.getInstantiatedTypes()) {
            if (!(jReferenceType instanceof JDeclaredType)) continue;
            this.setLive(this.liveSubsetForType, (JDeclaredType)jReferenceType, runAsync);
        }
        return cfa;
    }

    private <T> boolean setLive(Map<T, BitSet> liveSubsetsByAtom, T atom, JRunAsync runAsync) {
        int runAsyncId = this.idForRunAsync.get(runAsync);
        BitSet liveSubset = liveSubsetsByAtom.get(atom);
        if (liveSubset == null) {
            liveSubset = new BitSet();
            liveSubset.set(runAsyncId);
            liveSubsetsByAtom.put(atom, liveSubset);
            return true;
        }
        if (liveSubset.get(runAsyncId)) {
            return false;
        }
        liveSubset.set(runAsyncId);
        return true;
    }

    private static class SubsetWithSize
    implements Comparable<SubsetWithSize> {
        private final int size;
        private final BitSet subset;

        public SubsetWithSize(BitSet subset, int size) {
            this.subset = subset;
            this.size = size;
        }

        @Override
        public int compareTo(SubsetWithSize o) {
            return Integer.valueOf(o.size).compareTo(this.size);
        }
    }
}

