/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.codesplitter.Fragment;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.Collection;

public class FragmentPartitioningResult {
    private final int[] runAsyncIdToFragment;
    private final int fragmentCount;
    private final int lastInitialFragmentId;

    FragmentPartitioningResult(Collection<Fragment> fragments, int runAsyncCount) {
        this.checkFragmentNumberingAssumptions(fragments);
        this.fragmentCount = fragments.size();
        this.runAsyncIdToFragment = new int[runAsyncCount + 1];
        int lastInitialFragmentIdSoFar = -1;
        for (Fragment fragment : fragments) {
            if (fragment.getType() == Fragment.Type.INITIAL) {
                Preconditions.checkState(lastInitialFragmentIdSoFar < fragment.getFragmentId());
                lastInitialFragmentIdSoFar = fragment.getFragmentId();
            }
            for (JRunAsync runAsync : fragment.getRunAsyncs()) {
                this.runAsyncIdToFragment[runAsync.getRunAsyncId()] = fragment.getFragmentId();
            }
        }
        this.lastInitialFragmentId = lastInitialFragmentIdSoFar;
    }

    public int getCommonAncestorFragmentId(int thisFragmentId, int thatFragmentId) {
        if (thisFragmentId == thatFragmentId) {
            return thisFragmentId;
        }
        if (thisFragmentId > this.lastInitialFragmentId && thatFragmentId > this.lastInitialFragmentId) {
            return this.getLeftoverFragmentId();
        }
        return Math.min(thisFragmentId, thatFragmentId);
    }

    public int getFragmentForRunAsync(int splitpoint) {
        return this.runAsyncIdToFragment[splitpoint];
    }

    public int getLeftoverFragmentId() {
        return this.getFragmentCount() - 1;
    }

    public int getFragmentCount() {
        return this.fragmentCount;
    }

    private void checkFragmentNumberingAssumptions(Collection<Fragment> fragments) {
        int lastSeenId = -1;
        Fragment.Type lastTypeSeen = Fragment.Type.INITIAL;
        boolean leftoversFragmentSeen = false;
        int leftoversFragmentId = -1;
        for (Fragment fragment : fragments) {
            Preconditions.checkState(fragment.getFragmentId() == lastSeenId + 1);
            lastSeenId = fragment.getFragmentId();
            Preconditions.checkState(fragment.getType().ordinal() >= lastTypeSeen.ordinal());
            lastTypeSeen = fragment.getType();
            if (fragment.getType() != Fragment.Type.NOT_EXCLUSIVE) continue;
            Preconditions.checkState(!leftoversFragmentSeen);
            leftoversFragmentSeen = true;
            leftoversFragmentId = fragment.getFragmentId();
        }
        Preconditions.checkState(leftoversFragmentId == -1 || leftoversFragmentId == lastSeenId);
    }
}

