/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.codesplitter.LivenessPredicate;
import com.google.gwt.dev.js.JsSafeCloner;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FragmentExtractor {
    private final JsProgram jsprogram;
    private final JavaToJavaScriptMap map;
    private final JsName asyncFragmentLoaderOnLoadFnName;
    private final JsName defineClassFnName;
    private StatementLogger statementLogger = new StatementLogger(){

        @Override
        public void log(JsStatement statement, boolean include) {
        }
    };

    private static JsExprStmt createDefineClassClone(JsExprStmt defineClassStatement) {
        JsSafeCloner.Cloner cloner = new JsSafeCloner.Cloner();
        cloner.accept(defineClassStatement.getExpression());
        JsExprStmt minimalDefineClassStatement = cloner.getExpression().makeStmt();
        return minimalDefineClassStatement;
    }

    public FragmentExtractor(JProgram jprogram, JsProgram jsprogram, JavaToJavaScriptMap map) {
        this(jsprogram, map, JsUtils.getJsNameForMethod(map, jprogram, "AsyncFragmentLoader.onLoad"), JsUtils.getJsNameForMethod(map, jprogram, "Runtime.defineClass"));
    }

    public FragmentExtractor(JsProgram jsprogram, JavaToJavaScriptMap map, JsName asyncFragmentLoaderOnLoadFnName, JsName defineClassFnName) {
        this.jsprogram = jsprogram;
        this.map = map;
        this.asyncFragmentLoaderOnLoadFnName = asyncFragmentLoaderOnLoadFnName;
        this.defineClassFnName = defineClassFnName;
    }

    public List<JsStatement> createOnLoadedCall(int fragmentId) {
        SourceInfo sourceInfo = this.jsprogram.getSourceInfo();
        JsInvocation call = new JsInvocation(sourceInfo);
        call.setQualifier(this.wrapWithEntry(this.asyncFragmentLoaderOnLoadFnName.makeRef(sourceInfo)));
        call.getArguments().add(new JsNumberLiteral(sourceInfo, fragmentId));
        List<JsStatement> newStats = Collections.singletonList(call.makeStmt());
        return newStats;
    }

    public List<JsStatement> extractStatements(LivenessPredicate livenessPredicate, LivenessPredicate alreadyLoadedPredicate) {
        ArrayList<JsStatement> extractedStats = new ArrayList<JsStatement>();
        JDeclaredType currentVtableType = null;
        JDeclaredType pendingVtableType = null;
        JsExprStmt pendingDefineClass = null;
        List<JsStatement> statements = this.jsprogram.getGlobalBlock().getStatements();
        for (JsStatement statement : statements) {
            JDeclaredType vtableType;
            boolean keep;
            JDeclaredType vtableTypeAssigned = this.vtableTypeAssigned(statement);
            if (vtableTypeAssigned != null) {
                boolean liveConstructors;
                MinimalDefineClassResult minimalDefineClassResult = this.createMinimalDefineClass(livenessPredicate, alreadyLoadedPredicate, (JsExprStmt)statement);
                boolean liveType = !alreadyLoadedPredicate.isLive(vtableTypeAssigned) && livenessPredicate.isLive(vtableTypeAssigned);
                boolean bl = liveConstructors = minimalDefineClassResult.liveConstructorCount > 0;
                if (liveConstructors || liveType) {
                    statement = minimalDefineClassResult.statement;
                    keep = true;
                } else {
                    pendingDefineClass = minimalDefineClassResult.statement;
                    pendingVtableType = vtableTypeAssigned;
                    keep = false;
                }
            } else {
                keep = this.containsRemovableVars(statement) ? !((statement = this.removeSomeVars((JsVars)statement, livenessPredicate, alreadyLoadedPredicate)) instanceof JsEmpty) : this.isLive(statement, livenessPredicate) && !this.isLive(statement, alreadyLoadedPredicate);
            }
            this.statementLogger.log(statement, keep);
            if (!keep) continue;
            if (vtableTypeAssigned != null) {
                currentVtableType = vtableTypeAssigned;
            }
            if ((vtableType = this.vtableTypeNeeded(statement)) != null && vtableType != currentVtableType) {
                assert (pendingVtableType == vtableType || pendingDefineClass == null);
                if (pendingDefineClass != null) {
                    extractedStats.add(pendingDefineClass);
                }
                currentVtableType = pendingVtableType;
                pendingDefineClass = null;
                pendingVtableType = null;
            }
            extractedStats.add(statement);
        }
        return extractedStats;
    }

    public Set<JMethod> findAllMethodsStillInJavaScript() {
        HashSet<JMethod> methodsInJs = new HashSet<JMethod>();
        for (int fragment = 0; fragment < this.jsprogram.getFragmentCount(); ++fragment) {
            for (JsStatement statement : this.jsprogram.getFragmentBlock(fragment).getStatements()) {
                JMethod method = this.map.methodForStatement(statement);
                if (method == null) continue;
                methodsInJs.add(method);
            }
        }
        return methodsInJs;
    }

    public void setStatementLogger(StatementLogger logger) {
        this.statementLogger = logger;
    }

    private boolean containsRemovableVars(JsStatement statement) {
        if (statement instanceof JsVars) {
            for (JsVars.JsVar var : (JsVars)statement) {
                JField field = this.map.nameToField(var.getName());
                if (field == null) continue;
                return true;
            }
        }
        return false;
    }

    private MinimalDefineClassResult createMinimalDefineClass(LivenessPredicate livenessPredicate, LivenessPredicate alreadyLoadedPredicate, JsExprStmt defineClassStatement) {
        DefineClassMinimizerVisitor defineClassMinimizerVisitor = new DefineClassMinimizerVisitor(alreadyLoadedPredicate, livenessPredicate);
        JsExprStmt minimalDefineClassStatement = FragmentExtractor.createDefineClassClone(defineClassStatement);
        defineClassMinimizerVisitor.accept(minimalDefineClassStatement);
        return new MinimalDefineClassResult(minimalDefineClassStatement, defineClassMinimizerVisitor.liveConstructorCount);
    }

    private boolean isLive(JsStatement statement, LivenessPredicate livenessPredicate) {
        JDeclaredType type = this.map.typeForStatement(statement);
        if (type != null) {
            return livenessPredicate.isLive(type);
        }
        JMethod method = this.map.methodForStatement(statement);
        if (method != null) {
            if (!livenessPredicate.isLive(method)) {
                return false;
            }
            return !method.needsDynamicDispatch() || livenessPredicate.isLive(method.getEnclosingType());
        }
        return livenessPredicate.miscellaneousStatementsAreLive();
    }

    private boolean isLive(JsVars.JsVar var, LivenessPredicate livenessPredicate) {
        JField field = this.map.nameToField(var.getName());
        if (field != null) {
            return livenessPredicate.isLive(field);
        }
        return livenessPredicate.miscellaneousStatementsAreLive();
    }

    private JsStatement removeSomeVars(JsVars stat, LivenessPredicate currentLivenessPredicate, LivenessPredicate alreadyLoadedPredicate) {
        JsVars newVars = new JsVars(stat.getSourceInfo(), new JsVars.JsVar[0]);
        for (JsVars.JsVar var : stat) {
            if (!this.isLive(var, currentLivenessPredicate) || this.isLive(var, alreadyLoadedPredicate)) continue;
            newVars.add(var);
        }
        if (newVars.getNumVars() == stat.getNumVars()) {
            return stat;
        }
        if (newVars.iterator().hasNext()) {
            return newVars;
        }
        return new JsEmpty(stat.getSourceInfo());
    }

    private JDeclaredType vtableTypeAssigned(JsStatement statement) {
        if (!(statement instanceof JsExprStmt)) {
            return null;
        }
        JsExprStmt expr = (JsExprStmt)statement;
        if (expr.getExpression() instanceof JsInvocation) {
            JsInvocation call = (JsInvocation)expr.getExpression();
            if (!(call.getQualifier() instanceof JsNameRef)) {
                return null;
            }
            JsNameRef func = (JsNameRef)call.getQualifier();
            if (func.getName() != this.defineClassFnName) {
                return null;
            }
            return this.map.typeForStatement(statement);
        }
        if (!(expr.getExpression() instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binExpr = (JsBinaryOperation)expr.getExpression();
        if (binExpr.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        if (!(binExpr.getArg1() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef lhs = (JsNameRef)binExpr.getArg1();
        JsName underBar = this.jsprogram.getScope().findExistingName("_");
        assert (underBar != null);
        if (lhs.getName() != underBar) {
            return null;
        }
        if (!(binExpr.getArg2() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef rhsRef = (JsNameRef)binExpr.getArg2();
        if (!(rhsRef.getQualifier() instanceof JsNameRef)) {
            return null;
        }
        if (!((JsNameRef)rhsRef.getQualifier()).getShortIdent().equals("String")) {
            return null;
        }
        if (!rhsRef.getName().getShortIdent().equals("prototype")) {
            return null;
        }
        return this.map.typeForStatement(statement);
    }

    private JDeclaredType vtableTypeNeeded(JsStatement statement) {
        JMethod method = this.map.methodForStatement(statement);
        if (method != null && method.needsDynamicDispatch()) {
            return method.getEnclosingType();
        }
        return null;
    }

    private JsInvocation wrapWithEntry(JsExpression expression) {
        SourceInfo sourceInfo = expression.getSourceInfo();
        JsInvocation call = new JsInvocation(sourceInfo, (JsExpression)this.jsprogram.getScope().findExistingName("$entry").makeRef(sourceInfo), expression);
        return call;
    }

    private static class MinimalDefineClassResult {
        private int liveConstructorCount;
        private JsExprStmt statement;

        public MinimalDefineClassResult(JsExprStmt statement, int liveConstructorCount) {
            this.statement = statement;
            this.liveConstructorCount = liveConstructorCount;
        }
    }

    private class DefineClassMinimizerVisitor
    extends JsModVisitor {
        private final LivenessPredicate alreadyLoadedPredicate;
        private final LivenessPredicate livenessPredicate;
        private int liveConstructorCount;

        private DefineClassMinimizerVisitor(LivenessPredicate alreadyLoadedPredicate, LivenessPredicate livenessPredicate) {
            this.alreadyLoadedPredicate = alreadyLoadedPredicate;
            this.livenessPredicate = livenessPredicate;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            boolean isConstructorLive;
            JClassType classType = FragmentExtractor.this.map.nameToType(x.getName());
            JMethod method = FragmentExtractor.this.map.nameToMethod(x.getName());
            JMethod jMethod = method = method instanceof JConstructor ? method : null;
            if (classType == null && method == null) {
                return;
            }
            assert (classType != null || method != null);
            boolean bl = method != null ? !this.alreadyLoadedPredicate.isLive(method) && this.livenessPredicate.isLive(method) : (isConstructorLive = !this.alreadyLoadedPredicate.isLive(classType) && this.livenessPredicate.isLive(classType));
            if (isConstructorLive) {
                ++this.liveConstructorCount;
            } else {
                ctx.removeMe();
            }
        }

        @Override
        protected <T extends JsVisitable> void doAcceptList(List<T> collection) {
            this.doAcceptWithInsertRemove(collection);
        }
    }

    public static interface StatementLogger {
        public void log(JsStatement var1, boolean var2);
    }
}

