/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class Fragment {
    private int fragmentId = -1;
    private Set<JRunAsync> runAsyncs = Sets.newHashSet();
    private List<JsStatement> statements;
    private Type type;
    private Set<Fragment> immediateAncestors = Sets.newHashSet();

    public Fragment(Type type, Fragment ... ancestorFragments) {
        this.type = type;
        this.addImmediateAncestors(ancestorFragments);
    }

    public void addRunAsync(JRunAsync runAsync) {
        Preconditions.checkArgument(!this.runAsyncs.contains(runAsync), "Fragment %n already contains runAsync %n", runAsync.getRunAsyncId());
        this.runAsyncs.add(runAsync);
    }

    public void addRunAsyncs(Collection<JRunAsync> runAsyncs) {
        this.runAsyncs.addAll(runAsyncs);
    }

    public void addImmediateAncestors(Fragment ... ancestorFragments) {
        for (Fragment ancestorFragment : ancestorFragments) {
            this.immediateAncestors.add(ancestorFragment);
        }
    }

    public void addStatements(List<JsStatement> statements) {
        this.statements.addAll(statements);
    }

    public int getFragmentId() {
        assert (this.fragmentId >= 0);
        return this.fragmentId;
    }

    public Set<JRunAsync> getRunAsyncs() {
        return this.runAsyncs;
    }

    public List<JsStatement> getStatements() {
        return this.statements;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isExclusive() {
        return this.type == Type.EXCLUSIVE;
    }

    public boolean isInitial() {
        return this.type == Type.INITIAL;
    }

    public void setFragmentId(int fragmentId) {
        Preconditions.checkArgument(fragmentId >= 0, "Fragment id  %s is not >= 0", fragmentId);
        Preconditions.checkArgument(fragmentId > 0 || this.type == Type.INITIAL, "Fragment 0 is not INITIAL");
        this.fragmentId = fragmentId;
    }

    public void setStatements(List<JsStatement> statements) {
        this.statements = statements;
    }

    static enum Type {
        INITIAL,
        EXCLUSIVE,
        NOT_EXCLUSIVE;

    }
}

