/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.codesplitter.Fragment;
import com.google.gwt.dev.jjs.impl.codesplitter.LivenessPredicate;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ExclusivityMap {
    public static final Fragment NOT_EXCLUSIVE = new Fragment(Fragment.Type.NOT_EXCLUSIVE, new Fragment[0]){

        @Override
        public int getFragmentId() {
            throw this.makeUnsupportedException("getFragmentId");
        }

        @Override
        public List<JsStatement> getStatements() {
            throw this.makeUnsupportedException("getStatements");
        }

        @Override
        public void setStatements(List<JsStatement> statements) {
            throw this.makeUnsupportedException("setStatements");
        }

        @Override
        public void addStatements(List<JsStatement> statements) {
            throw this.makeUnsupportedException("addStatements");
        }

        @Override
        public Set<JRunAsync> getRunAsyncs() {
            throw this.makeUnsupportedException("getRunAsyncs");
        }

        @Override
        public void addRunAsync(JRunAsync runAsync) {
            throw this.makeUnsupportedException("addSplitPoint");
        }

        @Override
        public void setFragmentId(int fragmentId) {
            throw this.makeUnsupportedException("setFragmentId");
        }

        private UnsupportedOperationException makeUnsupportedException(String methodName) {
            return new UnsupportedOperationException(methodName + " is not supported in the dummy NOT_EXCLUSIVE fragment");
        }
    };
    private Map<JField, Fragment> fragmentForField = Maps.newHashMap();
    private Map<JMethod, Fragment> fragmentForMethod = Maps.newHashMap();
    private Map<JDeclaredType, Fragment> fragmentForType = Maps.newHashMap();

    ExclusivityMap() {
    }

    LivenessPredicate getLivenessPredicate(Fragment fragment) {
        return new ExclusivityMapLivenessPredicate(fragment);
    }

    public boolean isLiveInFragment(Fragment fragment, JField field) {
        return ExclusivityMap.isLiveInFragment(this.fragmentForField, field, fragment);
    }

    public boolean isLiveInFragment(Fragment fragment, JMethod method) {
        return ExclusivityMap.isLiveInFragment(this.fragmentForMethod, method, fragment);
    }

    public boolean isLiveInFragment(Fragment fragment, JDeclaredType type) {
        return ExclusivityMap.isLiveInFragment(this.fragmentForType, type, fragment);
    }

    private static Set<JClassLiteral> classLiteralsIn(JExpression expression) {
        final HashSet<JClassLiteral> literals = Sets.newHashSet();
        new JVisitor(){

            @Override
            public void endVisit(JClassLiteral classLiteral, Context ctx) {
                literals.add(classLiteral);
            }
        }.accept(expression);
        return literals;
    }

    private static Set<JMethod> methodsReferencesIn(JExpression expression) {
        final HashSet<JMethod> methods = Sets.newHashSet();
        new JVisitor(){

            @Override
            public void endVisit(JsniMethodRef jsniMethodRef, Context ctx) {
                methods.add(jsniMethodRef.getTarget());
            }
        }.accept(expression);
        return methods;
    }

    public static ExclusivityMap computeExclusivityMap(Collection<Fragment> exclusiveFragments, ControlFlowAnalyzer completeCfa, Map<Fragment, ControlFlowAnalyzer> notExclusiveCfaByFragment) {
        ExclusivityMap exclusivityMap = new ExclusivityMap();
        exclusivityMap.compute(exclusiveFragments, completeCfa, notExclusiveCfaByFragment);
        return exclusivityMap;
    }

    public void fixUpLoadOrderDependencies(TreeLogger logger, JProgram jprogram, Set<JMethod> methodsStillInJavaScript) {
        this.fixUpLoadOrderDependenciesForMethods(logger, jprogram, methodsStillInJavaScript);
        this.fixUpLoadOrderDependenciesForTypes(logger, jprogram);
        this.fixUpLoadOrderDependenciesForClassLiterals(logger, jprogram, methodsStillInJavaScript);
    }

    private void compute(Collection<Fragment> exclusiveFragments, ControlFlowAnalyzer completeCfa, Map<Fragment, ControlFlowAnalyzer> notExclusiveCfaByFragment) {
        Set<JField> allLiveFields = ExclusivityMap.filter(Sets.union(completeCfa.getLiveFieldsAndMethods(), completeCfa.getFieldsWritten()), JField.class);
        Set<JMethod> allLiveMethods = ExclusivityMap.filter(completeCfa.getLiveFieldsAndMethods(), JMethod.class);
        Set<JDeclaredType> allLiveTypes = ExclusivityMap.filter(completeCfa.getInstantiatedTypes(), JDeclaredType.class);
        for (Fragment fragment : exclusiveFragments) {
            assert (fragment.isExclusive());
            ControlFlowAnalyzer complementCfa = notExclusiveCfaByFragment.get(fragment);
            Sets.SetView<JField> nodesNotExclusiveToFragment = Sets.union(complementCfa.getLiveFieldsAndMethods(), complementCfa.getFieldsWritten());
            this.putIfAbsent(this.fragmentForField, fragment, Sets.difference(allLiveFields, nodesNotExclusiveToFragment));
            this.putIfAbsent(this.fragmentForMethod, fragment, Sets.difference(allLiveMethods, complementCfa.getLiveFieldsAndMethods()));
            this.putIfAbsent(this.fragmentForType, fragment, Sets.difference(allLiveTypes, ExclusivityMap.filter(complementCfa.getInstantiatedTypes(), JDeclaredType.class)));
        }
        this.putIfAbsent(this.fragmentForField, NOT_EXCLUSIVE, allLiveFields);
        this.putIfAbsent(this.fragmentForMethod, NOT_EXCLUSIVE, allLiveMethods);
        this.putIfAbsent(this.fragmentForType, NOT_EXCLUSIVE, allLiveTypes);
    }

    private void fixUpLoadOrderDependenciesForClassLiterals(TreeLogger logger, JProgram jprogram, Set<JMethod> methodsStillInJavaScript) {
        int numFixups = 0;
        ArrayDeque<JField> potentialClassLiteralFields = new ArrayDeque<JField>(jprogram.getTypeClassLiteralHolder().getFields());
        int numClassLiterals = potentialClassLiteralFields.size();
        while (!potentialClassLiteralFields.isEmpty()) {
            JField field = (JField)potentialClassLiteralFields.remove();
            if (!field.isStatic()) continue;
            Fragment classLiteralFragment = this.fragmentForField.get(field);
            JType type = jprogram.getTypeByClassLiteralField(field);
            Fragment classLiteralTypeFragment = this.fragmentForType.get(type);
            if (!ExclusivityMap.canReferenceAtomsFrom(classLiteralTypeFragment, classLiteralFragment)) {
                ++numFixups;
                this.fragmentForField.put(field, NOT_EXCLUSIVE);
                classLiteralFragment = NOT_EXCLUSIVE;
            }
            JExpression initializer = field.getInitializer();
            for (JClassLiteral superclassClassLiteral : ExclusivityMap.classLiteralsIn(initializer)) {
                JField superclassClassLiteralField = superclassClassLiteral.getField();
                Fragment superclassClassLiteralFragment = this.fragmentForField.get(superclassClassLiteralField);
                if (ExclusivityMap.canReferenceAtomsFrom(classLiteralFragment, superclassClassLiteralFragment)) continue;
                ++numFixups;
                this.fragmentForField.put(superclassClassLiteralField, NOT_EXCLUSIVE);
                potentialClassLiteralFields.add(superclassClassLiteralField);
            }
            for (JMethod referencedMethod : ExclusivityMap.methodsReferencesIn(initializer)) {
                Fragment referencedMethodFragment = this.fragmentForMethod.get(referencedMethod);
                if (!methodsStillInJavaScript.contains(referencedMethod) || ExclusivityMap.canReferenceAtomsFrom(classLiteralFragment, referencedMethodFragment)) continue;
                assert (referencedMethod.isStatic());
                ++numFixups;
                this.fragmentForMethod.put(referencedMethod, NOT_EXCLUSIVE);
            }
        }
        logger.log(TreeLogger.DEBUG, "Fixed up load-order dependencies by moving " + numFixups + " fields in class literal constructors to fragment 0, out of " + numClassLiterals);
    }

    private void fixUpLoadOrderDependenciesForMethods(TreeLogger logger, JProgram jprogram, Set<JMethod> methodsStillInJavaScript) {
        int numFixups = 0;
        block0: for (JDeclaredType type : jprogram.getDeclaredTypes()) {
            Fragment typeFrag = this.fragmentForType.get(type);
            if (typeFrag == null || !typeFrag.isExclusive()) continue;
            for (JMethod method : type.getMethods()) {
                if (!method.needsDynamicDispatch() || !methodsStillInJavaScript.contains(method) || typeFrag == this.fragmentForMethod.get(method)) continue;
                this.fragmentForType.put(type, NOT_EXCLUSIVE);
                ++numFixups;
                continue block0;
            }
        }
        logger.log(TreeLogger.DEBUG, "Fixed up load-order dependencies for instance methods by moving " + numFixups + " types to fragment 0, out of " + jprogram.getDeclaredTypes().size());
    }

    private void fixUpLoadOrderDependenciesForTypes(TreeLogger logger, JProgram jprogram) {
        int numFixups = 0;
        ArrayDeque<JDeclaredType> typesToCheck = new ArrayDeque<JDeclaredType>(jprogram.getDeclaredTypes().size());
        typesToCheck.addAll(jprogram.getDeclaredTypes());
        while (!typesToCheck.isEmpty()) {
            Fragment supertypeFrag;
            Fragment typeFrag;
            JDeclaredType type = (JDeclaredType)typesToCheck.remove();
            if (type.getSuperClass() == null || ExclusivityMap.canReferenceAtomsFrom(typeFrag = this.fragmentForType.get(type), supertypeFrag = this.fragmentForType.get(type.getSuperClass()))) continue;
            ++numFixups;
            this.fragmentForType.put(type.getSuperClass(), NOT_EXCLUSIVE);
            typesToCheck.add(type.getSuperClass());
        }
        logger.log(TreeLogger.DEBUG, "Fixed up load-order dependencies on supertypes by moving " + numFixups + " types to fragment 0, out of " + jprogram.getDeclaredTypes().size());
    }

    private static <T> Set<T> filter(Set<?> types, Class<T> clazz) {
        return Sets.filter(types, Predicates.instanceOf(clazz));
    }

    private static boolean canReferenceAtomsFrom(Fragment thisFragment, Fragment thatFragment) {
        return thisFragment == null || thisFragment == thatFragment || !thatFragment.isExclusive();
    }

    private static <T> boolean isLiveInFragment(Map<T, Fragment> map, T atom, Fragment expectedFragment) {
        Fragment actualFragment = map.get(atom);
        return actualFragment != null && (expectedFragment == actualFragment || !actualFragment.isExclusive());
    }

    private <T> void putIfAbsent(Map<T, Fragment> map, Fragment fragment, Iterable<T> atoms) {
        for (T atom : atoms) {
            if (map.containsKey(atom)) continue;
            map.put(atom, fragment);
        }
    }

    private class ExclusivityMapLivenessPredicate
    implements LivenessPredicate {
        private final Fragment fragment;

        public ExclusivityMapLivenessPredicate(Fragment fragment) {
            this.fragment = fragment;
        }

        @Override
        public boolean isLive(JDeclaredType type) {
            return ExclusivityMap.this.isLiveInFragment(this.fragment, type);
        }

        @Override
        public boolean isLive(JField field) {
            return ExclusivityMap.this.isLiveInFragment(this.fragment, field);
        }

        @Override
        public boolean isLive(JMethod method) {
            return ExclusivityMap.this.isLiveInFragment(this.fragment, method);
        }

        @Override
        public boolean miscellaneousStatementsAreLive() {
            return true;
        }
    }
}

