/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentExtractor;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVars;

class EchoStatementLogger
implements FragmentExtractor.StatementLogger {
    private final JavaToJavaScriptMap map;

    public EchoStatementLogger(JavaToJavaScriptMap map) {
        this.map = map;
    }

    @Override
    public void log(JsStatement statement, boolean include) {
        if (!include) {
            return;
        }
        if (statement instanceof JsExprStmt) {
            JsExpression expr = ((JsExprStmt)statement).getExpression();
            if (!(expr instanceof JsFunction)) {
                return;
            }
            JsFunction func = (JsFunction)expr;
            if (func.getName() == null) {
                return;
            }
            JMethod method = this.map.nameToMethod(func.getName());
            if (method == null) {
                return;
            }
            System.out.println(JProgram.getFullName(method));
        } else if (statement instanceof JsVars) {
            JsVars vars = (JsVars)statement;
            for (JsVars.JsVar var : vars) {
                JField field = this.map.nameToField(var.getName());
                if (field == null) continue;
                System.out.println(field.getQualifiedName());
            }
        }
    }
}

