/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl.codesplitter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.codesplitter.CfaLivenessPredicate;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitters;
import com.google.gwt.dev.jjs.impl.codesplitter.EchoStatementLogger;
import com.google.gwt.dev.jjs.impl.codesplitter.ExclusivityMap;
import com.google.gwt.dev.jjs.impl.codesplitter.Fragment;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentExtractor;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentPartitionStrategy;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentPartitioningResult;
import com.google.gwt.dev.jjs.impl.codesplitter.LivenessPredicate;
import com.google.gwt.dev.jjs.impl.codesplitter.MergeBySimilarityFragmentPartitionStrategy;
import com.google.gwt.dev.jjs.impl.codesplitter.MultipleDependencyGraphRecorder;
import com.google.gwt.dev.jjs.impl.codesplitter.NothingAlivePredicate;
import com.google.gwt.dev.jjs.impl.codesplitter.OneToOneFragmentPartitionStrategy;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNumericEntry;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodeSplitter {
    private final MultipleDependencyGraphRecorder dependencyRecorder;
    private final FragmentExtractor fragmentExtractor;
    private final LinkedHashSet<JRunAsync> initialLoadSequence;
    private final ControlFlowAnalyzer initiallyLiveCfa;
    private final JProgram jprogram;
    private final JsProgram jsprogram;
    private ControlFlowAnalyzer initialSequenceCfa;
    private final TreeLogger logger;
    private final boolean logFragmentMap;
    private final JavaToJavaScriptMap map;
    private final Set<JMethod> methodsStillInJavaScript;
    private final List<Fragment> fragments = Lists.newArrayList();
    private final FragmentPartitionStrategy partitionStrategy;

    public static ControlFlowAnalyzer computeInitiallyLive(JProgram jprogram) {
        return CodeSplitter.computeInitiallyLive(jprogram, MultipleDependencyGraphRecorder.NULL_RECORDER);
    }

    public static void exec(TreeLogger logger, JProgram jprogram, JsProgram jsprogram, JavaToJavaScriptMap map, int expectedFragmentCount, int minFragmentSize, MultipleDependencyGraphRecorder dependencyRecorder) {
        if (jprogram.getRunAsyncs().isEmpty()) {
            return;
        }
        SpeedTracerLogger.Event codeSplitterEvent = SpeedTracerLogger.start(CompilerEventType.CODE_SPLITTER, new String[0]);
        dependencyRecorder.open();
        new CodeSplitter(logger, jprogram, jsprogram, map, expectedFragmentCount, minFragmentSize, dependencyRecorder).execImpl();
        dependencyRecorder.close();
        codeSplitterEvent.end(new String[0]);
    }

    public static int computeTotalSize(int[] jsLengths) {
        int totalSize = 0;
        for (int size : jsLengths) {
            totalSize += size;
        }
        return totalSize;
    }

    private static ControlFlowAnalyzer computeInitiallyLive(JProgram jprogram, MultipleDependencyGraphRecorder dependencyRecorder) {
        dependencyRecorder.startDependencyGraph("initial", null);
        ControlFlowAnalyzer cfa = new ControlFlowAnalyzer(jprogram);
        cfa.setDependencyRecorder(dependencyRecorder);
        cfa.traverseEntryMethods();
        CodeSplitter.computeLivenessFromCodeGenTypes(jprogram, cfa);
        dependencyRecorder.endDependencyGraph();
        return cfa;
    }

    private static void computeLivenessFromCodeGenTypes(JProgram jprogram, ControlFlowAnalyzer cfa) {
        for (JClassType type : jprogram.immortalCodeGenTypes) {
            cfa.traverseFromInstantiationOf(type);
            for (JMethod method : type.getMethods()) {
                if (method.needsDynamicDispatch()) continue;
                cfa.traverseFrom(method);
            }
        }
    }

    private static Collection<Collection<JRunAsync>> groupAsyncsByClassLiteral(Collection<JRunAsync> runAsyncs) {
        ArrayList<Collection<JRunAsync>> result = Lists.newArrayList();
        Multimap<String, JRunAsync> asyncsGroupedByName = CodeSplitters.computeRunAsyncsByName(runAsyncs, true);
        result.addAll(asyncsGroupedByName.asMap().values());
        result.addAll(CodeSplitters.getListOfLists(Collections2.filter(runAsyncs, new Predicate<JRunAsync>(){

            @Override
            public boolean apply(JRunAsync runAsync) {
                return !runAsync.hasExplicitClassLiteral();
            }
        })));
        return result;
    }

    private CodeSplitter(TreeLogger logger, JProgram jprogram, JsProgram jsprogram, JavaToJavaScriptMap map, int expectedFragmentCount, int minFragmentSize, MultipleDependencyGraphRecorder dependencyRecorder) {
        this.logger = logger.branch(TreeLogger.TRACE, "Splitting JavaScript for incremental download");
        this.jprogram = jprogram;
        this.jsprogram = jsprogram;
        this.map = map;
        this.dependencyRecorder = dependencyRecorder;
        this.initialLoadSequence = jprogram.getInitialAsyncSequence();
        assert (this.initialLoadSequence != null);
        this.logFragmentMap = Boolean.getBoolean(CodeSplitters.PROP_LOG_FRAGMENT_MAP);
        this.fragmentExtractor = new FragmentExtractor(jprogram, jsprogram, map);
        this.initiallyLiveCfa = CodeSplitter.computeInitiallyLive(jprogram, dependencyRecorder);
        this.methodsStillInJavaScript = this.fragmentExtractor.findAllMethodsStillInJavaScript();
        this.partitionStrategy = expectedFragmentCount > 0 ? new MergeBySimilarityFragmentPartitionStrategy(CodeSplitters.getNumberOfExclusiveFragmentFromExpectedFragmentCount(this.initialLoadSequence.size(), expectedFragmentCount), minFragmentSize) : new OneToOneFragmentPartitionStrategy();
    }

    private List<JsStatement> statementsForFragment(int fragmentId, LivenessPredicate alreadyLoaded, LivenessPredicate liveNow) {
        if (this.logFragmentMap) {
            System.out.println();
            System.out.println("==== Fragment " + fragmentId + " ====");
            this.fragmentExtractor.setStatementLogger(new EchoStatementLogger(this.map));
        }
        return this.fragmentExtractor.extractStatements(liveNow, alreadyLoaded);
    }

    private Map<Fragment, ControlFlowAnalyzer> computeNotExclusiveCfaForFragments(Collection<Fragment> exclusiveFragments) {
        String dependencyGraphNameAfterInitialSequence = this.dependencyGraphNameAfterInitialSequence();
        HashMap<Fragment, ControlFlowAnalyzer> notExclusiveCfaByFragment = Maps.newHashMap();
        for (Fragment fragment : exclusiveFragments) {
            assert (fragment.isExclusive());
            this.dependencyRecorder.startDependencyGraph("sp" + fragment.getFragmentId(), dependencyGraphNameAfterInitialSequence);
            ControlFlowAnalyzer cfa = new ControlFlowAnalyzer(this.initialSequenceCfa);
            cfa.setDependencyRecorder(this.dependencyRecorder);
            for (Fragment otherFragment : exclusiveFragments) {
                if (otherFragment.isInitial() || otherFragment == fragment) continue;
                for (JRunAsync otherRunAsync : otherFragment.getRunAsyncs()) {
                    cfa.traverseFromRunAsync(otherRunAsync);
                }
            }
            this.dependencyRecorder.endDependencyGraph();
            notExclusiveCfaByFragment.put(fragment, cfa);
        }
        return notExclusiveCfaByFragment;
    }

    private ControlFlowAnalyzer computeCompleteCfa() {
        this.dependencyRecorder.startDependencyGraph("total", null);
        ControlFlowAnalyzer completeCfa = new ControlFlowAnalyzer(this.jprogram);
        completeCfa.setDependencyRecorder(this.dependencyRecorder);
        completeCfa.traverseEverything();
        this.dependencyRecorder.endDependencyGraph();
        return completeCfa;
    }

    private String dependencyGraphNameAfterInitialSequence() {
        if (this.initialLoadSequence.isEmpty()) {
            return "initial";
        }
        return "sp" + Iterables.getLast(this.initialLoadSequence).getRunAsyncId();
    }

    private ExclusivityMap computeExclusivityMapWithFixups(Collection<Fragment> exclusiveFragments) {
        ControlFlowAnalyzer completeCfa = this.computeCompleteCfa();
        Map<Fragment, ControlFlowAnalyzer> notExclusiveCfaByFragment = this.computeNotExclusiveCfaForFragments(exclusiveFragments);
        ExclusivityMap exclusivityMap = ExclusivityMap.computeExclusivityMap(exclusiveFragments, completeCfa, notExclusiveCfaByFragment);
        exclusivityMap.fixUpLoadOrderDependencies(this.logger, this.jprogram, this.methodsStillInJavaScript);
        return exclusivityMap;
    }

    /*
     * WARNING - void declaration
     */
    private void execImpl() {
        void var10_17;
        List<JsStatement> statements;
        Fragment lastInitialFragment = null;
        int nextFragmentIdToAssign = 0;
        NothingAlivePredicate alreadyLoaded = new NothingAlivePredicate();
        CfaLivenessPredicate liveNow = new CfaLivenessPredicate(this.initiallyLiveCfa);
        Fragment fragment = new Fragment(Fragment.Type.INITIAL, new Fragment[0]);
        fragment.setFragmentId(nextFragmentIdToAssign++);
        List<JsStatement> statementsForFragment = this.statementsForFragment(fragment.getFragmentId(), alreadyLoaded, liveNow);
        fragment.setStatements(statementsForFragment);
        lastInitialFragment = fragment;
        this.fragments.add(fragment);
        this.initialSequenceCfa = new ControlFlowAnalyzer(this.initiallyLiveCfa);
        String extendsCfa = "initial";
        ArrayList<Integer> initialFragmentNumberSequence = new ArrayList<Integer>();
        for (JRunAsync runAsync : this.initialLoadSequence) {
            CfaLivenessPredicate alreadyLoaded2 = new CfaLivenessPredicate(this.initialSequenceCfa);
            String depGraphName = "sp" + runAsync.getRunAsyncId();
            this.dependencyRecorder.startDependencyGraph(depGraphName, extendsCfa);
            extendsCfa = depGraphName;
            ControlFlowAnalyzer liveAfterSp = new ControlFlowAnalyzer(this.initialSequenceCfa);
            liveAfterSp.traverseFromRunAsync(runAsync);
            this.dependencyRecorder.endDependencyGraph();
            CfaLivenessPredicate cfaLivenessPredicate = new CfaLivenessPredicate(liveAfterSp);
            Fragment fragment2 = new Fragment(Fragment.Type.INITIAL, lastInitialFragment);
            fragment2.setFragmentId(nextFragmentIdToAssign++);
            fragment2.addRunAsync(runAsync);
            statements = this.statementsForFragment(fragment2.getFragmentId(), alreadyLoaded2, cfaLivenessPredicate);
            statements.addAll(this.fragmentExtractor.createOnLoadedCall(fragment2.getFragmentId()));
            fragment2.setStatements(statements);
            this.fragments.add(fragment2);
            lastInitialFragment = fragment2;
            initialFragmentNumberSequence.add(fragment2.getFragmentId());
            this.initialSequenceCfa = liveAfterSp;
        }
        this.jprogram.setInitialFragmentIdSequence(initialFragmentNumberSequence);
        Collection<Collection<JRunAsync>> groupedNonInitialRunAsyncs = CodeSplitter.groupAsyncsByClassLiteral(Collections2.filter(this.jprogram.getRunAsyncs(), new Predicate<JRunAsync>(){

            @Override
            public boolean apply(JRunAsync jRunAsync) {
                return !CodeSplitter.this.isInitial(jRunAsync);
            }
        }));
        Collection<Fragment> exclusiveFragments = this.partitionStrategy.partitionIntoFragments(this.logger, this.initialSequenceCfa, groupedNonInitialRunAsyncs);
        Fragment leftOverFragment = new Fragment(Fragment.Type.NOT_EXCLUSIVE, lastInitialFragment);
        int firstExclusiveFragmentNumber = nextFragmentIdToAssign;
        for (Fragment fragment2 : exclusiveFragments) {
            fragment2.setFragmentId(nextFragmentIdToAssign++);
            fragment2.addImmediateAncestors(leftOverFragment);
        }
        ExclusivityMap exclusivityMap = this.computeExclusivityMapWithFixups(exclusiveFragments);
        for (Fragment fragment3 : exclusiveFragments) {
            assert (fragment3.isExclusive());
            LivenessPredicate alreadyLoaded3 = exclusivityMap.getLivenessPredicate(ExclusivityMap.NOT_EXCLUSIVE);
            LivenessPredicate liveNow3 = exclusivityMap.getLivenessPredicate(fragment3);
            List<JsStatement> statements2 = this.statementsForFragment(fragment3.getFragmentId(), alreadyLoaded3, liveNow3);
            fragment3.setStatements(statements2);
            fragment3.addStatements(this.fragmentExtractor.createOnLoadedCall(fragment3.getFragmentId()));
        }
        this.fragments.addAll(exclusiveFragments);
        CfaLivenessPredicate cfaLivenessPredicate = new CfaLivenessPredicate(this.initialSequenceCfa);
        LivenessPredicate liveNow4 = exclusivityMap.getLivenessPredicate(ExclusivityMap.NOT_EXCLUSIVE);
        leftOverFragment.setFragmentId(nextFragmentIdToAssign++);
        statements = this.statementsForFragment(leftOverFragment.getFragmentId(), cfaLivenessPredicate, liveNow4);
        statements.addAll(this.fragmentExtractor.createOnLoadedCall(leftOverFragment.getFragmentId()));
        leftOverFragment.setStatements(statements);
        this.fragments.add(leftOverFragment);
        this.jsprogram.setFragmentCount(this.fragments.size());
        boolean bl = false;
        while (var10_17 < this.fragments.size()) {
            JsBlock fragmentBlock = this.jsprogram.getFragmentBlock((int)var10_17);
            fragmentBlock.getStatements().clear();
            fragmentBlock.getStatements().addAll(this.fragments.get((int)var10_17).getStatements());
            ++var10_17;
        }
        this.jprogram.setFragmentPartitioningResult(new FragmentPartitioningResult(this.fragments, this.jprogram.getRunAsyncs().size()));
        this.replaceFragmentId();
    }

    private boolean isInitial(JRunAsync runAsync) {
        return this.initialLoadSequence.contains(runAsync);
    }

    private void replaceFragmentId() {
        final FragmentPartitioningResult result = this.jprogram.getFragmentPartitioningResult();
        new JsModVisitor(){

            @Override
            public void endVisit(JsNumericEntry x, JsContext ctx) {
                if (x.getKey().equals("RunAsyncFragmentIndex")) {
                    int fragmentId = result.getFragmentForRunAsync(x.getValue());
                    x.setValue(fragmentId);
                }
                if (x.getKey().equals("RunAsyncFragmentCount")) {
                    x.setValue(CodeSplitter.this.jsprogram.getFragmentCount() - 1);
                }
            }
        }.accept(this.jsprogram);
    }
}

