/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.jdt.RebindPermutationOracle;
import com.google.gwt.dev.jjs.PrecompilationContext;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.ast.js.JsonArray;
import com.google.gwt.dev.jjs.impl.AutoboxUtils;
import com.google.gwt.dev.jjs.impl.ComputeOverridesAndImplementDefaultMethods;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.JsniRefLookup;
import com.google.gwt.dev.js.ast.JsNestingScope;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.util.JsniRef;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.log.MetricName;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.LinkedListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class UnifyAst {
    private static final String CLASS_DESIRED_ASSERTION_STATUS = "java.lang.Class.desiredAssertionStatus()Z";
    private static final String CLASS_IS_CLASS_METADATA_ENABLED = "java.lang.Class.isClassMetadataEnabled()Z";
    public static final String GWT_CREATE = "com.google.gwt.core.shared.GWT.create(Ljava/lang/Class;)Ljava/lang/Object;";
    public static final String SYSTEM_GET_PROPERTY = "java.lang.System.getProperty(Ljava/lang/String;)Ljava/lang/String;";
    public static final String SYSTEM_GET_PROPERTY_WITH_DEFAULT = "java.lang.System.getProperty(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
    private static final String GWT_DEBUGGER_SHARED = "com.google.gwt.core.shared.GWT.debugger()V";
    private static final String GWT_DEBUGGER_CLIENT = "com.google.gwt.core.client.GWT.debugger()V";
    private static final String GWT_IS_CLIENT = "com.google.gwt.core.shared.GWT.isClient()Z";
    private static final String GWT_IS_PROD_MODE = "com.google.gwt.core.shared.GWT.isProdMode()Z";
    private static final String GWT_IS_SCRIPT = "com.google.gwt.core.shared.GWT.isScript()Z";
    private static final String IMPL_GET_NAME_OF = "com.google.gwt.core.client.impl.Impl.getNameOf(Ljava/lang/String;)Ljava/lang/String;";
    public static final String OLD_GWT_CREATE = "com.google.gwt.core.client.GWT.create(Ljava/lang/Class;)Ljava/lang/Object;";
    private static final String OLD_GWT_IS_CLIENT = "com.google.gwt.core.client.GWT.isClient()Z";
    private static final String OLD_GWT_IS_PROD_MODE = "com.google.gwt.core.client.GWT.isProdMode()Z";
    private static final String OLD_GWT_IS_SCRIPT = "com.google.gwt.core.client.GWT.isScript()Z";
    private static final Set<String> GWT_DEBUGGER_METHOD_CALLS = Sets.newLinkedHashSet(Arrays.asList("com.google.gwt.core.shared.GWT.debugger()V", "com.google.gwt.core.client.GWT.debugger()V"));
    private final Map<String, JBooleanLiteral> replacementValueByMagicMethodQualifiedName;
    private final CompilationState compilationState;
    private final Map<String, CompiledClass> compiledClassesByInternalName;
    private final Map<String, CompiledClass> compiledClassesBySourceName;
    private boolean errorsFound = false;
    private final Set<CompilationUnit> unitsWithErrorsAlreadyReported = Sets.newIdentityHashSet();
    private final Set<JDeclaredType> instantiatedTypes = Sets.newIdentityHashSet();
    private final JsProgram jsProgram;
    private final Set<JNode> liveFieldsAndMethods = Sets.newIdentityHashSet();
    private final Set<String> fullFlowTypes = Sets.newHashSet();
    private final TreeLogger logger;
    private final CompilerContext compilerContext;
    private final Map<String, JMember> resolvedMembersByQualifiedName = Maps.newHashMap();
    private final JProgram program;
    private final RebindPermutationOracle rebindPermutationOracle;
    private final Set<String> reboundTypeNames = Sets.newHashSet();
    private Set<String> staleTypeNames = Sets.newHashSet();
    private Set<String> processedStaleTypeNames = Sets.newHashSet();
    private final Queue<JMethod> methodsPending = Lists.newLinkedList();
    private final Set<String> liveVirtualMethods = Sets.newHashSet();
    private final Multimap<String, JMethod> pendingVirtualMethodsBySignature = LinkedListMultimap.create();
    private NameBasedTypeLocator sourceNameBasedTypeLocator;
    private NameBasedTypeLocator binaryNameBasedTypeLocator;
    private NameBasedTypeLocator internalNameBasedTypeLocator;
    private MinimalRebuildCache minimalRebuildCache;
    private boolean incrementalCompile;
    private final List<String> rootTypeSourceNames = Lists.newArrayList();

    private boolean isMultivaluedProperty(String propertyName) {
        Property property = this.compilerContext.getModule().getProperties().find(propertyName);
        if (!(property instanceof ConfigurationProperty)) {
            return false;
        }
        return ((ConfigurationProperty)property).allowsMultipleValues();
    }

    private boolean isPropertyDefined(String propertyName) {
        return this.compilerContext.getModule().getProperties().find(propertyName) != null;
    }

    public UnifyAst(TreeLogger logger, CompilerContext compilerContext, JProgram program, JsProgram jsProgram, PrecompilationContext precompilationContext) {
        this.incrementalCompile = compilerContext.getOptions().isIncrementalCompileEnabled();
        this.logger = logger;
        this.compilerContext = compilerContext;
        this.program = program;
        this.jsProgram = jsProgram;
        this.rebindPermutationOracle = precompilationContext.getRebindPermutationOracle();
        this.compilationState = this.rebindPermutationOracle.getCompilationState();
        this.compiledClassesByInternalName = this.compilationState.getClassFileMap();
        this.compiledClassesBySourceName = this.compilationState.getClassFileMapBySource();
        this.initializeNameBasedLocators();
        this.minimalRebuildCache = compilerContext.getMinimalRebuildCache();
        if (this.incrementalCompile) {
            this.staleTypeNames = this.minimalRebuildCache.computeAndClearStaleTypesCache(logger, program.typeOracle);
            this.checkPreambleTypesStillFresh(logger);
        }
        this.replacementValueByMagicMethodQualifiedName = ImmutableMap.builder().put(GWT_IS_CLIENT, JBooleanLiteral.TRUE).put(OLD_GWT_IS_CLIENT, JBooleanLiteral.TRUE).put(GWT_IS_PROD_MODE, JBooleanLiteral.TRUE).put(OLD_GWT_IS_PROD_MODE, JBooleanLiteral.TRUE).put(GWT_IS_SCRIPT, JBooleanLiteral.TRUE).put(OLD_GWT_IS_SCRIPT, JBooleanLiteral.TRUE).put(CLASS_DESIRED_ASSERTION_STATUS, JBooleanLiteral.get(compilerContext.getOptions().isEnableAssertions())).put(CLASS_IS_CLASS_METADATA_ENABLED, JBooleanLiteral.get(!compilerContext.getOptions().isClassMetadataDisabled())).build();
    }

    public void addRootTypes(Collection<String> rootTypeSourceNames) {
        assert (this.rootTypeSourceNames.isEmpty());
        this.rootTypeSourceNames.addAll(rootTypeSourceNames);
    }

    public void buildEverything() throws UnableToCompleteException {
        for (String internalName : this.compiledClassesByInternalName.keySet()) {
            String typeName = Name.InternalName.toBinaryName(internalName);
            this.internalFindType(typeName, this.binaryNameBasedTypeLocator, true);
        }
        for (JDeclaredType type : this.program.getDeclaredTypes()) {
            this.fullFlowIntoType(type);
        }
        this.mainLoop();
        this.computeOverrides();
        if (this.errorsFound) {
            throw new UnableToCompleteException();
        }
        JavaAstVerifier.assertProgramIsConsistent(this.program);
    }

    public void exec() throws UnableToCompleteException {
        ArrayList<String> entryMethodNames = Lists.newArrayList();
        for (JMethod jMethod : this.program.getEntryMethods()) {
            this.flowInto(jMethod);
            entryMethodNames.add(jMethod.getJsniSignature(true, true));
        }
        ArrayList<String> rootTypeBinaryNames = Lists.newArrayList();
        for (String string : this.rootTypeSourceNames) {
            JDeclaredType rootType = this.internalFindType(string, this.sourceNameBasedTypeLocator, true);
            if (rootType == null) continue;
            rootTypeBinaryNames.add(rootType.getName());
            if (!rootType.hasJsInteropEntryPoints()) continue;
            this.fullFlowIntoType(rootType);
        }
        this.minimalRebuildCache.setRootTypeNames(rootTypeBinaryNames);
        this.minimalRebuildCache.setEntryMethodNames(entryMethodNames);
        for (JClassType jClassType : this.program.codeGenTypes) {
            this.flowInto(jClassType);
        }
        for (JDeclaredType jDeclaredType : this.program.getRepresentedAsNativeTypes()) {
            this.flowInto(jDeclaredType);
        }
        if (this.incrementalCompile) {
            this.fullFlowIntoRemainingStaleTypes();
        }
        this.instantiate(this.program.getTypeJavaLangString());
        this.flowInto(this.program.getIndexedMethod("Object.toString"));
        this.flowInto((JMethod)this.resolvedMembersByQualifiedName.get("java.lang.String.valueOf(C)Ljava/lang/String;"));
        AutoboxUtils autoboxUtils = new AutoboxUtils(this.program);
        for (JMethod method : autoboxUtils.getBoxMethods()) {
            this.flowInto(method);
        }
        for (JMethod method : autoboxUtils.getUnboxMethods()) {
            this.flowInto(method);
        }
        if (this.compilerContext.getOptions().isRunAsyncEnabled()) {
            this.flowInto(this.program.getIndexedMethod("AsyncFragmentLoader.onLoad"));
            this.flowInto(this.program.getIndexedMethod("AsyncFragmentLoader.runAsync"));
        }
        this.staticInitialize(this.program.getTypeClassLiteralHolder());
        for (JMethod method : this.program.getTypeJavaLangClass().getMethods()) {
            if (!method.isStatic() || !method.getName().startsWith("createFor")) continue;
            this.flowInto(method);
        }
        this.mainLoop();
        if (this.incrementalCompile) {
            int n = this.program.getModuleDeclaredTypes().size();
            MetricName.DECLARED_TYPES_IN_MODULE.setAmount(this.logger, n);
            this.logger.log(TreeLogger.INFO, "Unification traversed " + this.liveFieldsAndMethods.size() + " fields and methods and " + this.program.getDeclaredTypes().size() + " types. " + n + " are considered part of the current module and " + this.fullFlowTypes.size() + " had all of their fields and methods traversed.");
            Set<String> remainingStaleTypeNames = this.computeRemainingStaleTypeNames();
            if (!remainingStaleTypeNames.isEmpty()) {
                this.logger.log(TreeLogger.WARN, "Some stale types (" + remainingStaleTypeNames + ") were not reprocessed as was expected. This is either a compiler bug or a Generator has legitimately stopped creating these types.");
            }
            this.minimalRebuildCache.setProcessedStaleTypeNames(this.fullFlowTypes);
        }
        List<JMethod> list = this.computeOverrides();
        for (JMethod method : list) {
            if (!this.instantiatedTypes.contains(method.getEnclosingType()) || !this.liveVirtualMethods.contains(method.getSignature())) continue;
            this.liveFieldsAndMethods.add(method);
        }
        if (!this.incrementalCompile) {
            this.pruneDeadFieldsAndMethods();
        }
        if (this.errorsFound) {
            throw new UnableToCompleteException();
        }
        JavaAstVerifier.assertProgramIsConsistent(this.program);
    }

    private void fullFlowIntoRemainingStaleTypes() {
        for (String staleTypeName : this.computeRemainingStaleTypeNames()) {
            JDeclaredType staleType = this.internalFindType(staleTypeName, this.binaryNameBasedTypeLocator, false);
            if (staleType == null) continue;
            this.program.removeReferenceOnlyType(staleType);
            this.fullFlowIntoType(staleType);
        }
    }

    private void pruneDeadFieldsAndMethods() {
        assert (!this.incrementalCompile);
        for (JDeclaredType type : this.program.getDeclaredTypes()) {
            for (int fieldIndex = 0; fieldIndex < type.getFields().size(); ++fieldIndex) {
                JField field = type.getFields().get(fieldIndex);
                if (this.liveFieldsAndMethods.contains(field)) continue;
                type.removeField(fieldIndex);
                --fieldIndex;
            }
            JMethod clinit = type.getClinitMethod();
            if (!this.liveFieldsAndMethods.contains(clinit)) {
                clinit.setBody(new JMethodBody(SourceOrigin.UNKNOWN));
            }
            for (int methodIndex = 1; methodIndex < type.getMethods().size(); ++methodIndex) {
                JMethod method = type.getMethods().get(methodIndex);
                Iterables.removeIf(method.getOverriddenMethods(), Predicates.not(Predicates.in(this.liveFieldsAndMethods)));
                Iterables.removeIf(method.getOverridingMethods(), Predicates.not(Predicates.in(this.liveFieldsAndMethods)));
                if (this.liveFieldsAndMethods.contains(method)) continue;
                type.removeMethod(methodIndex);
                --methodIndex;
            }
        }
    }

    private void assimilateSourceUnit(CompilationUnit unit, boolean reportErrors) {
        if (unit.isError()) {
            if (reportErrors && this.unitsWithErrorsAlreadyReported.add(unit)) {
                CompilationProblemReporter.reportErrors(this.logger, unit, false);
                CompilationProblemReporter.logErrorTrace(this.logger, TreeLogger.ERROR, this.compilerContext, unit.getTypeName(), true);
                this.errorsFound = true;
            }
            return;
        }
        if (this.incrementalCompile) {
            this.compilerContext.getMinimalRebuildCache().recordNestedTypeNamesPerType(unit);
        }
        List<JDeclaredType> types = unit.getTypes();
        assert (this.containsAllTypes(unit, types));
        for (JDeclaredType type : types) {
            this.program.addType(type);
            if (!this.incrementalCompile || this.needsNewJs(type)) continue;
            this.program.addReferenceOnlyType(type);
        }
        for (JDeclaredType type : types) {
            this.resolveType(type);
            this.processType(type);
        }
        if (this.incrementalCompile) {
            for (JDeclaredType type : types) {
                if (!this.needsNewJs(type)) continue;
                this.fullFlowIntoType(type);
            }
        }
        for (JDeclaredType type : types) {
            if (this.requiresDevirtualization(type)) {
                this.instantiate(type);
            }
            if (!type.hasJsInteropEntryPoints() && !type.isJsNative() && !type.isJsFunction()) continue;
            this.fullFlowIntoType(type);
        }
    }

    private void checkPreambleTypesStillFresh(TreeLogger logger) {
        Sets.SetView<String> stalePreambleTypes = Sets.intersection(this.staleTypeNames, this.minimalRebuildCache.getPreambleTypeNames());
        if (!stalePreambleTypes.isEmpty()) {
            logger.log(TreeLogger.WARN, "Some preamble types became stale. Recreating them is forcing a full recompile. Stale preamble types: " + stalePreambleTypes + ".");
            this.minimalRebuildCache.clearPerTypeJsCache();
            this.staleTypeNames.clear();
        }
    }

    private List<JMethod> computeOverrides() {
        return new ComputeOverridesAndImplementDefaultMethods().exec(this.program);
    }

    private Set<String> computeRemainingStaleTypeNames() {
        return Sets.newHashSet(Sets.difference(this.staleTypeNames, this.processedStaleTypeNames));
    }

    private boolean containsAllTypes(CompilationUnit unit, List<JDeclaredType> types) {
        HashSet<String> binaryTypeNames = Sets.newHashSet();
        for (JDeclaredType type : types) {
            binaryTypeNames.add(type.getName());
        }
        for (CompiledClass cc : unit.getCompiledClasses()) {
            if (binaryTypeNames.contains(Name.InternalName.toBinaryName(cc.getInternalName()))) continue;
            return false;
        }
        return true;
    }

    private void error(JNode x, String errorMessage) {
        this.error(x.getSourceInfo(), errorMessage);
    }

    private void error(SourceInfo sourceInfo, String errorMessage) {
        this.errorsFound = true;
        TreeLogger branch = this.logger.branch(TreeLogger.ERROR, "Errors in '" + sourceInfo.getFileName() + "'", null);
        StringBuilder msgBuf = new StringBuilder();
        int line = sourceInfo.getStartLine();
        if (line > 0) {
            msgBuf.append("Line ");
            msgBuf.append(line);
            msgBuf.append(": ");
        }
        msgBuf.append(errorMessage);
        branch.log(TreeLogger.ERROR, msgBuf.toString());
    }

    private void fullFlowIntoType(JDeclaredType type) {
        String typeName = type.getName();
        if (this.fullFlowTypes.contains(typeName) || typeName.endsWith("package-info")) {
            return;
        }
        this.minimalRebuildCache.clearRebinderTypeAssociations(typeName);
        this.fullFlowTypes.add(typeName);
        this.processedStaleTypeNames.add(typeName);
        this.instantiate(type);
        this.flowInto(type);
    }

    private void flowInto(JDeclaredType type) {
        for (JMethod method : type.getMethods()) {
            this.flowInto(method);
        }
        for (JField field : type.getFields()) {
            this.flowInto(field);
        }
    }

    private void flowInto(JField field) {
        if (field.isExternal()) {
            assert (this.errorsFound);
            return;
        }
        if (field == JField.NULL_FIELD) {
            return;
        }
        if (this.liveFieldsAndMethods.contains(field)) {
            return;
        }
        this.liveFieldsAndMethods.add(field);
        field.setType(this.translate(field.getType()));
        if (field.isStatic()) {
            this.staticInitialize(field.getEnclosingType());
        }
    }

    private void flowInto(JMethod method) {
        String signature;
        if (method.isExternal()) {
            assert (this.errorsFound);
            return;
        }
        if (method == JMethod.NULL_METHOD) {
            return;
        }
        if (this.liveFieldsAndMethods.contains(method)) {
            return;
        }
        this.liveFieldsAndMethods.add(method);
        method.resolve(this.translate(method.getOriginalReturnType()), this.translate(method.getOriginalParamTypes()), this.translate(method.getType()), this.translate(method.getThrownExceptions()));
        if (method.isStatic()) {
            this.staticInitialize(method.getEnclosingType());
        } else if (method.canBePolymorphic() && !this.liveVirtualMethods.contains(signature = method.getSignature())) {
            this.liveVirtualMethods.add(signature);
            for (JMethod pendingMethod : this.pendingVirtualMethodsBySignature.removeAll(signature)) {
                assert (this.instantiatedTypes.contains(pendingMethod.getEnclosingType()));
                this.flowInto(pendingMethod);
            }
        }
        this.resolveSpecialization(method);
        this.methodsPending.add(method);
    }

    private void resolveSpecialization(JMethod method) {
        if (method.getSpecialization() == null) {
            return;
        }
        JMethod.Specialization specialization = method.getSpecialization();
        if (specialization.getParams() == null) {
            this.logger.log(TreeLogger.Type.ERROR, "Missing 'params' attribute at @SpecializeMethod for method " + method.getQualifiedName());
            this.errorsFound = true;
            return;
        }
        List<JType> resolvedParams = this.translate(specialization.getParams());
        JType resolvedReturn = this.translate(specialization.getReturns());
        String targetMethodSignature = JjsUtils.computeSignature(specialization.getTarget(), resolvedParams, resolvedReturn, false);
        JMethod targetMethod = JMethod.getExternalizedMethod(method.getEnclosingType().getName(), targetMethodSignature, false);
        JMethod resolvedTargetMethod = this.translate(method.getSourceInfo(), targetMethod);
        if (resolvedTargetMethod.isExternal()) {
            this.error(method.getSourceInfo(), "Unable to locate @SpecializeMethod target " + targetMethodSignature + " for method " + method.getQualifiedName());
            return;
        }
        this.flowInto(resolvedTargetMethod);
        specialization.resolve(resolvedParams, resolvedReturn, resolvedTargetMethod);
    }

    public NameBasedTypeLocator getSourceNameBasedTypeLocator() {
        return this.sourceNameBasedTypeLocator;
    }

    private void initializeNameBasedLocators() {
        this.sourceNameBasedTypeLocator = new NameBasedTypeLocator(this.compiledClassesBySourceName){

            @Override
            protected boolean hasCompileErrors(String sourceName) {
                return UnifyAst.this.compilerContext.getCompilationErrorsIndex().hasCompileErrors(sourceName);
            }

            @Override
            protected void logErrorTrace(TreeLogger branch, TreeLogger.Type logLevel, String sourceName) {
                CompilationProblemReporter.logErrorTrace(branch, logLevel, UnifyAst.this.compilerContext, sourceName, false);
            }
        };
        this.binaryNameBasedTypeLocator = new NameBasedTypeLocator(null){

            @Override
            protected CompilationUnit getCompilationUnitFromSource(String binaryName) {
                return UnifyAst.this.internalNameBasedTypeLocator.getCompilationUnitFromSource(Name.BinaryName.toInternalName(binaryName));
            }

            @Override
            protected boolean sourceCompilationUnitIsAvailable(String binaryName) {
                return UnifyAst.this.internalNameBasedTypeLocator.sourceCompilationUnitIsAvailable(Name.BinaryName.toInternalName(binaryName));
            }

            @Override
            protected boolean hasCompileErrors(String binaryName) {
                return UnifyAst.this.sourceNameBasedTypeLocator.hasCompileErrors(Name.BinaryName.toSourceName(binaryName));
            }

            @Override
            protected void logErrorTrace(TreeLogger branch, TreeLogger.Type logLevel, String binaryName) {
                UnifyAst.this.sourceNameBasedTypeLocator.logErrorTrace(branch, logLevel, Name.BinaryName.toSourceName(binaryName));
            }
        };
        this.internalNameBasedTypeLocator = new NameBasedTypeLocator(this.compiledClassesByInternalName){

            @Override
            protected JDeclaredType getResolvedType(String internalName) {
                return UnifyAst.this.binaryNameBasedTypeLocator.getResolvedType(Name.InternalName.toBinaryName(internalName));
            }

            @Override
            protected boolean resolvedTypeIsAvailable(String internalName) {
                return UnifyAst.this.binaryNameBasedTypeLocator.resolvedTypeIsAvailable(Name.InternalName.toBinaryName(internalName));
            }

            @Override
            protected boolean hasCompileErrors(String internalName) {
                return UnifyAst.this.sourceNameBasedTypeLocator.hasCompileErrors(Name.InternalName.toSourceName(internalName));
            }

            @Override
            protected void logErrorTrace(TreeLogger branch, TreeLogger.Type logLevel, String internalName) {
                UnifyAst.this.sourceNameBasedTypeLocator.logErrorTrace(branch, logLevel, Name.BinaryName.toSourceName(internalName));
            }
        };
    }

    private void instantiate(JDeclaredType type) {
        if (this.program.isReferenceOnly(type) && !this.requiresDevirtualization(type)) {
            return;
        }
        if (type.isExternal()) {
            assert (this.errorsFound);
            return;
        }
        if (this.instantiatedTypes.contains(type)) {
            return;
        }
        this.instantiatedTypes.add(type);
        if (type.getSuperClass() != null) {
            this.instantiate(this.translate((JDeclaredType)type.getSuperClass()));
        }
        for (JInterfaceType intf : type.getImplements()) {
            this.instantiate(this.translate((JDeclaredType)intf));
        }
        this.staticInitialize(type);
        for (JMethod method : type.getMethods()) {
            if (method.canBeReferencedExternally()) {
                this.flowInto(method);
                continue;
            }
            if (!method.canBePolymorphic()) continue;
            String signature = method.getSignature();
            if (this.liveVirtualMethods.contains(signature)) {
                assert (!this.pendingVirtualMethodsBySignature.containsKey(signature));
                this.flowInto(method);
                continue;
            }
            this.pendingVirtualMethodsBySignature.put(signature, method);
        }
        for (JField field : type.getFields()) {
            if (!field.canBeReferencedExternally()) continue;
            this.flowInto(field);
        }
    }

    private boolean requiresDevirtualization(JDeclaredType type) {
        return this.isJso(type) || type.isJsNative() || JProgram.isRepresentedAsNative(type.getName());
    }

    private boolean isJso(JDeclaredType type) {
        if (type == null) {
            return false;
        }
        return type == this.program.getJavaScriptObject() || this.isJso(type.getSuperClass());
    }

    private void mainLoop() {
        UnifyVisitor visitor = new UnifyVisitor();
        while (!this.methodsPending.isEmpty()) {
            visitor.accept(this.methodsPending.poll());
        }
    }

    private void processType(JDeclaredType type) {
        assert (!type.isExternal());
        for (JMember member : type.getMembers()) {
            String qualifiedName = member.getQualifiedName();
            this.resolvedMembersByQualifiedName.put(qualifiedName, member);
            this.replaceMagicMethodBodies(member);
        }
    }

    private void replaceMagicMethodBodies(JMember member) {
        JExpression replacementExpression = this.replacementValueByMagicMethodQualifiedName.get(member.getQualifiedName());
        if (replacementExpression == null) {
            return;
        }
        JjsUtils.replaceMethodBody((JMethod)member, replacementExpression);
    }

    private boolean needsNewJs(JDeclaredType type) {
        String typeName = type.getName();
        boolean hasOwnJs = this.minimalRebuildCache.hasJs(typeName);
        boolean isPartOfPreamble = this.minimalRebuildCache.getPreambleTypeNames().contains(typeName);
        return !hasOwnJs && !isPartOfPreamble;
    }

    private void resolveType(JDeclaredType type) {
        assert (!type.isExternal());
        if (type.getEnclosingType() != null) {
            type.setEnclosingType(this.translate(type.getEnclosingType()));
        }
        if (type instanceof JClassType && type.getSuperClass() != null) {
            ((JClassType)type).setSuperClass(this.translate((JDeclaredType)type.getSuperClass()));
        }
        ArrayList<JInterfaceType> resolvedInterfaces = Lists.newArrayList();
        for (JInterfaceType intf : type.getImplements()) {
            resolvedInterfaces.add(this.translate((JDeclaredType)intf));
        }
        type.resolve(resolvedInterfaces, this.findPackageInfo(type));
    }

    private JDeclaredType findPackageInfo(JDeclaredType type) {
        String packagePrefix = type.getName();
        packagePrefix = packagePrefix.substring(0, packagePrefix.lastIndexOf(46) + 1);
        String pkgInfoClassName = StringInterner.get().intern(packagePrefix + "package-info");
        JDeclaredType pkgInfo = this.internalFindType(pkgInfoClassName, this.binaryNameBasedTypeLocator, false);
        if (pkgInfo != null) {
            this.program.addReferenceOnlyType(pkgInfo);
        }
        return pkgInfo;
    }

    public JDeclaredType findType(String typeName, NameBasedTypeLocator nameBasedTypeLocator) throws UnableToCompleteException {
        JDeclaredType type = this.internalFindType(typeName, nameBasedTypeLocator, true);
        if (this.errorsFound) {
            throw new UnableToCompleteException();
        }
        return type;
    }

    private JDeclaredType internalFindType(String typeName, NameBasedTypeLocator nameBasedTypeLocator, boolean reportErrors) {
        if (nameBasedTypeLocator.resolvedTypeIsAvailable(typeName)) {
            return nameBasedTypeLocator.getResolvedType(typeName);
        }
        if (nameBasedTypeLocator.sourceCompilationUnitIsAvailable(typeName)) {
            this.assimilateSourceUnit(nameBasedTypeLocator.getCompilationUnitFromSource(typeName), reportErrors);
            return nameBasedTypeLocator.getResolvedType(typeName);
        }
        if (reportErrors) {
            if (nameBasedTypeLocator.hasCompileErrors(typeName)) {
                TreeLogger branch = this.logger.branch(TreeLogger.ERROR, String.format("Type %s could not be referenced because it previously failed to compile with errors:", typeName));
                nameBasedTypeLocator.logErrorTrace(branch, TreeLogger.ERROR, typeName);
            } else {
                this.logger.log(TreeLogger.ERROR, String.format("Could not find %s in types compiled from source. Is the source glob too strict?", typeName));
            }
            this.errorsFound = true;
        }
        return null;
    }

    private void staticInitialize(JDeclaredType type) {
        if (type.isExternal()) {
            assert (this.errorsFound);
            return;
        }
        JMethod clinit = type.getClinitMethod();
        if (!this.liveFieldsAndMethods.contains(clinit)) {
            this.flowInto(clinit);
            if (type.getSuperClass() != null) {
                this.staticInitialize(this.translate((JDeclaredType)type.getSuperClass()));
            }
        }
    }

    private <T extends JDeclaredType> T translate(T type) {
        if (!type.isExternal()) {
            return type;
        }
        JDeclaredType resolvedType = this.internalFindType(type.getName(), this.binaryNameBasedTypeLocator, true);
        if (resolvedType == null) {
            assert (this.errorsFound);
            return type;
        }
        assert (!resolvedType.isExternal());
        return (T)resolvedType;
    }

    private <T extends JMember> T translate(SourceInfo sourceInfo, T member) {
        if (!member.isExternal()) {
            return member;
        }
        JDeclaredType enclosingType = this.translate(member.getEnclosingType());
        if (enclosingType.isExternal()) {
            assert (this.errorsFound);
            return member;
        }
        String qualifiedName = member.getQualifiedName();
        JMember resolvedMember = this.resolvedMembersByQualifiedName.get(qualifiedName);
        if (resolvedMember == null) {
            this.error(sourceInfo, "Reference to '" + qualifiedName + "' could not be resolved");
            return member;
        }
        assert (!resolvedMember.isExternal());
        return (T)resolvedMember;
    }

    private JReferenceType translate(JReferenceType type) {
        JReferenceType result = type.getUnderlyingType();
        if (type instanceof JArrayType) {
            JArrayType arrayType = (JArrayType)type;
            result = this.program.getTypeArray(this.translate(arrayType.getElementType()));
        } else if (type.isExternal()) {
            assert (type instanceof JDeclaredType) : "Unknown external type " + type.getName();
            result = this.translate((JDeclaredType)type);
        }
        assert (!result.isExternal());
        if (!type.canBeNull()) {
            result = result.strengthenToNonNull();
        }
        return result;
    }

    private JType translate(JType type) {
        if (type.isPrimitiveType()) {
            return type;
        }
        return this.translate((JReferenceType)type);
    }

    private <T extends JType> List<T> translate(List<T> types) {
        ArrayList<JType> translatedTypes = Lists.newArrayListWithCapacity(types.size());
        for (JType type : types) {
            translatedTypes.add(this.translate(type));
        }
        return translatedTypes;
    }

    private class UnifyVisitor
    extends JModVisitor {
        private JMethod currentMethod;

        private UnifyVisitor() {
        }

        @Override
        public void endVisit(JArrayType x, Context ctx) {
            assert (false) : "Should not get here";
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            x.setType(UnifyAst.this.translate(x.getType().getUnderlyingType()));
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            x.resolve(UnifyAst.this.translate(x.getCastType()));
        }

        @Override
        public void endVisit(JClassLiteral x, Context ctx) {
            JEnumType enumType;
            JType refType = UnifyAst.this.translate(x.getRefType());
            x.resolve(refType);
            if (refType instanceof JArrayType) {
                refType = ((JArrayType)refType).getLeafType();
            }
            if ((enumType = refType.isEnumOrSubclass()) == null) {
                return;
            }
            for (JMethod method : enumType.getMethods()) {
                if (!method.isStatic() || !method.getSignature().startsWith("values()") && !method.getSignature().startsWith("valueOf(Ljava/lang/String;)")) continue;
                UnifyAst.this.flowInto(method);
            }
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            assert (false) : "Should not get here";
        }

        @Override
        public void endVisit(JConditional x, Context ctx) {
            x.setType(UnifyAst.this.translate(x.getType()));
        }

        @Override
        public void endVisit(JConstructor x, Context ctx) {
            super.endVisit(x, ctx);
            UnifyAst.this.instantiate(x.getEnclosingType());
        }

        @Override
        public void endVisit(JDeclaredType x, Context ctx) {
            assert (false) : "Should not get here";
        }

        @Override
        public void endVisit(JExpression x, Context ctx) {
            assert (!x.getType().isExternal() || UnifyAst.this.errorsFound);
        }

        @Override
        public void endVisit(JField x, Context ctx) {
            assert (false) : "Should not get here";
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            JField field = (JField)UnifyAst.this.translate(x.getSourceInfo(), x.getField());
            UnifyAst.this.flowInto(field);
            x.resolve(field);
            assert (x.getType() == x.getField().getType());
            assert (!x.getEnclosingType().isExternal());
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            x.resolve(UnifyAst.this.translate(x.getTestType()));
        }

        @Override
        public void endVisit(JInterfaceType x, Context ctx) {
            assert (false) : "Should not get here";
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod target = x.getTarget();
            if (target.isExternal()) {
                assert (UnifyAst.this.errorsFound);
                return;
            }
            assert (x instanceof JNewInstance || x.getType() == target.getType());
            UnifyAst.this.flowInto(target);
        }

        @Override
        public void endVisit(JNameOf x, Context ctx) {
            HasName node = x.getNode();
            if (node instanceof JType) {
                node = UnifyAst.this.translate((JType)node);
            } else if (node instanceof JMember) {
                node = UnifyAst.this.translate(x.getSourceInfo(), (JMember)node);
            } else assert (false) : "Should not get here";
            x.resolve(node, (JClassType)UnifyAst.this.translate(x.getType().getUnderlyingType()));
        }

        @Override
        public void endVisit(JNewArray x, Context ctx) {
            x.setType((JArrayType)UnifyAst.this.translate(x.getArrayType()));
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
            JConstructor target = x.getTarget();
            if (target.isExternal()) {
                assert (UnifyAst.this.errorsFound);
                return;
            }
            UnifyAst.this.flowInto(target);
        }

        @Override
        public void endVisit(JsniFieldRef x, Context ctx) {
            this.endVisit((JFieldRef)x, ctx);
        }

        @Override
        public void endVisit(JsniMethodBody x, Context ctx) {
            JsNestingScope funcScope = (JsNestingScope)x.getFunc().getScope();
            assert (funcScope.getParent() == JsRootScope.INSTANCE);
            funcScope.nestInto(UnifyAst.this.jsProgram.getScope());
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            JMethod target = (JMethod)UnifyAst.this.translate(x.getSourceInfo(), x.getTarget());
            x.resolve(target, UnifyAst.this.program.getJavaScriptObject());
            UnifyAst.this.flowInto(target);
        }

        @Override
        public void endVisit(JsonArray x, Context ctx) {
            x.resolve(UnifyAst.this.translate(x.getType()));
        }

        @Override
        public void endVisit(JStringLiteral x, Context ctx) {
            JClassType stringType = UnifyAst.this.program.getTypeJavaLangString();
            x.resolve(stringType);
            UnifyAst.this.instantiate(stringType);
        }

        @Override
        public void endVisit(JSwitchExpression x, Context ctx) {
            x.setType(UnifyAst.this.translate(x.getType()));
        }

        @Override
        public void endVisit(JThisRef x, Context ctx) {
            assert (!x.getType().isExternal());
        }

        @Override
        public void endVisit(JTryStatement x, Context ctx) {
            for (JTryStatement.CatchClause clause : x.getCatchClauses()) {
                List<JType> types = clause.getTypes();
                for (int i = 0; i < types.size(); ++i) {
                    JReferenceType resolvedType = UnifyAst.this.translate((JReferenceType)types.get(i));
                    assert (resolvedType.replaces(types.get(i)));
                    types.set(i, resolvedType);
                }
            }
        }

        @Override
        public void endVisit(JUnsafeTypeCoercion x, Context ctx) {
            x.resolve(UnifyAst.this.translate(x.getCoercionType()));
        }

        @Override
        public void endVisit(JVariable x, Context ctx) {
            x.setType(UnifyAst.this.translate(x.getType()));
        }

        @Override
        public boolean visit(JExpressionStatement x, Context ctx) {
            if (x.getExpr() instanceof JMethodCall) {
                JMethodCall call = (JMethodCall)x.getExpr();
                JMethod target = call.getTarget();
                if (GWT_DEBUGGER_METHOD_CALLS.contains(target.getQualifiedName())) {
                    ctx.replaceMe(new JDebuggerStatement(x.getSourceInfo()));
                }
            }
            return true;
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            return !UnifyAst.this.program.isReferenceOnly(x.getEnclosingType()) || x == x.getEnclosingType().getClinitMethod();
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            JMethod target = (JMethod)UnifyAst.this.translate(x.getSourceInfo(), x.getTarget());
            x.resolve(target);
            JExpression replacement = this.maybeHandleMagicMethodCall(x);
            if (replacement != null) {
                ctx.replaceMe(this.accept(replacement));
                return false;
            }
            return true;
        }

        private JExpression maybeHandleMagicMethodCall(JMethodCall methodCall) {
            JExpression result;
            switch (methodCall.getTarget().getQualifiedName()) {
                case "com.google.gwt.core.shared.GWT.create(Ljava/lang/Class;)Ljava/lang/Object;": 
                case "com.google.gwt.core.client.GWT.create(Ljava/lang/Class;)Ljava/lang/Object;": {
                    result = this.createRebindExpression(methodCall);
                    break;
                }
                case "com.google.gwt.core.client.impl.Impl.getNameOf(Ljava/lang/String;)Ljava/lang/String;": {
                    result = this.handleImplNameOf(methodCall);
                    break;
                }
                case "java.lang.System.getProperty(Ljava/lang/String;)Ljava/lang/String;": 
                case "java.lang.System.getProperty(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;": {
                    result = this.handleSystemGetProperty(methodCall);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (result == null) {
                return JNullLiteral.INSTANCE;
            }
            return result;
        }

        private JExpression handleSystemGetProperty(JMethodCall gwtGetPropertyCall) {
            JExpression defaultValueExpression;
            assert (gwtGetPropertyCall.getArgs().size() == 1 || gwtGetPropertyCall.getArgs().size() == 2);
            JExpression propertyNameExpression = gwtGetPropertyCall.getArgs().get(0);
            boolean defaultVersionCalled = gwtGetPropertyCall.getArgs().size() == 2;
            JExpression jExpression = defaultValueExpression = defaultVersionCalled ? gwtGetPropertyCall.getArgs().get(1) : null;
            if (!(propertyNameExpression instanceof JStringLiteral)) {
                UnifyAst.this.error(gwtGetPropertyCall, "Only string constants may be used as property name in System.getProperty()");
                return null;
            }
            String propertyName = ((JStringLiteral)propertyNameExpression).getValue();
            if (!defaultVersionCalled && !UnifyAst.this.isPropertyDefined(propertyName)) {
                UnifyAst.this.error(gwtGetPropertyCall, "Property '" + propertyName + "' is not defined.");
                return null;
            }
            if (UnifyAst.this.isMultivaluedProperty(propertyName)) {
                UnifyAst.this.error(gwtGetPropertyCall, "Property '" + propertyName + "' is multivalued. Multivalued properties are not supported by System.getProperty().");
                return null;
            }
            if (defaultValueExpression != null) {
                defaultValueExpression = this.accept(defaultValueExpression);
            }
            return JPermutationDependentValue.createRuntimeProperty(UnifyAst.this.program, gwtGetPropertyCall.getSourceInfo(), propertyName, defaultValueExpression);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JExpression createRebindExpression(JMethodCall gwtCreateCall) {
            assert (gwtCreateCall.getArgs().size() == 1);
            JExpression arg = gwtCreateCall.getArgs().get(0);
            if (!(arg instanceof JClassLiteral)) {
                UnifyAst.this.error(gwtCreateCall, "Only class literals may be used as arguments to GWT.create()");
                return null;
            }
            JClassLiteral classLiteral = (JClassLiteral)arg;
            if (!(classLiteral.getRefType() instanceof JDeclaredType)) {
                UnifyAst.this.error(gwtCreateCall, "Only classes and interfaces may be used as arguments to GWT.create()");
                return null;
            }
            SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.VISIT_GWT_CREATE, "argument", classLiteral.getRefType().getName(), "caller", gwtCreateCall.getSourceInfo().getFileName());
            try {
                JExpression jExpression = this.createStaticRebindExpression(gwtCreateCall, classLiteral);
                return jExpression;
            }
            finally {
                event.end(new String[0]);
            }
        }

        private JExpression createStaticRebindExpression(JMethodCall gwtCreateCall, JClassLiteral classLiteral) {
            ArrayList<String> answers;
            JDeclaredType type = (JDeclaredType)classLiteral.getRefType();
            String reboundTypeName = type.getName();
            if (UnifyAst.this.incrementalCompile) {
                if (UnifyAst.this.reboundTypeNames.add(reboundTypeName)) {
                    UnifyAst.this.minimalRebuildCache.clearReboundTypeAssociations(reboundTypeName);
                }
                UnifyAst.this.minimalRebuildCache.recordRebinderTypeForReboundType(reboundTypeName, this.currentMethod.getEnclosingType().getName());
                UnifyAst.this.rebindPermutationOracle.getGeneratorContext().setCurrentRebindBinaryTypeName(reboundTypeName);
            }
            String requestedType = Name.BinaryName.toSourceName(reboundTypeName);
            try {
                answers = Lists.newArrayList(UnifyAst.this.rebindPermutationOracle.getAllPossibleRebindAnswers(UnifyAst.this.logger, requestedType));
                if (UnifyAst.this.incrementalCompile) {
                    ArtifactSet artifacts = UnifyAst.this.rebindPermutationOracle.getGeneratorContext().getArtifacts();
                    UnifyAst.this.minimalRebuildCache.addGeneratedArtifacts(artifacts);
                }
                UnifyAst.this.rebindPermutationOracle.getGeneratorContext().finish(UnifyAst.this.logger);
                if (UnifyAst.this.incrementalCompile) {
                    UnifyAst.this.staleTypeNames = UnifyAst.this.minimalRebuildCache.computeAndClearStaleTypesCache(UnifyAst.this.logger, ((UnifyAst)UnifyAst.this).program.typeOracle);
                    UnifyAst.this.checkPreambleTypesStillFresh(UnifyAst.this.logger);
                    UnifyAst.this.fullFlowIntoRemainingStaleTypes();
                }
            }
            catch (UnableToCompleteException e) {
                UnifyAst.this.error(gwtCreateCall, "Failed to resolve '" + requestedType + "' via deferred binding");
                return null;
            }
            ArrayList<JExpression> instantiationExpressions = Lists.newArrayListWithCapacity(answers.size());
            for (String answer : answers) {
                JDeclaredType answerType = UnifyAst.this.internalFindType(answer, UnifyAst.this.sourceNameBasedTypeLocator, true);
                if (answerType == null) {
                    UnifyAst.this.error(gwtCreateCall, "Rebind result '" + answer + "' could not be found");
                    return null;
                }
                if (!(answerType instanceof JClassType)) {
                    UnifyAst.this.error(gwtCreateCall, "Rebind result '" + answer + "' must be a class");
                    return null;
                }
                if (answerType.isAbstract()) {
                    UnifyAst.this.error(gwtCreateCall, "Rebind result '" + answer + "' cannot be abstract");
                    return null;
                }
                if (UnifyAst.this.isJso(answerType)) {
                    UnifyAst.this.error(gwtCreateCall, "Rebind result '" + answer + "' cannot be a JSO");
                    return null;
                }
                JExpression result = JjsUtils.createDefaultConstructorInstantiation(gwtCreateCall.getSourceInfo(), (JClassType)answerType);
                if (result == null) {
                    UnifyAst.this.error(gwtCreateCall, "Rebind result '" + answer + "' has no default (zero argument) constructors");
                    return null;
                }
                instantiationExpressions.add(result);
            }
            assert (answers.size() == instantiationExpressions.size());
            if (answers.size() == 1) {
                return (JExpression)instantiationExpressions.get(0);
            }
            return JPermutationDependentValue.createTypeRebind(UnifyAst.this.program, gwtCreateCall.getSourceInfo(), requestedType, answers, instantiationExpressions);
        }

        private JExpression handleImplNameOf(final JMethodCall x) {
            assert (x.getArgs().size() == 1);
            JExpression arg = x.getArgs().get(0);
            if (!(arg instanceof JStringLiteral)) {
                UnifyAst.this.error(x, "Only string literals may be used as arguments to Impl.getNameOf()");
                return null;
            }
            JStringLiteral stringLiteral = (JStringLiteral)arg;
            String stringValue = stringLiteral.getValue();
            JNode node = null;
            JsniRef ref = JsniRef.parse(stringValue);
            if (ref != null) {
                node = JsniRefLookup.findJsniRefTarget(ref, UnifyAst.this.program, new JsniRefLookup.ErrorReporter(){

                    @Override
                    public void reportError(String errMsg) {
                        UnifyAst.this.error(x, errMsg);
                    }
                });
            }
            if (node == null) {
                return null;
            }
            if (node instanceof JMethod) {
                UnifyAst.this.flowInto((JMethod)node);
                UnifyAst.this.program.addPinnedMethod((JMethod)node);
            }
            return new JNameOf(x.getSourceInfo(), UnifyAst.this.program.getTypeJavaLangString(), (HasName)((Object)node));
        }
    }

    private abstract class NameBasedTypeLocator {
        private final Map<String, CompiledClass> compiledClassesByTypeName;

        private NameBasedTypeLocator(Map<String, CompiledClass> compiledClassesByTypeName) {
            this.compiledClassesByTypeName = compiledClassesByTypeName;
        }

        protected abstract boolean hasCompileErrors(String var1);

        protected abstract void logErrorTrace(TreeLogger var1, TreeLogger.Type var2, String var3);

        protected CompilationUnit getCompilationUnitFromSource(String typeName) {
            return this.compiledClassesByTypeName.get(typeName).getUnit();
        }

        protected JDeclaredType getResolvedType(String typeName) {
            JDeclaredType resolvedType = UnifyAst.this.program.getFromTypeMap(typeName);
            return resolvedType;
        }

        protected boolean resolvedTypeIsAvailable(String typeName) {
            return UnifyAst.this.program.getFromTypeMap(typeName) != null;
        }

        protected boolean sourceCompilationUnitIsAvailable(String typeName) {
            return this.compiledClassesByTypeName.containsKey(typeName);
        }
    }
}

