/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.CanBeAbstract;
import com.google.gwt.dev.jjs.ast.CanBeStatic;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.ComputePotentiallyObservableUninitializedValues;
import com.google.gwt.dev.jjs.impl.FullOptimizerContext;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.Pruner;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TypeTightener {
    private static final String NAME = TypeTightener.class.getSimpleName();
    private final Map<JVariable, Collection<JExpression>> assignments = Maps.newIdentityHashMap();
    private final Map<JReferenceType, Collection<JClassType>> implementors = Maps.newIdentityHashMap();
    private final Map<JParameter, Collection<JParameter>> paramUpRefs = Maps.newIdentityHashMap();
    private final Map<JMethod, Collection<JExpression>> returns = Maps.newIdentityHashMap();
    private final Multimap<JMethod, JMethod> calledMethodsByMethodCallArg = HashMultimap.create();
    private final Multimap<JField, JMethod> calledMethodsByFieldRefArg = HashMultimap.create();
    private final JProgram program;

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new TypeTightener(program).execImpl(optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    @VisibleForTesting
    static OptimizerStats exec(JProgram program) {
        return TypeTightener.exec(program, new FullOptimizerContext(program));
    }

    private static <T, V> void add(T key, V value, Map<T, Collection<V>> map) {
        Collection<V> list = map.get(key);
        if (list == null) {
            list = Sets.newLinkedHashSet();
            map.put(key, list);
        }
        list.add(value);
    }

    private static <T extends CanBeAbstract> T getSingleConcrete(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        Iterator concreteIterator = FluentIterable.from(collection).filter(new Predicate<T>(){

            @Override
            public boolean apply(T element) {
                return !element.isAbstract();
            }
        }).iterator();
        if (!concreteIterator.hasNext()) {
            return null;
        }
        CanBeAbstract firstConcrete = (CanBeAbstract)concreteIterator.next();
        if (concreteIterator.hasNext()) {
            return null;
        }
        return (T)firstConcrete;
    }

    private TypeTightener(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        TightenTypesVisitor tightener;
        OptimizerStats stats = new OptimizerStats(NAME);
        RecordVisitor recorder = new RecordVisitor();
        recorder.record(this.program);
        int lastStep = optimizerCtx.getLastStepFor(NAME);
        optimizerCtx.setLastStepFor(NAME, optimizerCtx.getOptimizationStep());
        do {
            tightener = new TightenTypesVisitor(optimizerCtx);
            Set<JMethod> affectedMethods = this.computeAffectedMethods(optimizerCtx, lastStep);
            Set<JField> affectedFields = this.computeAffectedFields(optimizerCtx, lastStep);
            optimizerCtx.traverse(tightener, affectedFields);
            optimizerCtx.traverse(tightener, affectedMethods);
            stats.recordModified(tightener.getNumMods());
            lastStep = optimizerCtx.getOptimizationStep();
            optimizerCtx.incOptimizationStep();
        } while (tightener.didChange());
        if (stats.didChange()) {
            FixDanglingRefsVisitor fixer = new FixDanglingRefsVisitor(optimizerCtx);
            fixer.accept(this.program);
            optimizerCtx.incOptimizationStep();
            JavaAstVerifier.assertProgramIsConsistent(this.program);
        }
        return stats;
    }

    private Set<JMethod> computeAffectedMethods(OptimizerContext optimizerCtx, int lastStep) {
        Set<JMethod> modifiedMethods = optimizerCtx.getModifiedMethodsSince(lastStep);
        Set<JField> modifiedFields = optimizerCtx.getModifiedFieldsSince(lastStep);
        LinkedHashSet<JMethod> affectedMethods = Sets.newLinkedHashSet();
        affectedMethods.addAll(optimizerCtx.getCallers(modifiedMethods));
        affectedMethods.addAll(optimizerCtx.getCallees(modifiedMethods));
        affectedMethods.addAll(optimizerCtx.getRemovedCalleeMethodsSince(lastStep));
        for (JMethod method : modifiedMethods) {
            affectedMethods.addAll(this.calledMethodsByMethodCallArg.get(method));
        }
        for (JMethod method : modifiedMethods) {
            affectedMethods.addAll(method.getOverriddenMethods());
            affectedMethods.addAll(method.getOverridingMethods());
        }
        affectedMethods.addAll(optimizerCtx.getMethodsByReferencedFields(modifiedFields));
        for (JField field : modifiedFields) {
            affectedMethods.addAll(this.calledMethodsByFieldRefArg.get(field));
        }
        affectedMethods.addAll(modifiedMethods);
        return affectedMethods;
    }

    private Set<JField> computeAffectedFields(OptimizerContext optimizerCtx, int lastStep) {
        Set<JMethod> modifiedMethods = optimizerCtx.getModifiedMethodsSince(lastStep);
        Set<JField> modifiedFields = optimizerCtx.getModifiedFieldsSince(lastStep);
        LinkedHashSet<JField> affectedFields = Sets.newLinkedHashSet();
        affectedFields.addAll(modifiedFields);
        affectedFields.addAll(optimizerCtx.getReferencedFieldsByMethods(modifiedMethods));
        return affectedFields;
    }

    private boolean isNullReference(CanBeStatic member, JExpression instance) {
        return !member.isStatic() && instance.getType().isNullType();
    }

    private JReferenceType strongerType(JReferenceType type, JReferenceType ... assignedTypes) {
        return this.strongerType(type, Arrays.asList(assignedTypes));
    }

    private JReferenceType strongerType(JReferenceType type, Iterable<JReferenceType> assignedTypes) {
        return this.program.strengthenType(type, this.program.generalizeTypes(assignedTypes));
    }

    public class TightenTypesVisitor
    extends JChangeTrackingVisitor {
        public TightenTypesVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            JReferenceType fromType;
            JType argumentType = x.getExpr().getType();
            if (!(x.getCastType() instanceof JReferenceType) || !(argumentType instanceof JReferenceType)) {
                return;
            }
            JReferenceType toType = this.getSingleConcreteType(x.getCastType());
            if (toType == null) {
                toType = (JReferenceType)x.getCastType();
            }
            if ((fromType = this.getSingleConcreteType(argumentType)) == null) {
                fromType = (JReferenceType)argumentType;
            }
            if (((TypeTightener)TypeTightener.this).program.typeOracle.castSucceedsTrivially(fromType, toType)) {
                ctx.replaceMe(x.getExpr());
                return;
            }
            if ((!((TypeTightener)TypeTightener.this).program.typeOracle.isInstantiatedType(toType) || ((TypeTightener)TypeTightener.this).program.typeOracle.castFailsTrivially(fromType, toType)) && toType != JReferenceType.NULL_TYPE) {
                ctx.replaceMe(new JCastOperation(x.getSourceInfo(), JReferenceType.NULL_TYPE, x.getExpr()));
                return;
            }
            JReferenceType tighterType = this.getSingleConcreteType(toType);
            if (tighterType != null && tighterType != toType) {
                ctx.replaceMe(new JCastOperation(x.getSourceInfo(), tighterType, x.getExpr()));
            }
        }

        @Override
        public void endVisit(JConditional x, Context ctx) {
            if (!(x.getType() instanceof JReferenceType)) {
                return;
            }
            JReferenceType type = (JReferenceType)x.getType();
            JReferenceType resultType = TypeTightener.this.strongerType(type, new JReferenceType[]{(JReferenceType)x.getThenExpr().getType(), (JReferenceType)x.getElseExpr().getType()});
            if (type != resultType) {
                x.setType(resultType);
                this.madeChanges();
            }
        }

        @Override
        public void exit(JField x, Context ctx) {
            if (((TypeTightener)TypeTightener.this).program.codeGenTypes.contains(x.getEnclosingType()) || x.canBeReferencedExternally() || x.canBeImplementedExternally()) {
                return;
            }
            if (!x.isVolatile()) {
                this.tighten(x);
            }
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            JType argType = x.getExpr().getType();
            if (!(argType instanceof JReferenceType)) {
                return;
            }
            JReferenceType concreteType = this.getSingleConcreteType(x.getTestType());
            if (concreteType != null) {
                ctx.replaceMe(new JInstanceOf(x.getSourceInfo(), concreteType.getUnderlyingType(), x.getExpr()));
            }
        }

        @Override
        public void endVisit(JLocal x, Context ctx) {
            this.tighten(x);
        }

        @Override
        public void exit(JMethod x, Context ctx) {
            if (((TypeTightener)TypeTightener.this).program.codeGenTypes.contains(x.getEnclosingType())) {
                return;
            }
            if (!(x.getType() instanceof JReferenceType)) {
                return;
            }
            JReferenceType returnType = (JReferenceType)x.getType();
            if (returnType.isNullType()) {
                return;
            }
            if (!((TypeTightener)TypeTightener.this).program.typeOracle.isInstantiatedType(returnType)) {
                x.setType(JReferenceType.NULL_TYPE);
                this.madeChanges();
                return;
            }
            JReferenceType concreteType = this.getSingleConcreteType(returnType);
            if (concreteType != null) {
                x.setType(concreteType);
                this.madeChanges();
            }
            if (x.isJsniMethod() || x.canBeImplementedExternally()) {
                return;
            }
            Iterable<JReferenceType> returnTypes = Iterables.concat(JjsUtils.getExpressionTypes((Iterable)TypeTightener.this.returns.get(x)), JjsUtils.getExpressionTypes(x.getOverridingMethods()));
            JReferenceType strengthenedType = TypeTightener.this.strongerType(returnType, returnTypes);
            if (returnType != strengthenedType) {
                x.setType(strengthenedType);
                this.madeChanges();
            }
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (!x.canBePolymorphic() || x.isVolatile()) {
                return;
            }
            JMethod target = x.getTarget();
            JMethod concreteMethod = this.getSingleConcreteMethodOverride(target);
            assert (concreteMethod != target);
            if (concreteMethod != null) {
                assert (!x.isStaticDispatchOnly());
                JMethodCall newCall = new JMethodCall(x.getSourceInfo(), x.getInstance(), concreteMethod, new JExpression[0]);
                newCall.addArgs(x.getArgs());
                newCall.setCannotBePolymorphic();
                ctx.replaceMe(newCall);
            }
        }

        @Override
        public void endVisit(JThisRef x, Context ctx) {
            if (this.getCurrentMethod().isJsOverlay()) {
                return;
            }
            if (x.getType().canBeNull()) {
                ctx.replaceMe(new JThisRef(x.getSourceInfo(), x.getClassType(), x.getType().strengthenToNonNull()));
            }
        }

        @Override
        public void endVisit(JParameter x, Context ctx) {
            JMethod currentMethod = this.getCurrentMethod();
            if (((TypeTightener)TypeTightener.this).program.codeGenTypes.contains(currentMethod.getEnclosingType()) || currentMethod.canBeReferencedExternally() || x.isVarargs() && currentMethod.isJsMethodVarargs()) {
                return;
            }
            this.tighten(x);
        }

        @Override
        public void endVisit(JPermutationDependentValue x, Context ctx) {
            throw new IllegalStateException("AST should not contain permutation dependent values at this point but contains " + x);
        }

        @Override
        public boolean visit(JRunAsync x, Context ctx) {
            x.traverseOnSuccess(this);
            return true;
        }

        private JMethod getSingleConcreteMethodOverride(JMethod method) {
            assert (method.canBePolymorphic());
            if (this.getSingleConcreteType(method.getEnclosingType()) != null) {
                return (JMethod)TypeTightener.getSingleConcrete(method.getOverridingMethods());
            }
            return null;
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return !((TypeTightener)TypeTightener.this).program.codeGenTypes.contains(x);
        }

        @Override
        public boolean enter(JMethod x, Context ctx) {
            return !x.isJsniMethod();
        }

        private JReferenceType getSingleConcreteType(JType type) {
            if (!(type instanceof JReferenceType) || type.canBeImplementedExternally()) {
                return null;
            }
            JReferenceType refType = (JReferenceType)type;
            if (refType.isAbstract()) {
                JReferenceType singleConcrete = (JReferenceType)TypeTightener.getSingleConcrete((Collection)TypeTightener.this.implementors.get(refType.getUnderlyingType()));
                assert (singleConcrete == null || ((TypeTightener)TypeTightener.this).program.typeOracle.isInstantiatedType(singleConcrete));
                if (singleConcrete == null) {
                    return null;
                }
                singleConcrete = singleConcrete.strengthenToExact();
                return refType.canBeNull() ? singleConcrete : singleConcrete.strengthenToNonNull();
            }
            return null;
        }

        private void tighten(JVariable x) {
            if (!(x.getType() instanceof JReferenceType)) {
                return;
            }
            JReferenceType varType = (JReferenceType)x.getType();
            if (varType.isNullType()) {
                return;
            }
            if (!((TypeTightener)TypeTightener.this).program.typeOracle.isInstantiatedType(varType)) {
                x.setType(JReferenceType.NULL_TYPE);
                this.madeChanges();
                return;
            }
            JReferenceType leafType = this.getSingleConcreteType(varType);
            if (leafType != null) {
                x.setType(leafType);
                this.madeChanges();
                return;
            }
            Collection<JReferenceType> assignmentTypes = this.getAssignmentsIfValid(x);
            if (assignmentTypes == null) {
                return;
            }
            JReferenceType strengthenedType = TypeTightener.this.strongerType(varType, Iterables.concat(assignmentTypes, JjsUtils.getExpressionTypes((Iterable)TypeTightener.this.paramUpRefs.get(x))));
            if (varType != strengthenedType) {
                x.setType(strengthenedType);
                this.madeChanges();
            }
        }

        private Collection<JReferenceType> getAssignmentsIfValid(JVariable variable) {
            Collection assignedExpressions = (Collection)TypeTightener.this.assignments.get(variable);
            if (assignedExpressions == null) {
                return Collections.emptyList();
            }
            ArrayList<JReferenceType> assignedTypes = Lists.newArrayList();
            for (JExpression expression : assignedExpressions) {
                JType expressionType = expression.getType();
                if (!(expressionType instanceof JReferenceType)) {
                    return null;
                }
                assignedTypes.add((JReferenceType)expressionType);
            }
            return assignedTypes;
        }
    }

    private class RecordVisitor
    extends JVisitor {
        private JMethod currentMethod;
        private Predicate<JField> canUninitializedValueBeObserved;
        private Stack<JMethod> nestedCallTrace = new Stack();

        private RecordVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (x.isAssignment() && x.getType() instanceof JReferenceType) {
                JExpression lhs = x.getLhs();
                if (lhs instanceof JVariableRef) {
                    this.addAssignment(((JVariableRef)lhs).getTarget(), x.getOp() == JBinaryOperator.ASG ? x.getRhs() : x);
                } else assert (lhs instanceof JArrayRef);
            }
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            if (((TypeTightener)TypeTightener.this).program.typeOracle.isInstantiatedType(x)) {
                for (JClassType cur = x; cur != null; cur = cur.getSuperClass()) {
                    this.addImplementor(cur, x);
                    this.addInterfacesImplementorRecursive(cur, x);
                }
            }
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            JExpression initializer = x.getInitializer();
            if (initializer != null) {
                this.addAssignment(x.getVariableRef().getTarget(), initializer);
            }
        }

        @Override
        public void endVisit(JField x, Context ctx) {
            if (!x.hasInitializer() || this.canUninitializedValueBeObserved.apply(x)) {
                this.addAssignment(x, x.getType().getDefaultValue());
            }
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            if (!this.nestedCallTrace.empty()) {
                TypeTightener.this.calledMethodsByFieldRefArg.put(x.getField(), this.nestedCallTrace.peek());
            }
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            Iterator<JExpression> argIt = x.getArgs().iterator();
            List<JParameter> params = x.getTarget().getParams();
            for (JParameter param : params) {
                JExpression arg = argIt.next();
                if (!(param.getType() instanceof JReferenceType)) continue;
                this.addAssignment(param, arg);
            }
            this.nestedCallTrace.pop();
            if (!this.nestedCallTrace.empty()) {
                TypeTightener.this.calledMethodsByMethodCallArg.put(x.getTarget(), this.nestedCallTrace.peek());
            }
        }

        @Override
        public void endVisit(JReturnStatement x, Context ctx) {
            if (this.currentMethod.getType() instanceof JReferenceType) {
                this.addReturn(this.currentMethod, x.getExpr());
            }
        }

        @Override
        public void endVisit(JsniFieldRef x, Context ctx) {
            if (x.isLvalue()) {
                this.addAssignment(x.getTarget(), x);
            }
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            JMethod method = x.getTarget();
            for (JParameter param : method.getParams()) {
                this.addAssignment(param, param.makeRef(SourceOrigin.UNKNOWN));
            }
        }

        @Override
        public void endVisit(JTryStatement x, Context ctx) {
            for (JTryStatement.CatchClause clause : x.getCatchClauses()) {
                this.addAssignment(clause.getArg().getTarget(), clause.getArg());
            }
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            if (x.canBePolymorphic()) {
                Set<JMethod> overriddenMethods = x.getOverriddenMethods();
                if (overriddenMethods.isEmpty()) {
                    return true;
                }
                int c = x.getParams().size();
                for (int j = 0; j < c; ++j) {
                    JParameter param = x.getParams().get(j);
                    for (JMethod baseMethod : overriddenMethods) {
                        JParameter baseParam = baseMethod.getParams().get(j);
                        TypeTightener.add(param, baseParam, TypeTightener.this.paramUpRefs);
                    }
                }
            }
            return true;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            this.nestedCallTrace.push(x.getTarget());
            return true;
        }

        public void record(JProgram program) {
            this.canUninitializedValueBeObserved = ComputePotentiallyObservableUninitializedValues.analyze(program);
            this.accept(program);
        }

        private void addAssignment(JVariable target, JExpression rhs) {
            TypeTightener.add(target, rhs, TypeTightener.this.assignments);
        }

        private void addImplementor(JReferenceType target, JClassType implementor) {
            TypeTightener.add(target, implementor, TypeTightener.this.implementors);
        }

        private void addInterfacesImplementorRecursive(JDeclaredType target, JClassType implementor) {
            for (JInterfaceType implment : target.getImplements()) {
                this.addImplementor(implment, implementor);
                this.addInterfacesImplementorRecursive(implment, implementor);
            }
        }

        private void addReturn(JMethod target, JExpression expr) {
            TypeTightener.add(target, expr, TypeTightener.this.returns);
        }
    }

    public class FixDanglingRefsVisitor
    extends JChangeTrackingVisitor {
        public FixDanglingRefsVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            JExpression instance = x.getInstance();
            JField field = x.getField();
            if (field.isStatic() && instance != null) {
                if (!instance.hasSideEffects()) {
                    JFieldRef fieldRef = new JFieldRef(x.getSourceInfo(), null, field, x.getEnclosingType());
                    ctx.replaceMe(fieldRef);
                }
            } else if (TypeTightener.this.isNullReference(field, instance) && field != TypeTightener.this.program.getNullField()) {
                ctx.replaceMe(Pruner.transformToNullFieldRef(x, TypeTightener.this.program));
            }
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JExpression instance = x.getInstance();
            JMethod method = x.getTarget();
            boolean isStaticImpl = TypeTightener.this.program.isStaticImpl(method);
            if (method.isStatic() && !isStaticImpl && instance != null) {
                if (!instance.hasSideEffects()) {
                    JMethodCall newCall = new JMethodCall(x.getSourceInfo(), null, x.getTarget(), new JExpression[0]);
                    newCall.addArgs(x.getArgs());
                    ctx.replaceMe(newCall);
                }
            } else if (TypeTightener.this.isNullReference(method, instance)) {
                ctx.replaceMe(Pruner.transformToNullMethodCall(x, TypeTightener.this.program));
            } else if (isStaticImpl && method.getParams().size() > 0 && method.getParams().get(0).isThis() && x.getArgs().size() > 0 && x.getArgs().get(0).getType().isNullType()) {
                ctx.replaceMe(Pruner.transformToNullMethodCall(x, TypeTightener.this.program));
            }
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
        }
    }
}

