/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.OptimizerContext;

public abstract class TypeRemapper
extends JChangeTrackingVisitor {
    public TypeRemapper(OptimizerContext optimizerCtx) {
        super(optimizerCtx);
    }

    @Override
    public void endVisit(JBinaryOperation x, Context ctx) {
        x.setType(this.remap(x.getType()));
    }

    @Override
    public void endVisit(JCastOperation x, Context ctx) {
        JType remapCastType = this.remap(x.getCastType());
        if (remapCastType != x.getCastType()) {
            JCastOperation newX = new JCastOperation(x.getSourceInfo(), remapCastType, x.getExpr());
            ctx.replaceMe(newX);
        }
    }

    @Override
    public void endVisit(JConditional x, Context ctx) {
        x.setType(this.modRemap(x.getType()));
    }

    @Override
    public void exit(JConstructor x, Context ctx) {
        x.setType(this.modRemap(x.getType()));
    }

    @Override
    public void exit(JMethod x, Context ctx) {
        x.setType(this.modRemap(x.getType()));
    }

    @Override
    public void endVisit(JNewArray x, Context ctx) {
        x.setType((JArrayType)this.modRemap(x.getArrayType()));
    }

    @Override
    public void endVisit(JPermutationDependentValue x, Context ctx) {
        throw new IllegalStateException("AST should not contain permutation dependent values at this point but contains " + x);
    }

    @Override
    public void exit(JVariable x, Context ctx) {
        x.setType(this.modRemap(x.getType()));
    }

    protected abstract JType remap(JType var1);

    private JType modRemap(JType type) {
        JType result = this.remap(type);
        if (result != type) {
            this.madeChanges();
        }
        return result;
    }
}

