/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import java.util.List;

public class TypeReferencesRecorder
extends JVisitor {
    private String fromTypeName;
    private final MinimalRebuildCache minimalRebuildCache;
    private final boolean onlyUpdate;

    public static void exec(JProgram program, MinimalRebuildCache minimalRebuildCache, boolean onlyUpdate) {
        new TypeReferencesRecorder(minimalRebuildCache, onlyUpdate).execImpl(program);
    }

    public TypeReferencesRecorder(MinimalRebuildCache minimalRebuildCache, boolean onlyUpdate) {
        this.onlyUpdate = onlyUpdate;
        this.minimalRebuildCache = minimalRebuildCache;
    }

    @Override
    public void endVisit(JCastOperation x, Context ctx) {
        this.maybeRecordTypeRef(x.getCastType());
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JClassLiteral x, Context ctx) {
        this.maybeRecordTypeRef(x.getRefType());
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JFieldRef x, Context ctx) {
        this.processJFieldRef(x);
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JInstanceOf x, Context ctx) {
        this.maybeRecordTypeRef(x.getTestType());
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JMethod x, Context ctx) {
        this.maybeRecordTypeRef(x.getType());
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JMethodCall x, Context ctx) {
        this.processMethodCall(x);
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JNewInstance x, Context ctx) {
        JClassType enclosingType = x.getTarget().getEnclosingType();
        this.maybeRecordTypeRef(enclosingType);
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JsniFieldRef x, Context ctx) {
        this.processJFieldRef(x);
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JsniMethodRef x, Context ctx) {
        this.processMethodCall(x);
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JValueLiteral x, Context ctx) {
        this.maybeRecordTypeRef(x.getType());
        super.endVisit(x, ctx);
    }

    @Override
    public void endVisit(JVariable x, Context ctx) {
        this.maybeRecordTypeRef(x.getType());
        super.endVisit(x, ctx);
    }

    @Override
    public boolean visit(JDeclaredType x, Context ctx) {
        this.fromTypeName = x.getName();
        if (!this.onlyUpdate) {
            this.minimalRebuildCache.removeReferencesFrom(this.fromTypeName);
        }
        this.maybeRecordTypeRef(x.getSuperClass());
        this.maybeRecordTypeRefs(x.getImplements());
        return super.visit(x, ctx);
    }

    private void execImpl(JProgram program) {
        this.accept(program);
    }

    private void maybeRecordTypeRef(JType referencedType) {
        if (referencedType instanceof JArrayType) {
            JArrayType toArrayType = (JArrayType)referencedType;
            this.maybeRecordTypeRef(toArrayType.getLeafType());
        }
        if (!(referencedType instanceof JDeclaredType)) {
            return;
        }
        JDeclaredType toType = (JDeclaredType)referencedType;
        this.maybeRecordTypeRef(this.fromTypeName, toType.getName());
    }

    private void maybeRecordTypeRef(String fromTypeName, String toTypeName) {
        this.minimalRebuildCache.addTypeReference(fromTypeName, toTypeName);
    }

    private void maybeRecordTypeRefs(List<? extends JDeclaredType> toTypes) {
        for (JDeclaredType jDeclaredType : toTypes) {
            this.maybeRecordTypeRef(jDeclaredType);
        }
    }

    private void processJFieldRef(JFieldRef x) {
        JField field;
        if (x.getTarget() instanceof JField && (field = (JField)x.getTarget()).isStatic()) {
            this.maybeRecordTypeRef(field.getEnclosingType());
        }
    }

    private void processMethodCall(JMethodCall x) {
        if (x.getTarget().isStatic() || x.getTarget().isConstructor()) {
            this.maybeRecordTypeRef(x.getTarget().getEnclosingType());
        }
    }
}

