/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JType;

public class TypeCoercionNormalizer {
    private final JProgram program;

    public static void exec(JProgram program) {
        new TypeCoercionNormalizer(program).execImpl();
    }

    private TypeCoercionNormalizer(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        new ConcatRewriteVisitor().accept(this.program);
        new DivRewriteVisitor().accept(this.program);
    }

    private class DivRewriteVisitor
    extends JModVisitor {
        private DivRewriteVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JType type = x.getType();
            if (x.getOp() != JBinaryOperator.DIV || type == TypeCoercionNormalizer.this.program.getTypePrimitiveFloat() || type == TypeCoercionNormalizer.this.program.getTypePrimitiveDouble()) {
                return;
            }
            String methodName = "Cast.narrow_" + type.getName();
            JMethod castMethod = TypeCoercionNormalizer.this.program.getIndexedMethod(methodName);
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, castMethod, x);
            call.overrideReturnType(type);
            x.setType(TypeCoercionNormalizer.this.program.getTypePrimitiveDouble());
            ctx.replaceMe(call);
        }
    }

    private class ConcatRewriteVisitor
    extends JModVisitor {
        private final JClassType typeJavaLangString;

        private ConcatRewriteVisitor() {
            this.typeJavaLangString = TypeCoercionNormalizer.this.program.getTypeJavaLangString();
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (!this.isConcatOperation(x.getOp())) {
                return;
            }
            JExpression lhs = x.getLhs();
            JExpression rhs = x.getRhs();
            JExpression newLhs = this.coerceToString(lhs);
            JExpression newRhs = this.coerceToString(rhs);
            assert (!x.getOp().isAssignment() || newLhs == lhs) : "L-values can never be rewritten (CONCAT_ASG can not have an lhs of type char or long).";
            SourceInfo sourceInfo = x.getSourceInfo();
            if (newLhs != lhs || newRhs != rhs) {
                JBinaryOperation newExpr = this.newStringBinaryOperation(sourceInfo, x.getOp(), newLhs, newRhs);
                ctx.replaceMe(newExpr);
            } else if (lhs.getType().canBeNull() && rhs.getType().canBeNull()) {
                JBinaryOperation newExpr = this.newStringBinaryOperation(sourceInfo, x.getOp(), lhs, this.newConcatOperation(sourceInfo, this.emptyString(sourceInfo), rhs));
                ctx.replaceMe(newExpr);
            }
        }

        private JBinaryOperation newStringBinaryOperation(SourceInfo sourceInfo, JBinaryOperator op, JExpression lhs, JExpression rhs) {
            return new JBinaryOperation(sourceInfo, this.typeJavaLangString, op, lhs, rhs);
        }

        private JBinaryOperation newConcatOperation(SourceInfo sourceInfo, JExpression lhs, JExpression rhs) {
            return this.newStringBinaryOperation(sourceInfo, JBinaryOperator.CONCAT, lhs, rhs);
        }

        private JStringLiteral emptyString(SourceInfo sourceInfo) {
            return new JStringLiteral(sourceInfo, "", this.typeJavaLangString);
        }

        private JExpression coerceToString(JExpression expr) {
            JPrimitiveType typePrimitiveChar = TypeCoercionNormalizer.this.program.getTypePrimitiveChar();
            JPrimitiveType typePrimitiveLong = TypeCoercionNormalizer.this.program.getTypePrimitiveLong();
            if (expr instanceof JLongLiteral) {
                long longValue = ((JLongLiteral)expr).getValue();
                return TypeCoercionNormalizer.this.program.getStringLiteral(expr.getSourceInfo(), String.valueOf(longValue));
            }
            if (expr.getType() == typePrimitiveLong) {
                JMethodCall call = new JMethodCall(expr.getSourceInfo(), null, TypeCoercionNormalizer.this.program.getIndexedMethod("LongLib.toString"), expr);
                return call;
            }
            if (expr instanceof JCharLiteral) {
                char charValue = ((JCharLiteral)expr).getValue();
                return TypeCoercionNormalizer.this.program.getStringLiteral(expr.getSourceInfo(), Character.toString(charValue));
            }
            if (expr.getType() == typePrimitiveChar) {
                JMethodCall call = new JMethodCall(expr.getSourceInfo(), null, TypeCoercionNormalizer.this.program.getIndexedMethod("Cast.charToString"), expr);
                return call;
            }
            return expr;
        }

        private boolean isConcatOperation(JBinaryOperator operator) {
            switch (operator) {
                case CONCAT: 
                case ASG_CONCAT: {
                    return true;
                }
            }
            return false;
        }
    }
}

