/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import java.util.Map;

public final class TypeCategory
extends Enum<TypeCategory> {
    public static final /* enum */ TypeCategory TYPE_JAVA_OBJECT = new TypeCategory("", true, false);
    public static final /* enum */ TypeCategory TYPE_JAVA_OBJECT_OR_JSO = new TypeCategory("AllowJso", true, false);
    public static final /* enum */ TypeCategory TYPE_JSO = new TypeCategory("Jso");
    public static final /* enum */ TypeCategory TYPE_ARRAY = new TypeCategory("Array");
    public static final /* enum */ TypeCategory TYPE_JSO_ARRAY = new TypeCategory("JsoArray", true, false);
    public static final /* enum */ TypeCategory TYPE_JAVA_LANG_OBJECT = new TypeCategory("AllowJso", true, false);
    public static final /* enum */ TypeCategory TYPE_JAVA_LANG_STRING = new TypeCategory("String");
    public static final /* enum */ TypeCategory TYPE_JAVA_LANG_DOUBLE = new TypeCategory("Double");
    public static final /* enum */ TypeCategory TYPE_JAVA_LANG_BOOLEAN = new TypeCategory("Boolean");
    public static final /* enum */ TypeCategory TYPE_JS_NATIVE = new TypeCategory("Native", false, true);
    public static final /* enum */ TypeCategory TYPE_JS_UNKNOWN_NATIVE = new TypeCategory("UnknownNative");
    public static final /* enum */ TypeCategory TYPE_JS_FUNCTION = new TypeCategory("Function");
    public static final /* enum */ TypeCategory TYPE_JS_OBJECT = new TypeCategory("JsObject");
    public static final /* enum */ TypeCategory TYPE_JS_ARRAY = new TypeCategory("JsArray");
    public static final /* enum */ TypeCategory TYPE_PRIMITIVE_LONG = new TypeCategory();
    public static final /* enum */ TypeCategory TYPE_PRIMITIVE_NUMBER = new TypeCategory();
    public static final /* enum */ TypeCategory TYPE_PRIMITIVE_BOOLEAN = new TypeCategory();
    private final String castInstanceOfQualifier;
    private final boolean requiresTypeId;
    private final boolean requiresConstructor;
    private static Map<String, TypeCategory> specialGlobalNames;
    private static final /* synthetic */ TypeCategory[] $VALUES;

    public static TypeCategory[] values() {
        return (TypeCategory[])$VALUES.clone();
    }

    public static TypeCategory valueOf(String name) {
        return Enum.valueOf(TypeCategory.class, name);
    }

    private TypeCategory() {
        this(null, false, false);
    }

    private TypeCategory(String castInstanceOfQualifier) {
        this(castInstanceOfQualifier, false, false);
    }

    private TypeCategory(String castInstanceOfQualifier, boolean requiresTypeId, boolean requiresConstructor) {
        this.castInstanceOfQualifier = castInstanceOfQualifier;
        this.requiresTypeId = requiresTypeId;
        this.requiresConstructor = requiresConstructor;
    }

    public String castInstanceOfQualifier() {
        return this.castInstanceOfQualifier;
    }

    public boolean requiresTypeId() {
        return this.requiresTypeId;
    }

    public boolean requiresJsConstructor() {
        return this.requiresConstructor;
    }

    public static TypeCategory typeCategoryForType(JType type, JProgram program) {
        if (type.isPrimitiveType()) {
            if (type == JPrimitiveType.BOOLEAN) {
                return TYPE_PRIMITIVE_BOOLEAN;
            }
            if (type == JPrimitiveType.LONG) {
                return TYPE_PRIMITIVE_LONG;
            }
            return TYPE_PRIMITIVE_NUMBER;
        }
        assert (type instanceof JReferenceType);
        if ((type = type.getUnderlyingType()) == program.getTypeJavaLangObjectArray()) {
            return TYPE_ARRAY;
        }
        if (TypeCategory.isJsoArray(type)) {
            return TYPE_JSO_ARRAY;
        }
        if (TypeCategory.getJsSpecialType(type) != null) {
            return TypeCategory.getJsSpecialType(type);
        }
        if (program.isUntypedArrayType(type)) {
            return TYPE_JS_ARRAY;
        }
        if (type == program.getTypeJavaLangObject()) {
            return TYPE_JAVA_LANG_OBJECT;
        }
        if (program.getRepresentedAsNativeTypesDispatchMap().containsKey(type)) {
            return program.getRepresentedAsNativeTypesDispatchMap().get(type).getTypeCategory();
        }
        if (program.typeOracle.isEffectivelyJavaScriptObject(type)) {
            return TYPE_JSO;
        }
        if (program.typeOracle.isDualJsoInterface(type)) {
            return TYPE_JAVA_OBJECT_OR_JSO;
        }
        JTypeOracle cfr_ignored_0 = program.typeOracle;
        if (JTypeOracle.isNoOpCast(type)) {
            return TYPE_JS_UNKNOWN_NATIVE;
        }
        if (type instanceof JClassType && type.isJsNative()) {
            return TYPE_JS_NATIVE;
        }
        if (type.isJsFunction() || type.isJsFunctionImplementation()) {
            return TYPE_JS_FUNCTION;
        }
        return TYPE_JAVA_OBJECT;
    }

    private static TypeCategory getJsSpecialType(JType type) {
        if (!(type instanceof JClassType) || !type.isJsNative()) {
            return null;
        }
        JClassType classType = (JClassType)type;
        if (!JsInteropUtil.isGlobal(classType.getJsNamespace())) {
            return null;
        }
        return specialGlobalNames.get(classType.getJsName());
    }

    private static boolean isJsoArray(JType type) {
        if (!type.isArrayType()) {
            return false;
        }
        JArrayType arrayType = (JArrayType)type;
        return arrayType.getLeafType().isJsoType();
    }

    static {
        $VALUES = new TypeCategory[]{TYPE_JAVA_OBJECT, TYPE_JAVA_OBJECT_OR_JSO, TYPE_JSO, TYPE_ARRAY, TYPE_JSO_ARRAY, TYPE_JAVA_LANG_OBJECT, TYPE_JAVA_LANG_STRING, TYPE_JAVA_LANG_DOUBLE, TYPE_JAVA_LANG_BOOLEAN, TYPE_JS_NATIVE, TYPE_JS_UNKNOWN_NATIVE, TYPE_JS_FUNCTION, TYPE_JS_OBJECT, TYPE_JS_ARRAY, TYPE_PRIMITIVE_LONG, TYPE_PRIMITIVE_NUMBER, TYPE_PRIMITIVE_BOOLEAN};
        specialGlobalNames = ImmutableMap.builder().put("Object", TYPE_JS_OBJECT).put("Function", TYPE_JS_FUNCTION).put("Array", TYPE_JS_ARRAY).put("Number", TYPE_JAVA_LANG_DOUBLE).put("String", TYPE_JAVA_LANG_STRING).build();
    }
}

