/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.CanBeAbstract;
import com.google.gwt.dev.jjs.ast.CanBeFinal;
import com.google.gwt.dev.jjs.ast.CanBeStatic;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.HasType;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JAssertStatement;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JBreakStatement;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JContinueStatement;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoStatement;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLabel;
import com.google.gwt.dev.jjs.ast.JLabeledStatement;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JWhileStatement;
import com.google.gwt.dev.jjs.ast.JYieldStatement;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.ast.js.JsonArray;
import com.google.gwt.dev.jjs.impl.JavaPrecedenceVisitor;
import com.google.gwt.dev.jjs.impl.TextOutputVisitor;
import com.google.gwt.dev.js.JsSourceGenerationVisitor;
import com.google.gwt.dev.util.TextOutput;
import java.util.Iterator;

public class ToStringGenerationVisitor
extends TextOutputVisitor {
    protected static final char[] CHARS_ABSTRACT = "abstract ".toCharArray();
    protected static final char[] CHARS_ASSERT = "assert ".toCharArray();
    protected static final char[] CHARS_BREAK = "break".toCharArray();
    protected static final char[] CHARS_CASE = "case ".toCharArray();
    protected static final char[] CHARS_CATCH = " catch ".toCharArray();
    protected static final char[] CHARS_CLASS = "class ".toCharArray();
    protected static final char[] CHARS_COMMA = ", ".toCharArray();
    protected static final char[] CHARS_CONTINUE = "continue".toCharArray();
    protected static final char[] CHARS_DEFAULT = "default".toCharArray();
    protected static final char[] CHARS_DO = "do".toCharArray();
    protected static final char[] CHARS_DOTCLASS = ".class".toCharArray();
    protected static final char[] CHARS_ELSE = "else".toCharArray();
    protected static final char[] CHARS_EXTENDS = "extends ".toCharArray();
    protected static final char[] CHARS_FALSE = "false".toCharArray();
    protected static final char[] CHARS_FINAL = "final ".toCharArray();
    protected static final char[] CHARS_FINALLY = " finally ".toCharArray();
    protected static final char[] CHARS_FOR = "for ".toCharArray();
    protected static final char[] CHARS_IF = "if ".toCharArray();
    protected static final char[] CHARS_IMPLEMENTS = "implements ".toCharArray();
    protected static final char[] CHARS_INSTANCEOF = " instanceof ".toCharArray();
    protected static final char[] CHARS_INTERFACE = "interface ".toCharArray();
    protected static final char[] CHARS_NAMEOF = " JNameOf ".toCharArray();
    protected static final char[] CHARS_NATIVE = "native ".toCharArray();
    protected static final char[] CHARS_NEW = "new ".toCharArray();
    protected static final char[] CHARS_NULL = "null".toCharArray();
    protected static final char[] CHARS_PIPE = " | ".toCharArray();
    protected static final char[] CHARS_PRIVATE = "private ".toCharArray();
    protected static final char[] CHARS_PROTECTED = "protected ".toCharArray();
    protected static final char[] CHARS_PUBLIC = "public ".toCharArray();
    protected static final char[] CHARS_RETURN = "return".toCharArray();
    protected static final char[] CHARS_RUNTIMETYPEREFERENCE = " JRuntimeTypeReference ".toCharArray();
    protected static final char[] CHARS_SLASHSTAR = "/*".toCharArray();
    protected static final char[] CHARS_STARSLASH = "*/".toCharArray();
    protected static final char[] CHARS_STATIC = "static ".toCharArray();
    protected static final char[] CHARS_SUPER = "super".toCharArray();
    protected static final char[] CHARS_SWITCH = "switch ".toCharArray();
    protected static final char[] CHARS_THIS = "this".toCharArray();
    protected static final char[] CHARS_THROW = "throw".toCharArray();
    protected static final char[] CHARS_TRUE = "true".toCharArray();
    protected static final char[] CHARS_TRY = "try ".toCharArray();
    protected static final char[] CHARS_WHILE = "while ".toCharArray();
    protected static final char[] CHARS_YIELD = "yield ".toCharArray();
    private boolean needSemi = true;
    private boolean suppressType = false;

    public ToStringGenerationVisitor(TextOutput textOutput) {
        super(textOutput);
    }

    @Override
    public boolean visit(JArrayLength x, Context ctx) {
        JExpression instance = x.getInstance();
        this.parenPush(x, instance);
        this.accept(instance);
        this.parenPop(x, instance);
        this.print(".length");
        return false;
    }

    @Override
    public boolean visit(JArrayRef x, Context ctx) {
        JExpression instance = x.getInstance();
        this.parenPush(x, instance);
        this.accept(instance);
        this.parenPop(x, instance);
        this.print('[');
        this.accept(x.getIndexExpr());
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(JArrayType x, Context ctx) {
        this.accept(x.getElementType());
        this.print("[]");
        return false;
    }

    @Override
    public boolean visit(JAssertStatement x, Context ctx) {
        this.print(CHARS_ASSERT);
        this.accept(x.getTestExpr());
        if (x.getArg() != null) {
            this.print(" : ");
            this.accept(x.getArg());
        }
        return false;
    }

    @Override
    public boolean visit(JBinaryOperation x, Context ctx) {
        JExpression arg1 = x.getLhs();
        this.parenPush(x, arg1);
        this.accept(arg1);
        this.parenPop(x, arg1);
        this.space();
        this.print(x.getOp().getSymbol());
        this.space();
        JExpression arg2 = x.getRhs();
        this.parenPush(x, arg2);
        this.accept(arg2);
        this.parenPop(x, arg2);
        return false;
    }

    @Override
    public boolean visit(JBlock x, Context ctx) {
        this.openBlock();
        for (int i = 0; i < x.getStatements().size(); ++i) {
            JStatement statement = x.getStatements().get(i);
            this.needSemi = true;
            this.accept(statement);
            if (this.needSemi) {
                this.semi();
            }
            this.newline();
        }
        this.closeBlock();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JBooleanLiteral x, Context ctx) {
        this.printBooleanLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JBreakStatement x, Context ctx) {
        this.print(CHARS_BREAK);
        if (x.getLabel() != null) {
            this.space();
            this.accept(x.getLabel());
        }
        return false;
    }

    @Override
    public boolean visit(JCaseStatement x, Context ctx) {
        if (x.isDefault()) {
            this.print(CHARS_DEFAULT);
        } else {
            this.print(CHARS_CASE);
            boolean first = true;
            for (JExpression expr : x.getExprs()) {
                if (!first) {
                    this.print(',');
                    this.space();
                }
                first = false;
                this.accept(expr);
            }
        }
        this.print(':');
        this.space();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JCastOperation x, Context ctx) {
        this.lparen();
        this.printType(x);
        this.rparen();
        this.space();
        JExpression expr = x.getExpr();
        this.parenPush(x, expr);
        this.accept(expr);
        this.parenPop(x, expr);
        return false;
    }

    @Override
    public boolean visit(JCastMap x, Context ctx) {
        this.print('[');
        this.visitCollectionWithCommas(x.getCanCastToTypes().iterator());
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(JCharLiteral x, Context ctx) {
        this.printCharLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JClassLiteral x, Context ctx) {
        this.printTypeName(x.getRefType());
        this.print(CHARS_DOTCLASS);
        return false;
    }

    @Override
    public boolean visit(JType x, Context ctx) {
        this.print(x.getDescription());
        return false;
    }

    @Override
    public boolean visit(JDeclaredType x, Context ctx) {
        this.visit((JType)x, ctx);
        this.print(" (");
        this.printAbstractFlag(x);
        this.printFinalFlag(x);
        if (x.getSuperClass() != null) {
            this.print(CHARS_EXTENDS);
            this.printTypeName(x.getSuperClass());
        }
        if (x.getImplements().size() > 0) {
            this.space();
            this.print(CHARS_IMPLEMENTS);
            int c = x.getImplements().size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    this.print(CHARS_COMMA);
                }
                this.printTypeName(x.getImplements().get(i));
            }
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(JConditional x, Context ctx) {
        JExpression ifTest = x.getIfTest();
        this.parenPush(x, ifTest);
        this.accept(ifTest);
        this.parenPop(x, ifTest);
        this.print(" ? ");
        JExpression thenExpr = x.getThenExpr();
        this.parenPush(x, thenExpr);
        this.accept(thenExpr);
        this.parenPop(x, thenExpr);
        this.print(" : ");
        JExpression elseExpr = x.getElseExpr();
        this.parenPush(x, elseExpr);
        this.accept(elseExpr);
        this.parenPop(x, elseExpr);
        return false;
    }

    @Override
    public boolean visit(JConstructor x, Context ctx) {
        if (x.isPrivate()) {
            this.print(CHARS_PRIVATE);
        } else {
            this.print(CHARS_PUBLIC);
        }
        this.printName(x);
        this.printParameterList(x);
        if (x.isAbstract() || !this.shouldPrintMethodBody()) {
            this.semi();
            this.newlineOpt();
        } else {
            this.accept(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(JContinueStatement x, Context ctx) {
        this.print(CHARS_CONTINUE);
        if (x.getLabel() != null) {
            this.space();
            this.accept(x.getLabel());
        }
        return false;
    }

    @Override
    public boolean visit(JDebuggerStatement x, Context ctx) {
        this.print("GWT.debugger()");
        return false;
    }

    @Override
    public boolean visit(JDeclarationStatement x, Context ctx) {
        if (!this.suppressType) {
            this.accept(x.getVariableRef().getTarget());
        } else {
            this.accept(x.getVariableRef());
        }
        JExpression initializer = x.getInitializer();
        if (initializer != null) {
            this.print(" = ");
            this.accept(initializer);
        }
        return false;
    }

    @Override
    public boolean visit(JDoStatement x, Context ctx) {
        this.print(CHARS_DO);
        this.needSemi = true;
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        if (this.needSemi) {
            this.semi();
            this.newline();
        } else {
            this.space();
            this.needSemi = true;
        }
        this.print(CHARS_WHILE);
        this.lparen();
        this.accept(x.getTestExpr());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(JDoubleLiteral x, Context ctx) {
        this.printDoubleLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JExpressionStatement x, Context ctx) {
        this.accept(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(JField x, Context ctx) {
        this.printFinalFlag(x);
        this.printStaticFlag(x);
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(JFieldRef x, Context ctx) {
        JExpression instance = x.getInstance();
        if (instance != null) {
            this.parenPush(x, instance);
            this.accept(instance);
            this.parenPop(x, instance);
        } else {
            this.printTypeName(x.getField().getEnclosingType());
        }
        this.print('.');
        this.printName(x.getField());
        return false;
    }

    @Override
    public boolean visit(JFloatLiteral x, Context ctx) {
        this.printDoubleLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JForStatement x, Context ctx) {
        JStatement stmt;
        this.print(CHARS_FOR);
        this.lparen();
        Iterator<JStatement> iter = x.getInitializers().iterator();
        if (iter.hasNext()) {
            stmt = iter.next();
            this.accept(stmt);
        }
        this.suppressType = true;
        while (iter.hasNext()) {
            this.print(CHARS_COMMA);
            stmt = iter.next();
            this.accept(stmt);
        }
        this.suppressType = false;
        this.semi();
        this.space();
        if (x.getCondition() != null) {
            this.accept(x.getCondition());
        }
        this.semi();
        this.space();
        if (x.getIncrements() != null) {
            this.accept(x.getIncrements());
        }
        this.rparen();
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(JIfStatement x, Context ctx) {
        this.print(CHARS_IF);
        this.lparen();
        this.accept(x.getIfExpr());
        this.rparen();
        if (x.getThenStmt() != null) {
            this.nestedStatementPush(x.getThenStmt());
            this.accept(x.getThenStmt());
            this.nestedStatementPop(x.getThenStmt());
        }
        if (x.getElseStmt() != null) {
            if (this.needSemi) {
                this.semi();
                this.newline();
            } else {
                this.space();
                this.needSemi = true;
            }
            this.print(CHARS_ELSE);
            boolean elseIf = x.getElseStmt() instanceof JIfStatement;
            if (!elseIf) {
                this.nestedStatementPush(x.getElseStmt());
            } else {
                this.space();
            }
            this.accept(x.getElseStmt());
            if (!elseIf) {
                this.nestedStatementPop(x.getElseStmt());
            }
        }
        return false;
    }

    @Override
    public boolean visit(JInstanceOf x, Context ctx) {
        JExpression expr = x.getExpr();
        this.parenPush(x, expr);
        this.accept(expr);
        this.parenPop(x, expr);
        this.print(CHARS_INSTANCEOF);
        this.printTypeName(x.getTestType());
        return false;
    }

    @Override
    public boolean visit(JIntLiteral x, Context ctx) {
        this.print(Integer.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(JLabel x, Context ctx) {
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(JLabeledStatement x, Context ctx) {
        this.accept(x.getLabel());
        this.print(" : ");
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JLocal x, Context ctx) {
        this.printFinalFlag(x);
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(JLocalRef x, Context ctx) {
        this.printName(x.getLocal());
        return false;
    }

    @Override
    public boolean visit(JLongLiteral x, Context ctx) {
        this.printLongLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JMethod x, Context ctx) {
        if (!this.shouldPrintMethodBody()) {
            this.print(x.getEnclosingType().getName() + "." + x.getSignature());
            return false;
        }
        this.printMethodHeader(x);
        if (x.isAbstract() || x.isJsNative()) {
            this.semi();
            this.newlineOpt();
        } else {
            this.accept(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(JMethodBody x, Context ctx) {
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(JMethodCall x, Context ctx) {
        JExpression instance = x.getInstance();
        JMethod target = x.getTarget();
        if (instance == null) {
            this.printTypeName(target.getEnclosingType());
            this.print('.');
            this.printName(target);
        } else {
            this.parenPush(x, instance);
            this.accept(instance);
            this.parenPop(x, instance);
            this.print('.');
            if (x.isStaticDispatchOnly()) {
                this.printTypeName(target.getEnclosingType());
                this.print('.');
            }
            this.printName(target);
        }
        this.lparen();
        this.visitCollectionWithCommas(x.getArgs().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(JMultiExpression x, Context ctx) {
        this.lparen();
        this.visitCollectionWithCommas(x.getExpressions().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(JNameOf x, Context ctx) {
        this.print(CHARS_SLASHSTAR);
        this.print(CHARS_NAMEOF);
        this.print(CHARS_STARSLASH);
        this.printStringLiteral(x.getNode().getName());
        return false;
    }

    @Override
    public boolean visit(JRuntimeTypeReference x, Context ctx) {
        this.print(CHARS_SLASHSTAR);
        this.print(CHARS_RUNTIMETYPEREFERENCE);
        this.print(CHARS_STARSLASH);
        this.printStringLiteral(x.getReferredType().getName());
        return false;
    }

    @Override
    public boolean visit(JNewArray x, Context ctx) {
        this.print(CHARS_NEW);
        this.printTypeName(x.getArrayType());
        if (x.getInitializers() != null) {
            this.print(" {");
            this.visitCollectionWithCommas(x.getInitializers().iterator());
            this.print('}');
        } else {
            for (int i = 0; i < x.getDimensionExpressions().size(); ++i) {
                JExpression expr = x.getDimensionExpressions().get(i);
                this.print('[');
                this.accept(expr);
                this.print(']');
            }
        }
        return false;
    }

    @Override
    public boolean visit(JNewInstance x, Context ctx) {
        this.print(CHARS_NEW);
        JConstructor target = x.getTarget();
        this.printName(target);
        this.lparen();
        this.visitCollectionWithCommas(x.getArgs().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(JNullLiteral x, Context ctx) {
        this.print(CHARS_NULL);
        return false;
    }

    @Override
    public boolean visit(JParameter x, Context ctx) {
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(JParameterRef x, Context ctx) {
        this.printName(x.getTarget());
        return false;
    }

    @Override
    public boolean visit(JPermutationDependentValue x, Context ctx) {
        if (x.isTypeRebind()) {
            this.print("GWT.create(");
            this.print(x.getRequestedValue());
            this.print(".class)");
        } else {
            assert (x.isProperty());
            this.print("System.getProperty(");
            this.print("\"");
            this.print(x.getRequestedValue());
            this.print("\"");
            if (x.getDefaultValueExpression() != null) {
                this.print(", ");
                this.accept(x.getDefaultValueExpression());
            }
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(JPostfixOperation x, Context ctx) {
        JExpression arg = x.getArg();
        this.parenPush(x, arg);
        this.accept(arg);
        this.parenPop(x, arg);
        this.print(x.getOp().getSymbol());
        return false;
    }

    @Override
    public boolean visit(JPrefixOperation x, Context ctx) {
        this.print(x.getOp().getSymbol());
        JExpression arg = x.getArg();
        this.parenPush(x, arg);
        this.accept(arg);
        this.parenPop(x, arg);
        return false;
    }

    @Override
    public boolean visit(JPrimitiveType x, Context ctx) {
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(JProgram x, Context ctx) {
        this.print("<JProgram>");
        return false;
    }

    @Override
    public boolean visit(JReturnStatement x, Context ctx) {
        this.print(CHARS_RETURN);
        if (x.getExpr() != null) {
            this.space();
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(JsniFieldRef x, Context ctx) {
        return this.visit(x.getField(), ctx);
    }

    @Override
    public boolean visit(final JsniMethodBody x, Context ctx) {
        this.print(" /*-");
        new JsSourceGenerationVisitor(this){
            {
                super(out);
                this.printJsBlock(x.getFunc().getBody(), false, false);
            }
        };
        this.print("-*/");
        this.semi();
        return false;
    }

    @Override
    public boolean visit(JsniMethodRef x, Context ctx) {
        this.printMethodHeader(x.getTarget());
        return false;
    }

    @Override
    public boolean visit(JsonArray x, Context ctx) {
        this.print('[');
        this.visitCollectionWithCommas(x.getExpressions().iterator());
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(JStringLiteral x, Context ctx) {
        this.printStringLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JSwitchExpression x, Context ctx) {
        return this.writeSwitch(x.getExpr(), x.getBody());
    }

    private boolean writeSwitch(JExpression expr, JBlock body) {
        this.print(CHARS_SWITCH);
        this.lparen();
        this.accept(expr);
        this.rparen();
        this.space();
        this.nestedStatementPush(body);
        this.accept(body);
        this.nestedStatementPop(body);
        return false;
    }

    @Override
    public boolean visit(JSwitchStatement x, Context ctx) {
        return this.writeSwitch(x.getExpr(), x.getBody());
    }

    @Override
    public boolean visit(JThisRef x, Context ctx) {
        this.print(CHARS_THIS);
        return false;
    }

    @Override
    public boolean visit(JThrowStatement x, Context ctx) {
        this.print(CHARS_THROW);
        if (x.getExpr() != null) {
            this.space();
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(JTryStatement x, Context ctx) {
        this.print(CHARS_TRY);
        this.accept(x.getTryBlock());
        for (JTryStatement.CatchClause clause : x.getCatchClauses()) {
            this.print(CHARS_CATCH);
            this.lparen();
            Iterator<JType> it = clause.getTypes().iterator();
            this.printTypeName(it.next());
            while (it.hasNext()) {
                this.print(CHARS_PIPE);
                this.printTypeName(it.next());
            }
            this.space();
            this.printName(clause.getArg().getTarget());
            this.rparen();
            this.space();
            this.accept(clause.getBlock());
        }
        if (x.getFinallyBlock() != null) {
            this.print(CHARS_FINALLY);
            this.accept(x.getFinallyBlock());
        }
        return false;
    }

    @Override
    public boolean visit(JWhileStatement x, Context ctx) {
        this.print(CHARS_WHILE);
        this.lparen();
        this.accept(x.getTestExpr());
        this.rparen();
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(JYieldStatement x, Context ctx) {
        this.print(CHARS_YIELD);
        this.space();
        this.accept(x.getExpr());
        return false;
    }

    protected void closeBlock() {
        this.indentOut();
        this.print('}');
    }

    protected void lparen() {
        this.print('(');
    }

    protected boolean nestedStatementPop(JStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JBlock);
        if (pop) {
            this.indentOut();
        }
        return pop;
    }

    protected boolean nestedStatementPush(JStatement statement) {
        boolean push;
        boolean bl = push = !(statement instanceof JBlock);
        if (push) {
            this.indentIn();
            this.newline();
        } else {
            this.space();
        }
        return push;
    }

    protected void openBlock() {
        this.print('{');
        this.indentIn();
        this.newline();
    }

    protected boolean parenPop(int parentPrec, JExpression child) {
        int childPrec = JavaPrecedenceVisitor.exec(child);
        if (parentPrec < childPrec) {
            this.rparen();
            return true;
        }
        return false;
    }

    protected boolean parenPop(JExpression parent, JExpression child) {
        return this.parenPop(JavaPrecedenceVisitor.exec(parent), child);
    }

    protected boolean parenPush(int parentPrec, JExpression child) {
        int childPrec = JavaPrecedenceVisitor.exec(child);
        if (parentPrec < childPrec) {
            this.lparen();
            return true;
        }
        return false;
    }

    protected boolean parenPush(JExpression parent, JExpression child) {
        return this.parenPush(JavaPrecedenceVisitor.exec(parent), child);
    }

    protected void printAbstractFlag(CanBeAbstract x) {
        if (x.isAbstract()) {
            this.print(CHARS_ABSTRACT);
        }
    }

    protected void printBooleanLiteral(boolean value) {
        this.print(value ? CHARS_TRUE : CHARS_FALSE);
    }

    protected void printChar(char c) {
        switch (c) {
            case '\b': {
                this.print("\\b");
                break;
            }
            case '\t': {
                this.print("\\t");
                break;
            }
            case '\n': {
                this.print("\\n");
                break;
            }
            case '\f': {
                this.print("\\f");
                break;
            }
            case '\r': {
                this.print("\\r");
                break;
            }
            case '\"': {
                this.print("\\\"");
                break;
            }
            case '\'': {
                this.print("\\'");
                break;
            }
            case '\\': {
                this.print("\\\\");
                break;
            }
            default: {
                if (Character.isISOControl(c)) {
                    this.print("\\u");
                    if (c < '\u1000') {
                        this.print('0');
                    }
                    if (c < '\u0100') {
                        this.print('0');
                    }
                    if (c < '\u0010') {
                        this.print('0');
                    }
                    this.print(Integer.toHexString(c));
                    break;
                }
                this.print(c);
            }
        }
    }

    protected void printCharLiteral(char value) {
        this.print('\'');
        this.printChar(value);
        this.print('\'');
    }

    protected void printDoubleLiteral(double value) {
        this.print(Double.toString(value));
    }

    protected void printFinalFlag(CanBeFinal x) {
        if (x.isFinal()) {
            this.print(CHARS_FINAL);
        }
    }

    protected void printLongLiteral(long value) {
        this.print(Long.toString(value));
        this.print('L');
    }

    protected void printMethodHeader(JMethod x) {
        switch (x.getAccess()) {
            case PUBLIC: {
                this.print(CHARS_PUBLIC);
                break;
            }
            case PROTECTED: {
                this.print(CHARS_PROTECTED);
                break;
            }
            case PRIVATE: {
                this.print(CHARS_PRIVATE);
                break;
            }
        }
        this.printStaticFlag(x);
        this.printAbstractFlag(x);
        this.printNativeFlag(x);
        this.printFinalFlag(x);
        this.printType(x);
        this.space();
        this.printName(x);
        this.printParameterList(x);
    }

    protected void printName(HasName x) {
        this.print(x.getName());
    }

    protected void printNativeFlag(JMethod x) {
        if (x.isJsniMethod()) {
            this.print(CHARS_NATIVE);
        }
    }

    protected void printParameterList(JMethod x) {
        this.lparen();
        this.visitCollectionWithCommas(x.getParams().iterator());
        this.rparen();
    }

    protected void printStaticFlag(CanBeStatic x) {
        if (x.isStatic()) {
            this.print(CHARS_STATIC);
        }
    }

    protected void printStringLiteral(String string) {
        char[] s = string.toCharArray();
        this.print('\"');
        for (char value : s) {
            this.printChar(value);
        }
        this.print('\"');
    }

    protected void printType(HasType hasType) {
        this.printTypeName(hasType.getType());
    }

    protected void printTypeName(JType type) {
        if (type instanceof JReferenceType) {
            this.print(type.getShortName());
        } else {
            this.print(type.getName());
        }
    }

    protected void rparen() {
        this.print(')');
    }

    protected void semi() {
        this.print(';');
    }

    protected boolean shouldPrintMethodBody() {
        return false;
    }

    protected void space() {
        this.print(' ');
    }

    protected void visitCollectionWithCommas(Iterator<? extends JNode> iter) {
        this.visitCollectionWith(CHARS_COMMA, iter);
    }

    protected void visitCollectionWith(char[] ch, Iterator<? extends JNode> iter) {
        if (iter.hasNext()) {
            this.accept(iter.next());
        }
        while (iter.hasNext()) {
            this.print(ch);
            this.accept(iter.next());
        }
    }
}

