/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceInfoCorrelation;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsSuperVisitor;
import com.google.gwt.dev.util.collect.Stack;

public class SourceInfoCorrelator {
    public static void exec(JProgram program) {
        new SourceInfoVisitor().accept(program);
    }

    private static class SourceInfoVisitor
    extends JVisitor {
        private CorrelationFactory factory = CorrelationFactory.RealCorrelationFactory.INSTANCE;
        private SourceInfoJsVisitor jsVisitor = new SourceInfoJsVisitor();
        private Stack<SourceInfoCorrelation> parents = new Stack();

        private SourceInfoVisitor() {
        }

        @Override
        public void endVisit(JClassLiteral x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(Correlation.Literal.CLASS));
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JDeclaredType x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(x));
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JField x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(x));
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(x));
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JNode x, Context ctx) {
            SourceInfo popped = this.parents.pop();
            assert (popped == x.getSourceInfo());
        }

        @Override
        public void endVisit(JProgram x, Context ctx) {
            SourceInfo popped = this.parents.pop();
            assert (popped == null);
        }

        @Override
        public void endVisit(JsniMethodBody x, Context ctx) {
            this.jsVisitor.accept(x.getFunc());
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JStringLiteral x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(Correlation.Literal.STRING));
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            x.getSourceInfo().addCorrelation(this.factory.by(x.getField()));
            super.endVisit(x, ctx);
        }

        @Override
        public boolean visit(JNode x, Context ctx) {
            SourceInfo info = x.getSourceInfo();
            info = this.pushAndConvert(info);
            x.setSourceInfo(info);
            return true;
        }

        @Override
        public boolean visit(JProgram x, Context ctx) {
            this.parents.push(null);
            return true;
        }

        protected SourceInfo pushAndConvert(SourceInfo info) {
            if (info instanceof SourceOrigin) {
                SourceOrigin origin = (SourceOrigin)info;
                SourceInfoCorrelation parent = this.parents.peek();
                info = parent != null ? new SourceInfoCorrelation(parent, origin) : new SourceInfoCorrelation(origin);
            }
            this.parents.push((SourceInfoCorrelation)info);
            return info;
        }

        private class SourceInfoJsVisitor
        extends JsSuperVisitor {
            private SourceInfoJsVisitor() {
            }

            @Override
            public void endVisit(JsNode x, JsContext ctx) {
                SourceInfo popped = (SourceInfo)SourceInfoVisitor.this.parents.pop();
                assert (popped == x.getSourceInfo());
            }

            @Override
            public void endVisit(JsStringLiteral x, JsContext ctx) {
                x.getSourceInfo().addCorrelation(SourceInfoVisitor.this.factory.by(Correlation.Literal.STRING));
                super.endVisit(x, ctx);
            }

            @Override
            public boolean visit(JsNode x, JsContext ctx) {
                SourceInfo info = x.getSourceInfo();
                info = SourceInfoVisitor.this.pushAndConvert(info);
                x.setSourceInfo(info);
                return true;
            }
        }
    }
}

