/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.ToStringGenerationVisitor;
import com.google.gwt.dev.util.TextOutput;

public class SourceGenerationVisitor
extends ToStringGenerationVisitor {
    public SourceGenerationVisitor(TextOutput textOutput) {
        super(textOutput);
    }

    @Override
    public boolean visit(JClassType x, Context ctx) {
        this.printAbstractFlag(x);
        this.printFinalFlag(x);
        this.print(CHARS_CLASS);
        this.space();
        if (x.getSuperClass() != null) {
            this.print(CHARS_EXTENDS);
            this.printTypeName(x.getSuperClass());
            this.space();
        }
        if (x.getImplements().size() > 0) {
            this.print(CHARS_IMPLEMENTS);
            int c = x.getImplements().size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    this.print(CHARS_COMMA);
                }
                this.printTypeName(x.getImplements().get(i));
            }
            this.space();
        }
        this.openBlock();
        for (JField field : x.getFields()) {
            this.accept(field);
            this.newline();
            this.newline();
        }
        for (JMethod method : x.getMethods()) {
            JMethodBody body;
            if (JProgram.isClinit(method) && (body = (JMethodBody)method.getBody()).getBlock().getStatements().isEmpty()) continue;
            this.accept(method);
            this.newline();
            this.newline();
        }
        this.closeBlock();
        return false;
    }

    @Override
    public boolean visit(JInterfaceType x, Context ctx) {
        this.print(CHARS_INTERFACE);
        this.printTypeName(x);
        this.space();
        if (x.getImplements().size() > 0) {
            this.print(CHARS_EXTENDS);
            int c = x.getImplements().size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    this.print(CHARS_COMMA);
                }
                this.printTypeName(x.getImplements().get(i));
            }
            this.space();
        }
        this.openBlock();
        for (JField field : x.getFields()) {
            this.accept(field);
            this.newline();
            this.newline();
        }
        for (JMethod method : x.getMethods()) {
            JMethodBody body;
            if (JProgram.isClinit(method) && (body = (JMethodBody)method.getBody()).getBlock().getStatements().isEmpty()) continue;
            this.accept(method);
            this.newline();
            this.newline();
        }
        this.closeBlock();
        return false;
    }

    @Override
    public boolean visit(JProgram x, Context ctx) {
        for (int i = 0; i < x.getDeclaredTypes().size(); ++i) {
            JDeclaredType type = x.getDeclaredTypes().get(i);
            this.accept(type);
            this.newline();
            this.newline();
        }
        return false;
    }

    @Override
    protected boolean shouldPrintMethodBody() {
        return true;
    }
}

