/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import java.util.List;

public class Simplifier {
    private static JExpression maybeGetNegatedExpressionArgument(JExpression expression) {
        JPrefixOperation prefixOperation;
        if (expression instanceof JPrefixOperation && (prefixOperation = (JPrefixOperation)expression).getOp() == JUnaryOperator.NOT && !Simplifier.isFloatingPointComparison(prefixOperation.getArg())) {
            return prefixOperation.getArg();
        }
        return null;
    }

    private static <T> List<T> allButLast(List<T> list) {
        return list.subList(0, list.size() - 1);
    }

    private static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    private Simplifier() {
    }

    public static JExpression cast(JType type, JExpression exp) {
        return Simplifier.simplifyCast(new JCastOperation(exp.getSourceInfo(), type, exp));
    }

    public static JExpression simplifyCast(JCastOperation castExpression) {
        JValueLiteral valueLiteral;
        JPrimitiveType primitiveType;
        JValueLiteral simplifiedExpression;
        JExpression argument;
        SourceInfo info = castExpression.getSourceInfo();
        JType type = castExpression.getCastType();
        if (type == (argument = castExpression.getExpr()).getType()) {
            return argument;
        }
        if (argument instanceof JMultiExpression) {
            JMultiExpression argumentAsMultiExpression = (JMultiExpression)argument;
            JMultiExpression simplifiedExpression2 = new JMultiExpression(info, new JExpression[0]);
            simplifiedExpression2.addExpressions(Simplifier.allButLast(argumentAsMultiExpression.getExpressions()));
            simplifiedExpression2.addExpressions(Simplifier.simplifyCast(new JCastOperation(info, type, Simplifier.last(argumentAsMultiExpression.getExpressions()))));
            return simplifiedExpression2;
        }
        if (type.isPrimitiveType() && argument instanceof JValueLiteral && (simplifiedExpression = (primitiveType = (JPrimitiveType)type).coerce(valueLiteral = (JValueLiteral)argument)) != null) {
            return simplifiedExpression;
        }
        if (type == JPrimitiveType.INT && (argument.getType() == JPrimitiveType.SHORT || argument.getType() == JPrimitiveType.BYTE)) {
            return argument;
        }
        return castExpression;
    }

    public static JExpression simplifyConditional(JConditional expression) {
        SourceInfo info = expression.getSourceInfo();
        JType type = expression.getType();
        JExpression conditionExpression = expression.getIfTest();
        JExpression thenExpression = expression.getThenExpr();
        JExpression elseExpression = expression.getElseExpr();
        if (conditionExpression instanceof JMultiExpression) {
            JMultiExpression conditionMultiExpression = (JMultiExpression)conditionExpression;
            JMultiExpression simplifiedExpression = new JMultiExpression(info, new JExpression[0]);
            simplifiedExpression.addExpressions(Simplifier.allButLast(conditionMultiExpression.getExpressions()));
            simplifiedExpression.addExpressions(Simplifier.simplifyConditional(new JConditional(info, type, Simplifier.last(conditionMultiExpression.getExpressions()), thenExpression, elseExpression)));
            return simplifiedExpression;
        }
        if (conditionExpression instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)conditionExpression).getValue() ? thenExpression : elseExpression;
        }
        if (thenExpression instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)thenExpression).getValue() ? Simplifier.or(info, conditionExpression, elseExpression) : Simplifier.and(info, Simplifier.negate(conditionExpression.getSourceInfo(), conditionExpression), elseExpression);
        }
        if (elseExpression instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)elseExpression).getValue() ? Simplifier.or(info, Simplifier.negate(conditionExpression.getSourceInfo(), conditionExpression), thenExpression) : Simplifier.and(info, conditionExpression, thenExpression);
        }
        JExpression negatedExpressionArgument = Simplifier.maybeGetNegatedExpressionArgument(conditionExpression);
        if (negatedExpressionArgument != null) {
            return Simplifier.simplifyConditional(new JConditional(info, type, negatedExpressionArgument, elseExpression, thenExpression));
        }
        return expression;
    }

    public static JStatement simplifyIfStatement(JIfStatement ifStatement, JType methodReturnType) {
        JExpression negationArugment;
        SourceInfo info = ifStatement.getSourceInfo();
        JExpression conditionExpression = ifStatement.getIfExpr();
        JStatement thenStmt = ifStatement.getThenStmt();
        JStatement elseStmt = ifStatement.getElseStmt();
        if (conditionExpression instanceof JMultiExpression) {
            JMultiExpression condMulti = (JMultiExpression)conditionExpression;
            JBlock simplifiedStatement = new JBlock(info, new JStatement[0]);
            for (JExpression expr : Simplifier.allButLast(condMulti.getExpressions())) {
                simplifiedStatement.addStmt(expr.makeStatement());
            }
            simplifiedStatement.addStmt(Simplifier.simplifyIfStatement(new JIfStatement(info, Simplifier.last(condMulti.getExpressions()), thenStmt, elseStmt), methodReturnType));
            return simplifiedStatement;
        }
        if (conditionExpression instanceof JBooleanLiteral) {
            boolean conditionValue = ((JBooleanLiteral)conditionExpression).getValue();
            if (conditionValue && !JjsUtils.isEmptyBlock(thenStmt)) {
                return thenStmt;
            }
            if (!conditionValue && !JjsUtils.isEmptyBlock(elseStmt)) {
                return elseStmt;
            }
            return conditionExpression.makeStatement();
        }
        if (JjsUtils.isEmptyBlock(thenStmt) && JjsUtils.isEmptyBlock(elseStmt)) {
            return conditionExpression.makeStatement();
        }
        if (!JjsUtils.isEmptyBlock(elseStmt) && (negationArugment = Simplifier.maybeGetNegatedExpressionArgument(conditionExpression)) != null) {
            thenStmt = Simplifier.ensureBlock(thenStmt);
            elseStmt = Simplifier.ensureBlock(elseStmt);
            return Simplifier.simplifyIfStatement(new JIfStatement(info, negationArugment, elseStmt, thenStmt), methodReturnType);
        }
        JStatement rewritenStatement = Simplifier.rewriteIfStatementAsExpression(info, conditionExpression, thenStmt, elseStmt, methodReturnType);
        if (rewritenStatement != null) {
            return rewritenStatement;
        }
        return ifStatement;
    }

    public static JExpression simplifyNot(JPrefixOperation expression) {
        JPrefixOperation prefixExpression;
        JExpression argument = expression.getArg();
        if (Simplifier.isFloatingPointComparison(argument)) {
            return expression;
        }
        SourceInfo info = expression.getSourceInfo();
        if (argument instanceof JMultiExpression) {
            JMultiExpression multiExpression = (JMultiExpression)argument;
            JMultiExpression simplifiedExpression = new JMultiExpression(info, new JExpression[0]);
            simplifiedExpression.addExpressions(Simplifier.allButLast(multiExpression.getExpressions()));
            simplifiedExpression.addExpressions(Simplifier.negate(info, Simplifier.last(multiExpression.getExpressions())));
            return simplifiedExpression;
        }
        if (argument instanceof JBinaryOperation) {
            JBinaryOperation binaryExpression = (JBinaryOperation)argument;
            switch (binaryExpression.getOp()) {
                case EQ: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.NEQ, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
                case NEQ: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.EQ, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
                case GT: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.LTE, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
                case LTE: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.GT, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
                case GTE: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.LT, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
                case LT: {
                    return new JBinaryOperation(info, binaryExpression.getType(), JBinaryOperator.GTE, binaryExpression.getLhs(), binaryExpression.getRhs());
                }
            }
        }
        if (argument instanceof JPrefixOperation && (prefixExpression = (JPrefixOperation)argument).getOp() == JUnaryOperator.NOT) {
            return prefixExpression.getArg();
        }
        if (argument instanceof JBooleanLiteral) {
            JBooleanLiteral booleanLiteral = (JBooleanLiteral)argument;
            return JBooleanLiteral.get(!booleanLiteral.getValue());
        }
        return expression;
    }

    private static boolean isFloatingPointComparison(JExpression expr) {
        if (expr instanceof JBinaryOperation) {
            JBinaryOperation binaryOperation = (JBinaryOperation)expr;
            return binaryOperation.getType() == JPrimitiveType.BOOLEAN && (binaryOperation.getLhs().getType() == JPrimitiveType.FLOAT || binaryOperation.getLhs().getType() == JPrimitiveType.DOUBLE || binaryOperation.getRhs().getType() == JPrimitiveType.FLOAT || binaryOperation.getRhs().getType() == JPrimitiveType.DOUBLE);
        }
        return false;
    }

    private static JExpression negate(SourceInfo info, JExpression argument) {
        return Simplifier.simplifyNot(new JPrefixOperation(info, JUnaryOperator.NOT, argument));
    }

    public static JExpression simplifyAnd(JBinaryOperation expression) {
        assert (expression.getOp() == JBinaryOperator.AND) : "Simplifier.and was called with " + expression;
        JExpression lhs = expression.getLhs();
        JExpression rhs = expression.getRhs();
        SourceInfo info = expression.getSourceInfo();
        if (lhs instanceof JMultiExpression) {
            JMultiExpression lhsMultiExpression = (JMultiExpression)lhs;
            JMultiExpression simplifiedExpression = new JMultiExpression(info, new JExpression[0]);
            simplifiedExpression.addExpressions(Simplifier.allButLast(lhsMultiExpression.getExpressions()));
            simplifiedExpression.addExpressions(Simplifier.and(info, Simplifier.last(lhsMultiExpression.getExpressions()), rhs));
            return simplifiedExpression;
        }
        if (lhs instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)lhs).getValue() ? rhs : lhs;
        }
        if (rhs instanceof JBooleanLiteral) {
            if (((JBooleanLiteral)rhs).getValue()) {
                return lhs;
            }
            if (!lhs.hasSideEffects()) {
                return rhs;
            }
        }
        return expression;
    }

    private static JExpression and(SourceInfo info, JExpression lhs, JExpression rhs) {
        return Simplifier.simplifyAnd(new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.AND, lhs, rhs));
    }

    public static JExpression simplifyOr(JBinaryOperation expression) {
        assert (expression.getOp() == JBinaryOperator.OR) : "Simplifier.or was called with " + expression;
        JExpression lhs = expression.getLhs();
        JExpression rhs = expression.getRhs();
        SourceInfo info = expression.getSourceInfo();
        if (lhs instanceof JMultiExpression) {
            JMultiExpression lhsMultiExpression = (JMultiExpression)lhs;
            JMultiExpression simplifiedExpression = new JMultiExpression(info, new JExpression[0]);
            simplifiedExpression.addExpressions(Simplifier.allButLast(lhsMultiExpression.getExpressions()));
            simplifiedExpression.addExpressions(Simplifier.or(info, Simplifier.last(lhsMultiExpression.getExpressions()), rhs));
            return simplifiedExpression;
        }
        if (lhs instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)lhs).getValue() ? lhs : rhs;
        }
        if (rhs instanceof JBooleanLiteral) {
            if (!((JBooleanLiteral)rhs).getValue()) {
                return lhs;
            }
            if (!lhs.hasSideEffects()) {
                return rhs;
            }
        }
        return expression;
    }

    private static JExpression or(SourceInfo info, JExpression lhs, JExpression rhs) {
        return Simplifier.simplifyOr(new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.OR, lhs, rhs));
    }

    private static JStatement ensureBlock(JStatement statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof JBlock) {
            return statement;
        }
        return new JBlock(statement.getSourceInfo(), statement);
    }

    private static JExpression extractExpression(JStatement statement) {
        if (statement instanceof JExpressionStatement) {
            return ((JExpressionStatement)statement).getExpr();
        }
        return null;
    }

    private static JStatement extractSingleStatement(JStatement statement) {
        JBlock block;
        if (statement instanceof JBlock && (block = (JBlock)statement).getStatements().size() == 1) {
            return Simplifier.extractSingleStatement(block.getStatements().get(0));
        }
        return statement;
    }

    private static JStatement rewriteIfStatementAsExpression(SourceInfo sourceInfo, JExpression conditionExpression, JStatement thenStmt, JStatement elseStmt, JType methodReturnType) {
        thenStmt = Simplifier.extractSingleStatement(thenStmt);
        elseStmt = Simplifier.extractSingleStatement(elseStmt);
        if (thenStmt instanceof JReturnStatement && elseStmt instanceof JReturnStatement && methodReturnType != null) {
            JExpression thenExpression = ((JReturnStatement)thenStmt).getExpr();
            JExpression elseExpression = ((JReturnStatement)elseStmt).getExpr();
            if (thenExpression == null || elseExpression == null) {
                return null;
            }
            return new JConditional(sourceInfo, methodReturnType, conditionExpression, thenExpression, elseExpression).makeReturnStatement();
        }
        if (elseStmt != null) {
            JExpression thenExpression = Simplifier.extractExpression(thenStmt);
            JExpression elseExpression = Simplifier.extractExpression(elseStmt);
            if (thenExpression != null && elseExpression != null) {
                return new JConditional(sourceInfo, JPrimitiveType.VOID, conditionExpression, thenExpression, elseExpression).makeStatement();
            }
        } else {
            JExpression thenExpression = Simplifier.extractExpression(thenStmt);
            if (thenExpression != null) {
                JBinaryOperator binaryOperator = JBinaryOperator.AND;
                JExpression negationArgument = Simplifier.maybeGetNegatedExpressionArgument(conditionExpression);
                if (negationArgument != null) {
                    conditionExpression = negationArgument;
                    binaryOperator = JBinaryOperator.OR;
                }
                return new JBinaryOperation(sourceInfo, JPrimitiveType.VOID, binaryOperator, conditionExpression, thenExpression).makeStatement();
            }
        }
        return null;
    }
}

